// 配置参数
const FETCH_INTERVAL = 10000; // 30秒，单位：毫秒
const REQUEST_TIMEOUT = 15000; // 请求超时时间，15秒
const BET_HANDLER_API = 'http://103.80.27.253/Extens/Tel/API/betHandler.php'; // 投注记录处理API

// 账号列表
const accounts = [
    { username: 'TelSms201', password: 'Abab7878' }
];
let currentAccountIndex = 0; // 当前使用的账号索引，用于轮流切换

let fetchTimer = null; // 定时器实例
let isProcessing = false; // 流程状态锁，防止并发执行
let chDomainUid = null; // _CHDomain.uid

// 初始化：启动定时器
init();

/**
 * 获取当前网页的基础API URL（使用当前域名）
 * @returns {string} 当前域名的基础API URL
 */
function getBaseApiUrl() {
    const protocol = window.location.protocol;
    const hostname = window.location.hostname;
    return `${protocol}//${hostname}/transform.php`;
}

/**
 * 生成当前日期的版本字符串
 * @returns {string} 动态生成的版本字符串
 */
function getCurrentVersionString() {
    const today = new Date();
    const year = today.getFullYear();
    const month = String(today.getMonth() + 1).padStart(2, '0');
    const day = String(today.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}-Glive_112`;
}

/**
 * 初始化：启动定时任务
 */
function init() {

    // 等待主页面和iframe加载完成
    waitForPageAndIframeReady();
    
    /** 
    const htmlContent = document.documentElement.outerHTML;
    const parser = new DOMParser();
    const doc = parser.parseFromString(htmlContent, 'text/html');

    // 查找所有内联script标签（排除外部脚本）
    const scripts = doc.querySelectorAll('script:not([src])');

    // 正则表达式匹配 _CHDomain.uid 的赋值语句
    // 支持单引号、双引号或无引号的情况（根据实际代码格式调整）
    const uidRegex = /_CHDomain\.uid\s*=\s*['"]([^'"]+)['"]/i;

    // 遍历所有内联脚本
    scripts.forEach(script => {
        const scriptContent = script.innerText || script.textContent;
        if (scriptContent) {
            const match = scriptContent.match(uidRegex);
            if (match && match[1]) {
                chDomainUid = match[1];
            }
        }
    });

    // 输出结果
    if (chDomainUid) {
        console.log('从script标签中提取到_CHDomain.uid：', chDomainUid);
        // 这里可以处理提取到的uid（例如 'et7efciejm38917869l6393621b1'）
    } else {
        console.log('未找到_CHDomain.uid的赋值语句');
    }

    */

    if (fetchTimer) {
        clearInterval(fetchTimer);
        fetchTimer = null;
        console.log('已清除旧的数据抓取定时器');
    }

    // 立即执行一次，然后开始定时执行
    runCycle();
    fetchTimer = setInterval(runCycle, FETCH_INTERVAL);
    console.log(`=== 数据抓取定时器已启动（间隔${FETCH_INTERVAL/1000}秒） ===`);
    console.log(`当前使用的基础域名: ${window.location.hostname}`);

     // 设置页面定时刷新
     setInterval(() => {
            window.location.reload();
     }, 1800000); // 30分钟



}

/**
 * 执行完整周期：登录 → 获取未投注记录 → 执行投注 → 更新状态
 */
async function runCycle() {
    if (isProcessing) {
        console.log('上一次处理尚未完成，跳过本次执行');
        return;
    }

    const cycleStartTime = new Date().toLocaleTimeString();
    console.log(`\n=== [${cycleStartTime}] 开始新的处理周期 ===`);
    console.log(`当前使用的API域名：${window.location.hostname}`);
   // console.log(`当前使用的版本字符串：${getCurrentVersionString()}`);

    try {
        
        
       
        // 2. 获取最新未投注记录
        console.log('=== 获取最新未投注记录 ===');
        const betRecord = await getLatestUnbetRecord();
        
        if (betRecord) {
            isProcessing = true;
            console.log('找到未投注记录:', betRecord);
             // 1. 登录
        console.log('=== 开始登录流程 ===');
        const uid = await loginWithRetry();
        console.log(`=== 登录成功，uid: ${uid} ===`);

        // 1.1 检查登录状态
        console.log('=== 获取当前版本号 ===');
        const version = await getCurrentVersion(uid);
        console.log('当前版本号:', version);
       
            // 3. 执行投注
            console.log('=== 执行投注操作 ===');

             console.log('=== 读取订单数据 ===');
             const orderData = await readOrderData(betRecord,uid,version);
             console.log('获取订单数据:', orderData);
            
            if(orderData.length>0){
                console.log('获取到的uid:', uid);
                const betResult = await executeBet(betRecord, uid, version,orderData);
                console.log('投注结果:', betResult);
                 // 4. 更新投注状态
                console.log('=== 更新投注状态 ===');
                const updateResult = await updateBetStatus(betRecord.id, betResult.success);
                console.log('状态更新结果:', updateResult);
            }else{
                const updateResult = await updateBetStatus(betRecord.id, false);
                console.log('订单数据为空，更新状态为false',  updateResult  );
            }
            
           
        } else {
            console.log('没有找到需要处理的未投注记录');
        }

        console.log(`=== [${new Date().toLocaleTimeString()}] 处理周期完成 ===`);

    } catch (error) {
        console.error(`=== [${new Date().toLocaleTimeString()}] 处理周期失败 ===`, error.message);
    } finally {
        isProcessing = false;
    }
}

/**
 * 获取最新的未投注记录（status=0）
 */
async function getLatestUnbetRecord() {
    try {
        const res = await Promise.race([
            fetch(BET_HANDLER_API+'?hgname='+accounts[0].username+'&hgpass='+accounts[0].password, {
                method: 'GET'
            }),
            timeoutPromise(REQUEST_TIMEOUT, '获取未投注记录超时')
        ]);

        if (!res.ok) throw new Error(`获取未投注记录失败 [HTTP ${res.status}]`);

        const result = await res.json();
        
        if (!result.success) throw new Error(result.message || '获取未投注记录失败');
        
        return result.data;
    } catch (error) {
        console.error('获取未投注记录出错:', error.message);
        throw error;
    }
}

/**
 * 执行读取订单
 * @param {Object} betRecord - 投注记录
 * @param {string} uid - 当前登录用户ID
 * @param {string} version - 当前版本号
 */
async function readOrderData(betRecord, uid, version) {
    try {
        const betData = {
            ...betRecord,
            uid: uid,
            timestamp: new Date().getTime(),
            ver: getCurrentVersionString()
        };

        // 构建投注参数对象
        const betParams = {
            p: 'FT_order_view',
            uid: uid,
            ver: version,
            langx: 'zh-cn',
            odd_f_type: 'H',//H 盘口 大小球
            gid: betRecord.game_id,
            gtype: 'FT',
            wtype: betRecord.wtype,// OU 大小球   R 让球
            chose_team: betRecord.chose_team,// C 大球  H  小球   C受让  H让球
        };

        // 构建URL编码的表单数据字符串
        let formDataString = '';
        Object.entries(betParams).forEach(([key, value], index) => {
            // 对键值进行URL编码
            const encodedKey = encodeURIComponent(key);
            const encodedValue = encodeURIComponent(value);
            // 添加分隔符&，第一个参数前不加
            if (index > 0) {
                formDataString += '&';
            }
            formDataString += `${encodedKey}=${encodedValue}`;
        });

      
        const loginUrl = `${getBaseApiUrl()}?ver=${version}`;
      
        const res = await requestUtils.fetchWithRetry(loginUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                credentials: 'include', // 确保请求携带cookies
                body: formDataString
            });
            
         

        if (!res.ok) throw new Error(`读取注单失败 [HTTP ${res.status}]`);

        const xmlStr = await res.text();

        const xmlDoc = parseXml(xmlStr);
        
        const errorCode = xmlDoc.querySelector('code');
        if (errorCode?.textContent === 'error') {
            const errorMsg = xmlDoc.querySelector('msg')?.textContent || '未知错误';
            throw new Error(`获取注单错误: ${errorMsg}`);
        }

        const code = xmlDoc.querySelector('code')?.textContent;
        if (code==='501') {
            console.log('=== 读取订单数据成功 ===');
            // 提取所有需要的数据并返回对象
            const result = {
                code: code,
                game_sc: xmlDoc.querySelector('game_sc')?.textContent || '',
                game_so: xmlDoc.querySelector('game_so')?.textContent || '',
                mem_sc: xmlDoc.querySelector('mem_sc')?.textContent || '',
                mem_so: xmlDoc.querySelector('mem_so')?.textContent || '',
                gold_gmin: xmlDoc.querySelector('gold_gmin')?.textContent || '',
                gold_gmax: xmlDoc.querySelector('gold_gmax')?.textContent || '',
                maxcredit: xmlDoc.querySelector('maxcredit')?.textContent || '',
                con: xmlDoc.querySelector('con')?.textContent || '',
                ratio: xmlDoc.querySelector('ratio')?.textContent || '',
                ioratio: xmlDoc.querySelector('ioratio')?.textContent || '',
                spread: xmlDoc.querySelector('spread')?.textContent || '',
                strong: xmlDoc.querySelector('strong')?.textContent || '',
                restsinglecredit: xmlDoc.querySelector('restsinglecredit')?.textContent || '',
                league_id: xmlDoc.querySelector('league_id')?.textContent || '',
                dates: xmlDoc.querySelector('dates')?.textContent || '',
                times: xmlDoc.querySelector('times')?.textContent || '',
                num_c: xmlDoc.querySelector('num_c')?.textContent || '',
                num_h: xmlDoc.querySelector('num_h')?.textContent || '',
                team_id_c: xmlDoc.querySelector('team_id_c')?.textContent || '',
                team_id_h: xmlDoc.querySelector('team_id_h')?.textContent || '',
                currency: xmlDoc.querySelector('currency')?.textContent || '',
                currency_value: xmlDoc.querySelector('currency_value')?.textContent || '',
                ltype: xmlDoc.querySelector('ltype')?.textContent || '',
                pay_type: xmlDoc.querySelector('pay_type')?.textContent || '',
                username: xmlDoc.querySelector('username')?.textContent || '',
                aid: xmlDoc.querySelector('aid')?.textContent || '',
                ms: xmlDoc.querySelector('ms')?.textContent || '',
                league_name: xmlDoc.querySelector('league_name')?.textContent || '',
                team_name_c: xmlDoc.querySelector('team_name_c')?.textContent || '',
                team_name_h: xmlDoc.querySelector('team_name_h')?.textContent || '',
                max_gold: xmlDoc.querySelector('max_gold')?.textContent || '',
                dg: xmlDoc.querySelector('dg')?.textContent || '',
                ts: xmlDoc.querySelector('ts')?.textContent || '',
                ptype: xmlDoc.querySelector('ptype')?.textContent || '',
                important: xmlDoc.querySelector('important')?.textContent || '',
                systime: xmlDoc.querySelector('systime')?.textContent || '',
                fast_check: xmlDoc.querySelector('fast_check')?.textContent || ''
            };
            return [result]; // 返回包含对象的数组
        }
        console.log('=== 读取订单数据失败 ===');
        return []; // 失败时返回空数组
    } catch (error) {
        console.error('读取订单数据失败:', error.message);
        return [];
    }
}


/**
 * 执行投注操作
 * @param {Object} betRecord - 投注记录
 * @param {string} uid - 当前登录用户ID
 * @param {string} version - 当前版本号
 * @param {Array} orderData - 订单数据
 */
async function executeBet(betRecord, uid, version,orderData) {
    try {
        const betData = {
            ...betRecord,
            uid: uid,
            timestamp: new Date().getTime(),
            ver: getCurrentVersionString()
        };

        console.log('=== 执行投注数据 ===', betData);
        // 构建投注参数对象
        const betParams = {
            p: 'FT_bet',
            uid: uid,
            ver: version,
            langx: 'zh-cn',
            odd_f_type: 'H',//H 盘口 大小球
            golds: Math.abs(Math.floor(Number(betRecord.bet_money))), // 确保为正整数格式
            gid: betRecord.game_id,
            gtype: 'FT',
            wtype: betRecord.wtype,// OU 大小球   R 让球
            rtype: betRecord.rtype,// OUC 大球  OUH 小球   RH 让球  RC 受让
            chose_team: betRecord.chose_team,// C 大球  H  小球  H让球  C受让  让球H表示主队
            ioratio: orderData[0].ioratio,
            con: orderData[0].con,  //2  大球  -2 小球
            ratio: orderData[0].ratio,//-50 大球  50 小球
            autoOdd: 'Y',
            timestamp: new Date().getTime(), // 添加时间戳
            timestamp2: '', // 添加空时间戳2
            isRB: 'N',
            imp: 'N',
            ptype: '',
            isYesterday: 'N',
            f: '1R'
        };
        // 构建URL编码的表单数据字符串
        let formDataString = '';
        Object.entries(betParams).forEach(([key, value], index) => {
            // 对键值进行URL编码
            const encodedKey = encodeURIComponent(key);
            const encodedValue = encodeURIComponent(value);
            // 添加分隔符&，第一个参数前不加
            if (index > 0) {
                formDataString += '&';
            }
            formDataString += `${encodedKey}=${encodedValue}`;
        });

      
        const loginUrl = `${getBaseApiUrl()}?ver=${version}`;
      
        const res = await requestUtils.fetchWithRetry(loginUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                credentials: 'include', // 确保请求携带cookies
                body: formDataString
            });
            
         

        if (!res.ok) throw new Error(`投注失败 [HTTP ${res.status}]`);

        const xmlStr = await res.text();

        const xmlDoc = parseXml(xmlStr);
        
       

        const code = xmlDoc.querySelector('code')?.textContent;
        if (code==='560') {
            console.log('=== 投注成功 ===');
            return { success: true, message: '投注成功' };
        }
        console.log('=== 投注失败 ===');
        return { success: false, message: '投注失败'+code };
    } catch (error) {
        console.error('执行投注出错:', error.message);
        return { success: false, message: '投注失败'+error.message };
    }
}

const requestUtils = {
    delay(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    },
    async fetchWithRetry(url, options = {}, timeout = 10000, maxRetries = 1) {
        let retries = 0;
        while (retries <= maxRetries) {
            const controller = new AbortController();
            const signal = controller.signal;
            const timeoutId = setTimeout(() => controller.abort(), timeout);

            try {
                const defaultHeaders = {
                    'Referer': new URL(url).origin + '/'
                };
                
                const response = await fetch(url, { 
                    ...options, 
                    signal,
                    headers: { ...defaultHeaders, ...options.headers }
                });
                
                clearTimeout(timeoutId);

                if (!response.ok) {
                    if ([401, 403].includes(response.status)) {
                        throw new Error(`HTTP ${response.status}：登录状态失效`);
                    }
                    throw new Error(`HTTP错误: ${response.status}`);
                }

                return response;
            } catch (error) {
                clearTimeout(timeoutId);

                if (error.message.includes('504') || error.name === 'AbortError') {
                    retries++;
                    if (retries > maxRetries) break;
                    
                    const delay = 1000 * Math.pow(2, retries);
                    console.log(`%c[${getCurrentTime()}] [请求重试] (${retries}/${maxRetries})，等待 ${delay}ms`, logStyles.info);
                    await this.delay(delay);
                } else {
                    throw error;
                }
            }
        }

        throw new Error(`达到最大重试次数 (${maxRetries})`);
    },
    async fetchAPIData(url) {
        const response = await this.fetchWithRetry(url);
        const data = await response.json();
        
        if (data.error) {
            throw new Error(`API错误: ${data.error}`);
        }
        
        return data;
    }
};


/**
 * 更新投注状态
 * @param {number} betId - 投注记录ID
 * @param {boolean} success - 投注是否成功
 */
async function updateBetStatus(betId, success) {
    try {
        const res = await Promise.race([
            fetch(BET_HANDLER_API, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    id: betId,
                    success: success
                })
            }),
            timeoutPromise(REQUEST_TIMEOUT, '更新投注状态超时')
        ]);

        if (!res.ok) throw new Error(`更新投注状态失败 [HTTP ${res.status}]`);

        const result = await res.json();
        return result;
    } catch (error) {
        console.error('更新投注状态出错:', error.message);
        throw error;
    }
}

// 以下是之前已实现的函数，保持不变
async function loginWithRetry() {
    let lastError = null;
    const initialIndex = currentAccountIndex;
    
    for (let i = 0; i < accounts.length; i++) {
        const currentAccount = accounts[currentAccountIndex];
        console.log(`尝试登录账号: ${currentAccount.username} (第${i+1}/${accounts.length}次尝试)`);
        
        try {
            const uid = await login(currentAccount);
            currentAccountIndex = (currentAccountIndex + 1) % accounts.length;
            return uid;
        } catch (error) {
            lastError = error;
            console.error(`账号 ${currentAccount.username} 登录失败:`, error.message);
            currentAccountIndex = (currentAccountIndex + 1) % accounts.length;
            
            if (currentAccountIndex === initialIndex) {
                break;
            }
        }
    }
    
    throw new Error(`所有账号登录失败: ${lastError?.message || '未知错误'}`);
}

async function login(account) {
    try {
        const formData = new FormData();
        const loginParams = {
            p: 'chk_login',
            langx: 'zh-cn',
            ver: getCurrentVersionString(),
            username: account.username,
            password: account.password,
            app: 'N',
            auto: 'AZZCFC',
            userAgent: '',
            blackbox:''
        };
        
        Object.entries(loginParams).forEach(([k, v]) => formData.append(k, v));

        const loginUrl = `${getBaseApiUrl()}?ver=${encodeURIComponent(getCurrentVersionString())}`;
        const res = await Promise.race([
            fetch(loginUrl, {
                method: 'POST',
                body: formData,
                credentials: 'include',
                mode: 'cors'
            }),
            timeoutPromise(REQUEST_TIMEOUT, '登录请求超时')
        ]);

        if (!res.ok) throw new Error(`登录接口响应异常 [HTTP ${res.status}]`);

        const xmlStr = await res.text();
        const xmlDoc = parseXml(xmlStr);
        
        const errorCode = xmlDoc.querySelector('code');
        if (errorCode?.textContent === 'error') {
            const errorMsg = xmlDoc.querySelector('msg')?.textContent || '未知错误';
            throw new Error(`登录错误: ${errorMsg}`);
        }

        if (xmlDoc.querySelector('status')?.textContent !== '200') {
            throw new Error('登录状态码异常');
        }

        const newUid = xmlDoc.querySelector('uid')?.textContent;
        if (!newUid) throw new Error('登录响应中未找到uid');
        
        return newUid;

    } catch (error) {
        throw error;
    }
}

async function getCurrentVersion(uid) {
    try {
      
        const params = {
            p: 'get_version',
            langx: 'zh-cn',
            uid: uid
        };
        
         let formDataString = '';
        Object.entries(params).forEach(([key, value], index) => {
            // 对键值进行URL编码
            const encodedKey = encodeURIComponent(key);
            const encodedValue = encodeURIComponent(value);
            // 添加分隔符&，第一个参数前不加
            if (index > 0) {
                formDataString += '&';
            }
            formDataString += `${encodedKey}=${encodedValue}`;
        });

      
        const getVersionUrl = `${getBaseApiUrl()}`;
      
        const res = await requestUtils.fetchWithRetry(getVersionUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                credentials: 'include', // 确保请求携带cookies
                body: formDataString
            });

            
        if (!res.ok) throw new Error(`登录接口响应异常 [HTTP ${res.status}]`);

        const xmlStr = await res.text();

        const xmlDoc = parseXml(xmlStr);
        
        const errorCode = xmlDoc.querySelector('code');
        if (errorCode?.textContent === 'error') {
            const errorMsg = xmlDoc.querySelector('msg')?.textContent || '未知错误';
            throw new Error(`获取版本号错误: ${errorMsg}`);
        }

        const version = xmlDoc.querySelector('ver')?.textContent;
        if (!version) throw new Error('登录响应中未找到版本号');
        
        return version;

    } catch (error) {
        throw error;
    }
}

async function waitForPageAndIframeReady() {
    // 等待主页面加载
    if (document.readyState !== 'complete') {
        await new Promise(resolve => {
            window.addEventListener('load', resolve);
        });
    }
}


function parseXml(xmlStr) {
    const parser = new DOMParser();
    return parser.parseFromString(xmlStr, 'text/xml');
}

function timeoutPromise(ms, message) {
    return new Promise((_, reject) => {
        setTimeout(() => reject(new Error(message)), ms);
    });
}

/**
 * 注入一个脚本到页面上下文，用于获取全局变量
 * @returns {Promise<string|null>} 返回_CHDomain.uid的值或null
 */
function getCHDomainUid() {
  return new Promise((resolve) => {
    try {
      // 设置超时，防止无限等待
      const timeoutId = setTimeout(() => {
        console.warn('获取_CHDomain.uid超时');
        resolve(null);
        if (handler) {
          window.removeEventListener('chDomainUidEvent', handler);
        }
        if (script && document.body.contains(script)) {
          document.body.removeChild(script);
        }
        if (scriptUrl) {
          URL.revokeObjectURL(scriptUrl);
        }
      }, 5000); // 5秒超时
      
      let handler = null;
      let script = null;
      let scriptUrl = null;
      
      // 创建要注入的脚本代码
      const scriptCode = `
        (function() {
          try {
            // 获取目标值
            const uid = window._CHDomain && window._CHDomain.uid ? window._CHDomain.uid : null;
            
            // 创建自定义事件，将值传递出去
            const event = new CustomEvent('chDomainUidEvent', {
              detail: { uid: uid }
            });
            window.dispatchEvent(event);
          } catch (e) {
            console.error('获取_CHDomain.uid失败:', e);
          }
        })();
      `;
      
      // 创建Blob对象并生成URL（CSP兼容方式）
      const blob = new Blob([scriptCode], { type: 'text/javascript' });
      scriptUrl = URL.createObjectURL(blob);
      
      // 创建一个script标签
      script = document.createElement('script');
      script.src = scriptUrl;
      script.onload = () => {
        // 脚本加载完成后释放URL对象
        if (scriptUrl) {
          URL.revokeObjectURL(scriptUrl);
        }
      };
      
      script.onerror = () => {
        console.error('脚本加载失败');
        clearTimeout(timeoutId);
        resolve(null);
        if (handler) {
          window.removeEventListener('chDomainUidEvent', handler);
        }
        if (script && document.body.contains(script)) {
          document.body.removeChild(script);
        }
        if (scriptUrl) {
          URL.revokeObjectURL(scriptUrl);
        }
      };
      
      // 监听自定义事件，接收返回值
      handler = function(event) {
        clearTimeout(timeoutId);
        resolve(event.detail.uid);
        // 移除事件监听和注入的脚本，避免重复执行
        window.removeEventListener('chDomainUidEvent', handler);
        if (script && document.body.contains(script)) {
          document.body.removeChild(script);
        }
      };
      
      window.addEventListener('chDomainUidEvent', handler, { once: true });
      
      // 将脚本添加到页面中执行
      document.body.appendChild(script);
      
    } catch (e) {
      console.error('getCHDomainUid函数执行错误:', e);
      resolve(null);
    }
  });
}
