<?php
// 数据库配置


// 初始化数据库连接
try {
    $pdo = new PDO("mysql:host=$dbHost;port=$dbPort;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// 处理删除请求
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete') {
    $id = $_POST['id'];
    $stmt = $pdo->prepare("DELETE FROM TelSms_SysConfig WHERE Id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    echo json_encode(['status' => 'success']);
    exit;
}

// 处理添加或更新请求
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && ($_POST['action'] === 'add' || $_POST['action'] === 'update')) {
    $data = [
        'sitename' => $_POST['sitename'] ?? null,
        'ver' => $_POST['ver'] ?? null,
        'langx' => $_POST['langx'] ?? null,
        'login_chk' => $_POST['login_chk'] ?? null,
        'get_report_su' => $_POST['get_report_su'] ?? null,
        'get_report_ag' => $_POST['get_report_ag'] ?? null,
        'get_report_mem' => $_POST['get_report_mem'] ?? null,
        'get_report_list_bet' => $_POST['get_report_list_bet'] ?? null,
        'report_kind' => $_POST['report_kind'] ?? null,
        'result_type' => $_POST['result_type'] ?? null,
        'auto' => $_POST['auto'] ?? null,
        'totalBets' => $_POST['totalBets'] ?? null,
        'gtype' => $_POST['gtype'] ?? null,
        'get_wmc_list_bet' => $_POST['get_wmc_list_bet'] ?? null,
        'url1' => $_POST['url1'] ?? null,
        'url2' => $_POST['url2'] ?? null,
        'url3' => $_POST['url3'] ?? null,
        'url4' => $_POST['url4'] ?? null,
    ];
    
    if ($_POST['action'] === 'add') {
        $columns = implode(', ', array_keys($data));
        $placeholders = ':' . implode(', :', array_keys($data));
        $stmt = $pdo->prepare("INSERT INTO TelSms_SysConfig ($columns) VALUES ($placeholders)");
    } else {
        $id = $_POST['id'];
        $setClause = [];
        foreach (array_keys($data) as $key) {
            $setClause[] = "$key = :$key";
        }
        $setClause = implode(', ', $setClause);
        $stmt = $pdo->prepare("UPDATE TelSms_SysConfig SET $setClause WHERE Id = :id");
        $data['id'] = $id;
    }
    
    $stmt->execute($data);
    echo json_encode(['status' => 'success']);
    exit;
}

// 获取所有记录
$stmt = $pdo->query("SELECT * FROM TelSms_SysConfig");
$configs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TelSms System Configuration Management</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        telegram: {
                            blue: '#2AABEE',
                            dark: '#1E293B',
                            light: '#E2E8F0',
                            accent: '#36BFFA'
                        }
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style type="text/tailwindcss">
        @layer utilities {
            .content-auto {
                content-visibility: auto;
            }
            .telegram-shadow {
                box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
            }
            .telegram-hover {
                transition: all 0.3s cubic-bezier(.25,.8,.25,1);
            }
            .telegram-hover:hover {
                box-shadow: 0 14px 28px rgba(0,0,0,0.25), 0 10px 10px rgba(0,0,0,0.22);
            }
        }
    </style>
</head>
<body class="bg-gray-100 font-sans">
    <div class="container mx-auto px-4 py-8 max-w-7xl">
        <!-- Page Header -->
        <header class="mb-8">
            <div class="flex items-center justify-between">
                <h1 class="text-[clamp(1.5rem,3vw,2.5rem)] font-bold text-telegram-dark flex items-center">
                    <i class="fa fa-cogs text-telegram-blue mr-3"></i>
                    TelSms System Configuration
                </h1>
                <button id="addBtn" class="bg-telegram-blue hover:bg-telegram-accent text-white font-medium py-2 px-4 rounded-lg transition duration-300 flex items-center">
                    <i class="fa fa-plus mr-2"></i> Add Configuration
                </button>
            </div>
        </header>

        <!-- Data Table -->
        <div class="bg-white rounded-xl p-4 shadow-md telegram-shadow">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Id</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">sitename</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ver</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">langx</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200" id="configTableBody">
                        <?php foreach ($configs as $config): ?>
                        <tr class="telegram-hover">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($config['Id']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($config['sitename'] ?? ''); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($config['ver'] ?? ''); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($config['langx'] ?? ''); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <button class="editBtn text-telegram-blue hover:text-telegram-accent mr-4" data-id="<?php echo $config['Id']; ?>">
                                    <i class="fa fa-pencil"></i> Edit
                                </button>
                                <button class="deleteBtn text-red-500 hover:text-red-700" data-id="<?php echo $config['Id']; ?>">
                                    <i class="fa fa-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if (empty($configs)): ?>
            <div class="text-center py-8 text-gray-500">
                <i class="fa fa-info-circle text-2xl mb-2"></i>
                <p>No configuration records found, please add new configuration</p>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Add/Edit Modal -->
    <div id="configModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-xl w-full max-w-4xl max-h-[90vh] overflow-y-auto telegram-shadow">
            <div class="p-6 border-b border-gray-200">
                <div class="flex justify-between items-center">
                    <h2 id="modalTitle" class="text-xl font-bold text-gray-800">Add Configuration</h2>
                    <button id="closeModal" class="text-gray-500 hover:text-gray-700">
                        <i class="fa fa-times text-xl"></i>
                    </button>
                </div>
            </div>
            <div class="p-6">
                <form id="configForm">
                    <input type="hidden" id="configId">
                    <input type="hidden" id="formAction" value="add">
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="sitename" class="block text-sm font-medium text-gray-700 mb-1">sitename</label>
                            <input type="text" id="sitename" name="sitename" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="ver" class="block text-sm font-medium text-gray-700 mb-1">ver</label>
                            <input type="text" id="ver" name="ver" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="langx" class="block text-sm font-medium text-gray-700 mb-1">langx</label>
                            <input type="text" id="langx" name="langx" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="login_chk" class="block text-sm font-medium text-gray-700 mb-1">login_chk</label>
                            <input type="text" id="login_chk" name="login_chk" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="get_report_su" class="block text-sm font-medium text-gray-700 mb-1">get_report_su</label>
                            <input type="text" id="get_report_su" name="get_report_su" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="get_report_ag" class="block text-sm font-medium text-gray-700 mb-1">get_report_ag</label>
                            <input type="text" id="get_report_ag" name="get_report_ag" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="get_report_mem" class="block text-sm font-medium text-gray-700 mb-1">get_report_mem</label>
                            <input type="text" id="get_report_mem" name="get_report_mem" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="get_report_list_bet" class="block text-sm font-medium text-gray-700 mb-1">get_report_list_bet</label>
                            <input type="text" id="get_report_list_bet" name="get_report_list_bet" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="report_kind" class="block text-sm font-medium text-gray-700 mb-1">report_kind</label>
                            <input type="text" id="report_kind" name="report_kind" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="result_type" class="block text-sm font-medium text-gray-700 mb-1">result_type</label>
                            <input type="text" id="result_type" name="result_type" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="auto" class="block text-sm font-medium text-gray-700 mb-1">auto</label>
                            <input type="text" id="auto" name="auto" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="totalBets" class="block text-sm font-medium text-gray-700 mb-1">totalBets</label>
                            <input type="text" id="totalBets" name="totalBets" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="gtype" class="block text-sm font-medium text-gray-700 mb-1">gtype</label>
                            <input type="text" id="gtype" name="gtype" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="get_wmc_list_bet" class="block text-sm font-medium text-gray-700 mb-1">get_wmc_list_bet</label>
                            <input type="text" id="get_wmc_list_bet" name="get_wmc_list_bet" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="url1" class="block text-sm font-medium text-gray-700 mb-1">url1</label>
                            <input type="text" id="url1" name="url1" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="url2" class="block text-sm font-medium text-gray-700 mb-1">url2</label>
                            <input type="text" id="url2" name="url2" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="url3" class="block text-sm font-medium text-gray-700 mb-1">url3</label>
                            <input type="text" id="url3" name="url3" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="url4" class="block text-sm font-medium text-gray-700 mb-1">url4</label>
                            <input type="text" id="url4" name="url4" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-telegram-blue focus:border-transparent">
                        </div>
                    </div>
                </form>
            </div>
            <div class="p-6 border-t border-gray-200 flex justify-end">
                <button id="cancelBtn" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-2 px-4 rounded-lg mr-3 transition duration-300">
                    Cancel
                </button>
                <button id="saveBtn" class="bg-telegram-blue hover:bg-telegram-accent text-white font-medium py-2 px-6 rounded-lg transition duration-300">
                    Save
                </button>
            </div>
        </div>
    </div>

    <!-- Confirm Delete Modal -->
    <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-xl w-full max-w-md p-6 telegram-shadow">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Confirm Delete</h3>
            <p class="text-gray-600 mb-6">Are you sure you want to delete this configuration record? This action cannot be undone.</p>
            <input type="hidden" id="deleteId">
            <div class="flex justify-end">
                <button id="cancelDeleteBtn" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-2 px-4 rounded-lg mr-3 transition duration-300">
                    Cancel
                </button>
                <button id="confirmDeleteBtn" class="bg-red-500 hover:bg-red-600 text-white font-medium py-2 px-6 rounded-lg transition duration-300">
                    Confirm Delete
                </button>
            </div>
        </div>
    </div>

    <!-- Notification -->
    <div id="notification" class="fixed bottom-4 right-4 px-6 py-3 rounded-lg shadow-lg transform translate-y-20 opacity-0 transition-all duration-300 z-50 hidden"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get DOM elements
            const configModal = document.getElementById('configModal');
            const deleteModal = document.getElementById('deleteModal');
            const addBtn = document.getElementById('addBtn');
            const closeModalBtn = document.getElementById('closeModal');
            const cancelBtn = document.getElementById('cancelBtn');
            const saveBtn = document.getElementById('saveBtn');
            const deleteBtns = document.querySelectorAll('.deleteBtn');
            const editBtns = document.querySelectorAll('.editBtn');
            const cancelDeleteBtn = document.getElementById('cancelDeleteBtn');
            const confirmDeleteBtn = document.getElementById('confirmDeleteBtn');
            const deleteIdInput = document.getElementById('deleteId');
            const configForm = document.getElementById('configForm');
            const configIdInput = document.getElementById('configId');
            const formActionInput = document.getElementById('formAction');
            const modalTitle = document.getElementById('modalTitle');
            const notification = document.getElementById('notification');
            const configTableBody = document.getElementById('configTableBody');

            // Open add modal
            addBtn.addEventListener('click', function() {
                modalTitle.textContent = 'Add Configuration';
                formActionInput.value = 'add';
                configIdInput.value = '';
                configForm.reset();
                configModal.classList.remove('hidden');
                // Add fade-in animation
                setTimeout(() => {
                    configModal.querySelector('div').classList.add('animate-fade-in');
                }, 10);
            });

            // Close modal
            function closeModal() {
                configModal.classList.add('hidden');
                configModal.querySelector('div').classList.remove('animate-fade-in');
            }

            closeModalBtn.addEventListener('click', closeModal);
            cancelBtn.addEventListener('click', closeModal);

            // Close delete modal
            function closeDeleteModal() {
                deleteModal.classList.add('hidden');
            }

            cancelDeleteBtn.addEventListener('click', closeDeleteModal);

            // Show notification
            function showNotification(message, isError = false) {
                notification.textContent = message;
                notification.className = 'fixed bottom-4 right-4 px-6 py-3 rounded-lg shadow-lg transform transition-all duration-300 z-50';
                notification.classList.add(isError ? 'bg-red-500' : 'bg-green-500', 'text-white');
                notification.classList.remove('translate-y-20', 'opacity-0', 'hidden');
                
                setTimeout(() => {
                    notification.classList.add('translate-y-20', 'opacity-0');
                    setTimeout(() => {
                        notification.classList.add('hidden');
                    }, 300);
                }, 3000);
            }

            // Edit button click event
            editBtns.forEach(btn => {
                btn.addEventListener('click', async function() {
                    const id = this.getAttribute('data-id');
                    
                    try {
                        // Find record from table data
                        let config = null;
                        <?php foreach ($configs as $config): ?>
                            if (<?php echo $config['Id']; ?> == id) {
                                config = <?php echo json_encode($config); ?>;
                            }
                        <?php endforeach; ?>
                        
                        if (config) {
                            modalTitle.textContent = 'Edit Configuration';
                            formActionInput.value = 'update';
                            configIdInput.value = config.Id;
                            
                            // Populate form data
                            Object.keys(config).forEach(key => {
                                const input = document.getElementById(key);
                                if (input) {
                                    input.value = config[key] !== null ? config[key] : '';
                                }
                            });
                            
                            configModal.classList.remove('hidden');
                        } else {
                            showNotification('Configuration record not found', true);
                        }
                    } catch (error) {
                        console.error('Failed to get configuration:', error);
                        showNotification('Failed to get configuration', true);
                    }
                });
            });

            // Delete button click event
            deleteBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    const id = this.getAttribute('data-id');
                    deleteIdInput.value = id;
                    deleteModal.classList.remove('hidden');
                });
            });

            // Confirm delete
            confirmDeleteBtn.addEventListener('click', async function() {
                const id = deleteIdInput.value;
                
                try {
                    const response = await fetch('', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `action=delete&id=${encodeURIComponent(id)}`
                    });
                    
                    const result = await response.json();
                    
                    if (result.status === 'success') {
                        showNotification('Configuration has been deleted successfully');
                        // Remove the record from table
                        const row = document.querySelector(`.deleteBtn[data-id="${id}"]`).closest('tr');
                        if (row) {
                            row.remove();
                        }
                        closeDeleteModal();
                        
                        // Check if any records remain
                        if (configTableBody.children.length === 0) {
                            configTableBody.innerHTML = `
                                <tr>
                                    <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                                        <i class="fa fa-info-circle text-2xl mb-2"></i>
                                        <p>No configuration records found, please add new configuration</p>
                                    </td>
                                </tr>
                            `;
                        }
                    } else {
                        showNotification('Failed to delete', true);
                    }
                } catch (error) {
                    console.error('Delete failed:', error);
                    showNotification('Delete failed', true);
                }
            });

            // Save configuration
            saveBtn.addEventListener('click', async function() {
                const formData = new FormData(configForm);
                formData.append('action', formActionInput.value);
                if (formActionInput.value === 'update') {
                    formData.append('id', configIdInput.value);
                }
                
                try {
                    const response = await fetch('', {
                        method: 'POST',
                        body: new URLSearchParams(formData)
                    });
                    
                    const result = await response.json();
                    
                    if (result.status === 'success') {
                        showNotification(formActionInput.value === 'add' ? 'Configuration added successfully' : 'Configuration updated successfully');
                        closeModal();
                        // Refresh page to show latest data
                        setTimeout(() => {
                            window.location.reload();
                        }, 500);
                    } else {
                        showNotification('Save failed', true);
                    }
                } catch (error) {
                    console.error('Save failed:', error);
                    showNotification('Save failed', true);
                }
            });
        });
    </script>
</body>
</html>
