<?php
session_start();

// 设置会话过期时间（30分钟）
$sessionTimeout = 30 * 60;

// 获取当前请求中的AccountNo参数（如果有）
$accountNo = isset($_GET['AccountNo']) ? trim($_GET['AccountNo']) : '';

// 构建跳转URL基础
$loginUrl = '/login.php';

// 如果有AccountNo参数，添加到跳转URL
if (!empty($accountNo)) {
    $loginUrl .= '?AccountNo=' . urlencode($accountNo);
}

// 检查用户是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // 未登录，跳转到登录页并携带参数
    header('Location: ' . $loginUrl);
    exit;
}

// 检查会话是否过期
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $sessionTimeout)) {
    // 会话过期，销毁会话
    session_unset();
    session_destroy();
    
    // 跳转到登录页，携带AccountNo和会话过期标识
    $expiredUrl = $loginUrl . (strpos($loginUrl, '?') === false ? '?' : '&') . 'session_expired=1';
    header('Location: ' . $expiredUrl);
    exit;
}

// 更新最后活动时间
$_SESSION['last_activity'] = time();

// 如果当前请求有AccountNo参数，更新会话中的存储
if (!empty($accountNo)) {
    $_SESSION['account_no'] = $accountNo;
}
?>
