<?php
// 招商手册数据（手机端优化版）
$manualData = [
    'title' => '茶数数平台招商手册',
    'cover' => [
        'mainTitle' => '茶数数',
        'subTitle' => '茶叶店利润加速器',
        'bgImage' => 'https://picsum.photos/id/1060/800/1200' // 手机端竖版封面图
    ],
    'sections' => [
        [
            'id' => 'about',
            'title' => '关于我们',
            'content' => '茶数数专为茶叶店打造"资源+工具+服务"一体化方案，通过中高端产品供应链、0库存系统及私域管理，帮您拓宽销售场景，降低成本，提升利润。',
            'image' => 'https://picsum.photos/id/225/600/400'
        ],
        [
            'id' => 'comparison',
            'title' => '加盟前后数据对比',
            'chartData' => [
                'profit' => ['未加盟' => 100, '加盟后' => 158],
                'customers' => ['未加盟' => 100, '加盟后' => 182],
                'cost' => ['未加盟' => 100, '加盟后' => 62],
                'revenue' => [
                    '月份' => ['1月', '2月', '3月', '4月', '5月'],
                    '未加盟' => [85, 92, 89, 95, 98],
                    '加盟后' => [90, 110, 135, 142, 158]
                ]
            ],
            'desc' => '数据来源于全国200家门店实测（加盟后6个月跟踪）'
        ],
        [
            'id' => 'advantages',
            'title' => '核心优势',
            'points' => [
                [
                    'title' => '大牌资源精准匹配',
                    'items' => [
                        '央企背书的一二线滋补品、白酒',
                        '与中高端茶客需求高度吻合',
                        '利润比杂牌高30%+，复购率提升显著'
                    ],
                    'image' => 'https://picsum.photos/id/227/500/300'
                ],
                [
                    'title' => '0库存轻运营',
                    'items' => [
                        '一张二维码开专属线上店',
                        '仓储/物流/开票全包办',
                        '彻底摆脱库存压力'
                    ],
                    'image' => 'https://picsum.photos/id/493/500/300'
                ],
                [
                    'title' => '私域流量专属化',
                    'items' => [
                        '客户数据全归门店所有',
                        '定向发券/精准推荐',
                        '老客复购率提升40%+'
                    ],
                    'image' => 'https://picsum.photos/id/175/500/300'
                ]
            ]
        ],
        [
            'id' => 'products',
            'title' => '热门合作产品',
            'list' => [
                ['name' => '央企滋补礼盒', 'image' => 'https://picsum.photos/id/227/300/300', 'profit' => '42%'],
                ['name' => '知名品牌白酒', 'image' => 'https://picsum.photos/id/431/300/300', 'profit' => '38%'],
                ['name' => '高端茶衍生品', 'image' => 'https://picsum.photos/id/301/300/300', 'profit' => '35%']
            ]
        ],
        [
            'id' => 'cost',
            'title' => '合作门槛',
            'content' => [
                '年费仅680元，每天不到2元',
                '支持先用后付，无资金压力',
                '前50名签约送2000元运营服务'
            ]
        ],
        [
            'id' => 'contact',
            'title' => '立即加入',
            'action' => '扫描二维码抢占名额',
            'qrcode' => 'https://picsum.photos/id/342/200/200',
            'contact' => '电话：XXX-XXXXXXX | 微信：XXXXXX'
        ]
    ]
];
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo $manualData['title']; ?></title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Microsoft YaHei', sans-serif;
        }
        
        body {
            background-color: #f8faf7;
            color: #333;
            line-height: 1.8;
            font-size: 16px;
        }
        
        .section {
            padding: 40px 5%;
            border-bottom: 1px solid rgba(90, 158, 111, 0.1);
        }
        
        .section:nth-child(even) {
            background-color: #f1f7ef;
        }
        
        .section:nth-child(odd) {
            background-color: #ffffff;
        }
        
        h2 {
            color: #2e5439;
            font-size: 24px;
            margin-bottom: 25px;
            text-align: center;
            position: relative;
            padding-bottom: 10px;
        }
        
        h2::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background-color: #5a9e6f;
            border-radius: 2px;
        }
        
        /* 封面样式 */
        .cover {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            text-align: center;
            background-image: url('<?php echo $manualData['cover']['bgImage']; ?>');
            background-size: cover;
            background-position: center;
            position: relative;
            padding: 20px 5%;
        }
        
        .cover::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(46, 84, 57, 0.8);
        }
        
        .cover-content {
            position: relative;
            z-index: 2;
        }
        
        .cover h1 {
            font-size: 40px;
            margin-bottom: 15px;
        }
        
        .cover p {
            font-size: 18px;
            max-width: 90%;
            margin: 0 auto 30px;
        }
        
        .scroll-down {
            position: absolute;
            bottom: 30px;
            left: 50%;
            transform: translateX(-50%);
            color: white;
            font-size: 24px;
            animation: bounce 2s infinite;
        }
        
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {transform: translateY(0) translateX(-50%);}
            40% {transform: translateY(-15px) translateX(-50%);}
            60% {transform: translateY(-5px) translateX(-50%);}
        }
        
        /* 通用样式 */
        .text-content {
            font-size: 16px;
            margin-bottom: 25px;
            line-height: 1.8;
        }
        
        .section-image {
            width: 100%;
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 25px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }
        
        .section-image img {
            width: 100%;
            height: auto;
            display: block;
        }
        
        /* 对比图表 */
        .chart-wrapper {
            margin-bottom: 30px;
            background: white;
            border-radius: 8px;
            padding: 15px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        }
        
        .chart-title {
            font-size: 16px;
            color: #2e5439;
            margin-bottom: 15px;
            text-align: center;
            font-weight: bold;
        }
        
        .chart-container {
            width: 100%;
            height: 250px;
            position: relative;
        }
        
        .chart-desc {
            font-size: 14px;
            color: #666;
            text-align: center;
            margin-top: 10px;
        }
        
        /* 数据卡片 */
        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-bottom: 25px;
        }
        
        .stat-card {
            background: white;
            border-radius: 8px;
            padding: 15px;
            text-align: center;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        }
        
        .stat-value {
            font-size: 28px;
            font-weight: bold;
            color: #5a9e6f;
            margin-bottom: 5px;
        }
        
        .stat-label {
            font-size: 14px;
            color: #666;
        }
        
        /* 核心优势 */
        .advantage-item {
            margin-bottom: 35px;
        }
        
        .advantage-title {
            font-size: 19px;
            color: #2e5439;
            margin-bottom: 12px;
            font-weight: bold;
        }
        
        .advantage-list {
            margin-left: 20px;
            margin-bottom: 15px;
        }
        
        .advantage-list li {
            margin-bottom: 8px;
            font-size: 15px;
        }
        
        /* 产品展示 */
        .products-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-bottom: 15px;
        }
        
        .product-card {
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        }
        
        .product-image {
            height: 140px;
            overflow: hidden;
        }
        
        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .product-info {
            padding: 10px;
            text-align: center;
        }
        
        .product-name {
            font-size: 15px;
            color: #2e5439;
            margin-bottom: 5px;
        }
        
        .product-profit {
            font-size: 14px;
            color: #e67700;
            font-weight: bold;
        }
        
        /* 合作门槛 */
        .cost-list {
            list-style: none;
        }
        
        .cost-list li {
            font-size: 16px;
            margin-bottom: 15px;
            padding-left: 25px;
            position: relative;
        }
        
        .cost-list li::before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #5a9e6f;
            font-weight: bold;
            font-size: 18px;
        }
        
        /* 联系我们 */
        .contact-container {
            text-align: center;
            padding: 10px 0;
        }
        
        .contact-action {
            font-size: 17px;
            color: #2e5439;
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .qrcode-container {
            width: 180px;
            height: 180px;
            margin: 0 auto 20px;
            background: white;
            padding: 10px;
            border-radius: 8px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }
        
        .qrcode-container img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .contact-info {
            font-size: 16px;
            color: #2e5439;
            line-height: 1.6;
        }
        
        /* 底部导航 */
        .fixed-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: #2e5439;
            display: flex;
            padding: 12px 0;
            z-index: 100;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
        }
        
        .nav-item {
            flex: 1;
            color: white;
            text-align: center;
            font-size: 14px;
            text-decoration: none;
        }
        
        .nav-item.active {
            color: #d4af37;
        }
    </style>
</head>
<body>
    <!-- 封面 -->
    <div class="section cover">
        <div class="cover-content">
            <h1><?php echo $manualData['cover']['mainTitle']; ?></h1>
            <p><?php echo $manualData['cover']['subTitle']; ?></p>
        </div>
        <div class="scroll-down">↓</div>
    </div>

    <!-- 关于我们 -->
    <div class="section" id="about">
        <h2><?php echo $manualData['sections'][0]['title']; ?></h2>
        <div class="text-content">
            <?php echo $manualData['sections'][0]['content']; ?>
        </div>
        <div class="section-image">
            <img src="<?php echo $manualData['sections'][0]['image']; ?>" alt="茶数数平台">
        </div>
    </div>

    <!-- 数据对比 -->
    <div class="section" id="comparison">
        <h2><?php echo $manualData['sections'][1]['title']; ?></h2>
        
        <!-- 数据卡片 -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-value">+58%</div>
                <div class="stat-label">利润增长</div>
            </div>
            <div class="stat-card">
                <div class="stat-value">+82%</div>
                <div class="stat-label">客户留存</div>
            </div>
            <div class="stat-card">
                <div class="stat-value">-38%</div>
                <div class="stat-label">运营成本</div>
            </div>
            <div class="stat-card">
                <div class="stat-value">+63%</div>
                <div class="stat-label">客单价</div>
            </div>
        </div>
        
        <!-- 柱状图对比 -->
        <div class="chart-wrapper">
            <div class="chart-title">门店月利润对比（万元）</div>
            <div class="chart-container">
                <canvas id="barChart"></canvas>
            </div>
        </div>
        
        <!-- 折线图趋势 -->
        <div class="chart-wrapper">
            <div class="chart-title">5个月营收增长趋势</div>
            <div class="chart-container">
                <canvas id="lineChart"></canvas>
            </div>
        </div>
        
        <div class="chart-desc"><?php echo $manualData['sections'][1]['desc']; ?></div>
    </div>

    <!-- 核心优势 -->
    <div class="section" id="advantages">
        <h2><?php echo $manualData['sections'][2]['title']; ?></h2>
        <?php foreach($manualData['sections'][2]['points'] as $point): ?>
        <div class="advantage-item">
            <div class="advantage-title"><?php echo $point['title']; ?></div>
            <ul class="advantage-list">
                <?php foreach($point['items'] as $item): ?>
                <li><?php echo $item; ?></li>
                <?php endforeach; ?>
            </ul>
            <div class="section-image">
                <img src="<?php echo $point['image']; ?>" alt="<?php echo $point['title']; ?>">
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- 产品展示 -->
    <div class="section" id="products">
        <h2><?php echo $manualData['sections'][3]['title']; ?></h2>
        <div class="products-grid">
            <?php foreach($manualData['sections'][3]['list'] as $product): ?>
            <div class="product-card">
                <div class="product-image">
                    <img src="<?php echo $product['image']; ?>" alt="<?php echo $product['name']; ?>">
                </div>
                <div class="product-info">
                    <div class="product-name"><?php echo $product['name']; ?></div>
                    <div class="product-profit">利润率 <?php echo $product['profit']; ?></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- 合作门槛 -->
    <div class="section" id="cost">
        <h2><?php echo $manualData['sections'][4]['title']; ?></h2>
        <ul class="cost-list">
            <?php foreach($manualData['sections'][4]['content'] as $item): ?>
            <li><?php echo $item; ?></li>
            <?php endforeach; ?>
        </ul>
    </div>

    <!-- 联系我们 -->
    <div class="section" id="contact" style="padding-bottom: 80px;">
        <h2><?php echo $manualData['sections'][5]['title']; ?></h2>
        <div class="contact-container">
            <div class="contact-action"><?php echo $manualData['sections'][5]['action']; ?></div>
            <div class="qrcode-container">
                <img src="<?php echo $manualData['sections'][5]['qrcode']; ?>" alt="招商二维码">
            </div>
            <div class="contact-info"><?php echo $manualData['sections'][5]['contact']; ?></div>
        </div>
    </div>

    <!-- 底部固定导航 -->
    <div class="fixed-nav">
        <a href="#about" class="nav-item">关于我们</a>
        <a href="#comparison" class="nav-item">数据对比</a>
        <a href="#advantages" class="nav-item">核心优势</a>
        <a href="#contact" class="nav-item">立即加入</a>
    </div>

    <script>
        // 初始化图表
        document.addEventListener('DOMContentLoaded', function() {
            // 柱状图
            const barCtx = document.getElementById('barChart').getContext('2d');
            new Chart(barCtx, {
                type: 'bar',
                data: {
                    labels: ['未加盟', '加盟后'],
                    datasets: [{
                        label: '月利润（万元）',
                        data: [
                            <?php echo $manualData['sections'][1]['chartData']['profit']['未加盟']; ?>,
                            <?php echo $manualData['sections'][1]['chartData']['profit']['加盟后']; ?>
                        ],
                        backgroundColor: [
                            'rgba(150, 150, 150, 0.7)',
                            'rgba(90, 158, 111, 0.8)'
                        ],
                        borderWidth: 0,
                        borderRadius: 6
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                color: 'rgba(0, 0, 0, 0.05)'
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });

            // 折线图
            const lineCtx = document.getElementById('lineChart').getContext('2d');
            new Chart(lineCtx, {
                type: 'line',
                data: {
                    labels: <?php echo json_encode($manualData['sections'][1]['chartData']['revenue']['月份']); ?>,
                    datasets: [
                        {
                            label: '未加盟',
                            data: <?php echo json_encode($manualData['sections'][1]['chartData']['revenue']['未加盟']); ?>,
                            borderColor: 'rgba(150, 150, 150, 0.8)',
                            backgroundColor: 'rgba(150, 150, 150, 0.1)',
                            tension: 0.3,
                            fill: true
                        },
                        {
                            label: '加盟后',
                            data: <?php echo json_encode($manualData['sections'][1]['chartData']['revenue']['加盟后']); ?>,
                            borderColor: 'rgba(90, 158, 111, 0.8)',
                            backgroundColor: 'rgba(90, 158, 111, 0.1)',
                            tension: 0.3,
                            fill: true
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                boxWidth: 12,
                                font: {
                                    size: 11
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                color: 'rgba(0, 0, 0, 0.05)'
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
        });

        // 平滑滚动
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const targetId = this.getAttribute('href');
                const targetElement = document.querySelector(targetId);
                
                // 计算滚动位置（减去导航栏高度）
                const navHeight = document.querySelector('.fixed-nav').offsetHeight;
                const targetPosition = targetElement.getBoundingClientRect().top + window.pageYOffset - navHeight;
                
                window.scrollTo({
                    top: targetPosition,
                    behavior: 'smooth'
                });
            });
        });

        // 导航栏激活状态
        window.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('.section');
            const navItems = document.querySelectorAll('.nav-item');
            const navHeight = document.querySelector('.fixed-nav').offsetHeight;
            
            let currentSection = '';
            
            sections.forEach(section => {
                const sectionTop = section.offsetTop - navHeight;
                const sectionHeight = section.offsetHeight;
                
                if (window.pageYOffset >= sectionTop && window.pageYOffset < sectionTop + sectionHeight) {
                    currentSection = section.getAttribute('id');
                }
            });
            
            navItems.forEach(item => {
                item.classList.remove('active');
                if (item.getAttribute('href') === `#${currentSection}`) {
                    item.classList.add('active');
                }
            });
        });
    </script>
</body>
</html>
