<?php
session_start();

// 检查用户是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // 用户未登录，检查是否有POST数据（登录尝试）
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username']) && isset($_POST['password'])) {
        // 验证登录信息
        if ($_POST['username'] === 'admin' && $_POST['password'] === '1qazse4rfvgy7') {
            // 登录成功，设置会话变量
            $_SESSION['admin_logged_in'] = true;
            // 重定向到当前页面以避免刷新时重新提交表单
            header('Location: ' . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $login_error = '用户名或密码错误';
        }
    }

    // 显示登录表单
    ?>
    <!DOCTYPE html>
    <html lang="zh-CN">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>管理员登录 - Telegram账号管理系统</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        
        <script>
            tailwind.config = {
                theme: {
                    extend: {
                        colors: {
                            primary: '#2A86FF',
                            secondary: '#36D399',
                            warning: '#FFAB00',
                            danger: '#F87272',
                            dark: '#1E293B',
                            light: '#F8FAFC'
                        },
                        fontFamily: {
                            inter: ['Inter', 'sans-serif'],
                        },
                    }
                }
            }
        </script>
        
        <style type="text/tailwindcss">
            @layer utilities {
                .content-auto {
                    content-visibility: auto;
                }
                .card-shadow {
                    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
                }
                .transition-all-300 {
                    transition: all 300ms ease-in-out;
                }
                .table-hover-row:hover {
                    background-color: rgba(42, 134, 255, 0.05);
                }
            }
        </style>
    </head>
    <body class="bg-gray-50 font-inter text-dark min-h-screen flex items-center justify-center">
        <div class="w-full max-w-md px-4">
            <div class="bg-white rounded-xl shadow-lg p-6 card-shadow">
                <div class="text-center mb-6">
                    <div class="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto">
                        <i class="fa fa-user-circle text-primary text-2xl"></i>
                    </div>
                    <h2 class="text-xl font-semibold mt-4">管理员登录</h2>
                    <p class="text-gray-500 text-sm mt-1">请输入您的账号和密码</p>
                </div>
                
                <?php if (isset($login_error)): ?>
                <div class="bg-red-50 border border-red-200 rounded-lg p-3 mb-4">
                    <div class="flex items-start">
                        <div class="flex-shrink-0">
                            <i class="fa fa-exclamation-circle text-red-500 mt-0.5"></i>
                        </div>
                        <div class="ml-3">
                            <p class="text-red-800 text-sm"><?php echo htmlspecialchars($login_error); ?></p>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
                    <div class="mb-4">
                        <label for="username" class="block text-sm font-medium text-gray-700 mb-1">用户名</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fa fa-user text-gray-400"></i>
                            </div>
                            <input type="text" id="username" name="username" class="pl-10 w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" placeholder="请输入用户名" required>
                        </div>
                    </div>
                    
                    <div class="mb-6">
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1">密码</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fa fa-lock text-gray-400"></i>
                            </div>
                            <input type="password" id="password" name="password" class="pl-10 w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" placeholder="请输入密码" required>
                        </div>
                    </div>
                    
                    <button type="submit" class="w-full bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg flex items-center justify-center transition-all-300 shadow-md hover:shadow-lg">
                        <i class="fa fa-sign-in mr-2"></i> 登录
                    </button>
                </form>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Telegram账号管理系统</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.8/dist/chart.umd.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2A86FF',
                        secondary: '#36D399',
                        warning: '#FFAB00',
                        danger: '#F87272',
                        dark: '#1E293B',
                        light: '#F8FAFC'
                    },
                    fontFamily: {
                        inter: ['Inter', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    
    <style type="text/tailwindcss">
        @layer utilities {
            .content-auto {
                content-visibility: auto;
            }
            .card-shadow {
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            }
            .transition-all-300 {
                transition: all 300ms ease-in-out;
            }
            .table-hover-row:hover {
                background-color: rgba(42, 134, 255, 0.05);
            }
        }
    </style>
</head>
<body class="bg-gray-50 font-inter text-dark min-h-screen flex flex-col">
    <!-- 顶部导航栏 -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="container mx-auto px-4 py-3 flex items-center justify-between">
            <div class="flex items-center space-x-2">
                <i class="fa fa-telegram text-primary text-2xl"></i>
                <h1 class="text-xl font-semibold">Telegram账号管理系统</h1>
            </div>
            <div class="flex items-center space-x-6">
                <nav class="hidden md:flex space-x-6">
                    <a href="index1.php" class="text-primary font-medium flex items-center">
                        <i class="fa fa-user-circle mr-1"></i> 飞机群管理
                    </a>
                    <a href="botAdmin.php" class="text-gray-600 hover:text-primary transition-all-300 flex items-center">
                        <i class="fa fa-paper-plane mr-1"></i> 机器人管理
                    </a>
                    <a href="dataAdmin.php" class="text-gray-600 hover:text-primary transition-all-300 flex items-center">
                        <i class="fa fa-bar-chart mr-1"></i> 数据管理
                    </a>
                    <a href="bet_statistics.php" class="text-gray-600 hover:text-primary transition-all-300 flex items-center">
                        <i class="fa fa-cog mr-1"></i> 结果分析
                    </a>
                </nav>
                <div class="flex items-center space-x-4">
                    <button class="text-gray-500 hover:text-primary transition-all-300">
                        <i class="fa fa-bell"></i>
                    </button>
                    <div class="flex items-center">
                        <img src="https://picsum.photos/id/1005/40/40" alt="用户头像" class="w-8 h-8 rounded-full mr-2">
                        <span class="text-sm font-medium">管理员</span>
                    </div>
                    <button id="logout-btn" class="text-gray-500 hover:text-danger transition-all-300">
                        <i class="fa fa-sign-out"></i>
                    </button>
                </div>
            </div>
        </div>
    </header>

    <!-- 主要内容 -->
    <main class="flex-grow container mx-auto px-4 py-6">
        <!-- 页面标题和操作栏 -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
            <div>
                <h2 class="text-[clamp(1.5rem,3vw,2rem)] font-bold">Telegram账号管理</h2>
                <p class="text-gray-500 mt-1">管理所有Telegram账号信息，添加、修改、删除账号</p>
            </div>
            <div class="mt-4 md:mt-0 flex items-center space-x-3">
                <div class="relative">
                    <input type="text" id="search-input" placeholder="搜索账号..." 
                        class="pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300 w-full md:w-64">
                    <i class="fa fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                </div>
                <button id="add-account-btn" class="bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg flex items-center transition-all-300 shadow-md hover:shadow-lg">
                    <i class="fa fa-plus mr-2"></i> 添加账号
                </button>
            </div>
        </div>

        <!-- 自动刷新设置 -->
        <div class="bg-white rounded-lg p-4 mb-6 card-shadow">
            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between">
                <div class="flex items-center space-x-2 mb-3 sm:mb-0">
                    <i class="fa fa-refresh text-primary"></i>
                    <span class="font-medium">自动刷新</span>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="flex items-center">
                        <input type="checkbox" id="auto-refresh-toggle" class="w-5 h-5 rounded text-primary focus:ring-primary/30">
                        <label for="auto-refresh-toggle" class="ml-2 text-sm text-gray-700">开启自动刷新</label>
                    </div>
                    <div class="flex items-center">
                        <span class="text-sm text-gray-700 mr-2">刷新间隔:</span>
                        <div class="relative">
                            <select id="refresh-interval" class="pl-3 pr-8 py-1.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none text-sm appearance-none">
                                <option value="30">30秒</option>
                                <option value="60" selected>1分钟</option>
                                <option value="300">5分钟</option>
                                <option value="600">10分钟</option>
                            </select>
                            <i class="fa fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none text-xs"></i>
                        </div>
                    </div>
                    <span id="last-refresh" class="text-xs text-gray-500">最后刷新: 未刷新</span>
                </div>
            </div>
        </div>

        <!-- 账号列表 -->
        <div class="bg-white rounded-lg overflow-hidden card-shadow mb-6">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <th class="px-6 py-3">账号ID</th>
                            <th class="px-6 py-3">账号编号</th>
                            <th class="px-6 py-3">用户名</th>
                            <th class="px-6 py-3">状态</th>
                            <th class="px-6 py-3">开始日期</th>
                            <th class="px-6 py-3">结束日期</th>
                            <th class="px-6 py-3">代理</th>
                            <th class="px-6 py-3">地区</th>
                            <th class="px-6 py-3">操作</th>
                        </tr>
                    </thead>
                    <tbody id="account-table-body" class="divide-y divide-gray-200">
                        <!-- 账号数据将通过JavaScript动态填充 -->
                    </tbody>
                </table>
            </div>

            <!-- 分页控件 -->
            <div class="px-6 py-4 flex items-center justify-between border-t border-gray-200">
                <div class="flex-1 flex justify-between sm:hidden">
                    <button id="prev-page-mobile" class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        上一页
                    </button>
                    <button id="next-page-mobile" class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        下一页
                    </button>
                </div>
                <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                    <div>
                        <p class="text-sm text-gray-700">
                            显示 <span id="start-item">0</span> 到 <span id="end-item">0</span> 条，共 <span id="total-items">0</span> 条记录
                        </p>
                    </div>
                    <div>
                        <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px" aria-label="Pagination">
                            <button id="prev-page" class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <span class="sr-only">上一页</span>
                                <i class="fa fa-chevron-left text-xs"></i>
                            </button>
                            <div id="pagination-numbers" class="inline-flex">
                                <!-- 页码将通过JavaScript动态填充 -->
                            </div>
                            <button id="next-page" class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <span class="sr-only">下一页</span>
                                <i class="fa fa-chevron-right text-xs"></i>
                            </button>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <!-- 账号统计卡片 -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <div class="bg-white rounded-lg p-6 card-shadow border-l-4 border-primary">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">总账号数</p>
                        <h3 class="text-3xl font-bold mt-1" id="total-accounts">0</h3>
                    </div>
                    <div class="w-12 h-12 rounded-full bg-primary/10 flex items-center justify-center">
                        <i class="fa fa-users text-primary text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center">
                    <span class="text-green-500 text-sm flex items-center">
                        <i class="fa fa-arrow-up mr-1"></i> 2.5%
                    </span>
                    <span class="text-xs text-gray-500 ml-2">较上月</span>
                </div>
            </div>
            <div class="bg-white rounded-lg p-6 card-shadow border-l-4 border-secondary">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">活跃账号</p>
                        <h3 class="text-3xl font-bold mt-1" id="active-accounts">0</h3>
                    </div>
                    <div class="w-12 h-12 rounded-full bg-secondary/10 flex items-center justify-center">
                        <i class="fa fa-check-circle text-secondary text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center">
                    <span class="text-green-500 text-sm flex items-center">
                        <i class="fa fa-arrow-up mr-1"></i> 5.2%
                    </span>
                    <span class="text-xs text-gray-500 ml-2">较上月</span>
                </div>
            </div>
            <div class="bg-white rounded-lg p-6 card-shadow border-l-4 border-warning">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">即将到期</p>
                        <h3 class="text-3xl font-bold mt-1" id="expiring-accounts">0</h3>
                    </div>
                    <div class="w-12 h-12 rounded-full bg-warning/10 flex items-center justify-center">
                        <i class="fa fa-exclamation-triangle text-warning text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center">
                    <span class="text-red-500 text-sm flex items-center">
                        <i class="fa fa-arrow-up mr-1"></i> 8.3%
                    </span>
                    <span class="text-xs text-gray-500 ml-2">较上月</span>
                </div>
            </div>
        </div>

        <!-- 账号状态图表 -->
        <div class="bg-white rounded-lg p-6 card-shadow">
            <div class="flex items-center justify-between mb-6">
                <h3 class="font-semibold text-lg">账号状态分布</h3>
                <div class="flex space-x-2">
                    <button class="text-sm text-gray-500 hover:text-primary transition-all-300">
                        <i class="fa fa-download mr-1"></i> 导出
                    </button>
                    <button class="text-sm text-gray-500 hover:text-primary transition-all-300">
                        <i class="fa fa-ellipsis-v"></i>
                    </button>
                </div>
            </div>
            <div class="h-64">
                <canvas id="account-status-chart"></canvas>
            </div>
        </div>
    </main>

    <!-- 页脚 -->
    <footer class="bg-white border-t border-gray-200 py-4">
        <div class="container mx-auto px-4 text-center text-sm text-gray-500">
            <p>© 2025 Telegram账号管理系统. 保留所有权利.</p>
        </div>
    </footer>

    <!-- 添加/编辑账号模态框 -->
    <div id="account-modal" class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-3xl max-h-[90vh] overflow-y-auto">
            <div class="flex items-center justify-between p-6 border-b">
                <h3 class="text-lg font-semibold" id="modal-title">添加账号</h3>
                <button id="close-modal" class="text-gray-400 hover:text-gray-500">
                    <i class="fa fa-times text-xl"></i>
                </button>
            </div>
            <div class="p-6">
                <form id="account-form">
                    <input type="hidden" id="account-id" name="Id">
                    <input type="hidden" id="status" name="Status" value="1">
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label for="account-no" class="block text-sm font-medium text-gray-700 mb-1">账号编号 <span class="text-red-500">*</span></label>
                            <input type="text" id="account-no" name="AccountNo" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="user-name" class="block text-sm font-medium text-gray-700 mb-1">用户名 <span class="text-red-500">*</span></label>
                            <input type="text" id="user-name" name="UserName" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-1">密码 <span id="password-required" class="text-red-500">*</span></label>
                            <input type="password" id="password" name="Password" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300">
                            <p class="text-xs text-gray-500 mt-1">留空则不修改密码</p>
                        </div>
                        <div>
                            <label for="bot-token" class="block text-sm font-medium text-gray-700 mb-1">Bot Token <span class="text-red-500">*</span></label>
                            <input type="text" id="bot-token" name="BotToken" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="chat-id" class="block text-sm font-medium text-gray-700 mb-1">Chat ID <span class="text-red-500">*</span></label>
                            <input type="text" id="chat-id" name="ChatId" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="siteurl" class="block text-sm font-medium text-gray-700 mb-1">SiteUrl<span class="text-red-500">*</span></label>
                            <input type="text" id="siteurl" name="SiteUrl" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="agent" class="block text-sm font-medium text-gray-700 mb-1">代理名称 <span class="text-red-500">*</span></label>
                            <input type="text" id="agent" name="Agent" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="hgadminlist" class="block text-sm font-medium text-gray-700 mb-1">HG代理账号 <span class="text-red-500">*</span></label>
                            <input type="text" id="hgadminlist" name="HgAdminList" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="state" class="block text-sm font-medium text-gray-700 mb-1">地区 <span class="text-red-500">*</span></label>
                            <input type="text" id="state" name="State" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                        <div>
                            <label for="validity-days" class="block text-sm font-medium text-gray-700 mb-1">有效期(天) <span class="text-red-500">*</span></label>
                            <input type="number" id="validity-days" name="validity_days" min="1" max="365" value="30" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                    </div>

                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-3">账号权限</label>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div class="flex items-center">
                                <input type="checkbox" id="auto-send-match" name="autoSendMatch" class="w-4 h-4 rounded text-primary focus:ring-primary/30">
                                <label for="auto-send-match" class="ml-2 text-sm text-gray-700">自动发送比赛</label>
                            </div>
                            <div class="flex items-center">
                                <input type="checkbox" id="auto-send-report" name="autoSendReport" class="w-4 h-4 rounded text-primary focus:ring-primary/30">
                                <label for="auto-send-report" class="ml-2 text-sm text-gray-700">自动发送报表</label>
                            </div>
                            <div class="flex items-center">
                                <input type="checkbox" id="send-admin" name="sendAdmin" class="w-4 h-4 rounded text-primary focus:ring-primary/30">
                                <label for="send-admin" class="ml-2 text-sm text-gray-700">发送管理后台</label>
                            </div>
                        </div>
                    </div>

                    <div class="mb-6">
                        <label for="memo" class="block text-sm font-medium text-gray-700 mb-1">备注</label>
                        <textarea id="memo" name="Memo" rows="3" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300 resize-none"></textarea>
                    </div>

                    <div class="flex justify-end space-x-3 pt-4 border-t">
                        <button type="button" id="cancel-form" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-all-300">
                            取消
                        </button>
                        <button type="submit" class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-primary/90 transition-all-300 shadow-md hover:shadow-lg">
                            保存
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- 确认删除模态框 -->
    <div id="confirm-delete-modal" class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
            <div class="p-6">
                <div class="text-center mb-4">
                    <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fa fa-trash text-red-500 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold">确认删除</h3>
                    <p class="text-gray-500 mt-2">你确定要删除这个账号吗？此操作不可撤销。</p>
                </div>
                <div class="flex justify-center space-x-3 pt-4 border-t">
                    <button id="cancel-delete" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-all-300">
                        取消
                    </button>
                    <button id="confirm-delete" class="px-4 py-2 bg-red-500 text-white rounded-lg hover:bg-red-600 transition-all-300 shadow-md hover:shadow-lg">
                        确认删除
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- 通知提示 -->
    <div id="notification" class="fixed top-4 right-4 z-50 max-w-sm transform translate-x-full transition-all duration-300 ease-in-out">
        <div class="bg-white rounded-lg shadow-lg p-4 flex items-start">
            <div id="notification-icon" class="w-6 h-6 rounded-full flex items-center justify-center mr-3">
                <i class="fa fa-check text-white"></i>
            </div>
            <div class="flex-1">
                <h4 id="notification-title" class="font-medium text-sm"></h4>
                <p id="notification-message" class="text-xs text-gray-500 mt-1"></p>
            </div>
            <button id="close-notification" class="text-gray-400 hover:text-gray-600 ml-2">
                <i class="fa fa-times"></i>
            </button>
        </div>
    </div>

    <script>
        // 全局变量
        let currentPage = 1;
        let totalPages = 1;
        let searchTerm = '';
        let autoRefreshInterval = null;
        let accountIdToDelete = null;
        let chartInstance = null;

        // DOM 加载完成后执行
        document.addEventListener('DOMContentLoaded', function() {
            // 初始化页面
            loadAccounts();
            initEventListeners();
            initChart();
            
            // 退出登录按钮
            document.getElementById('logout-btn').addEventListener('click', function() {
                if (confirm('确定要退出登录吗？')) {
                    fetch('logout.php')
                        .then(response => {
                            if (response.ok) {
                                window.location.reload();
                            } else {
                                showNotification('错误', '退出登录失败', 'error');
                            }
                        })
                        .catch(error => {
                            console.error('退出登录错误:', error);
                            showNotification('错误', '退出登录失败', 'error');
                        });
                }
            });
        });

        // 初始化事件监听器
        function initEventListeners() {
            // 添加账号按钮
            document.getElementById('add-account-btn').addEventListener('click', function() {
                openModal('add');
            });

            // 关闭模态框按钮
            document.getElementById('close-modal').addEventListener('click', function() {
                closeModal();
            });

            // 取消表单按钮
            document.getElementById('cancel-form').addEventListener('click', function() {
                closeModal();
            });

            // 表单提交
            document.getElementById('account-form').addEventListener('submit', function(e) {
                e.preventDefault();
                saveAccount();
            });

            // 搜索输入框
            document.getElementById('search-input').addEventListener('keyup', function(e) {
                if (e.key === 'Enter') {
                    searchTerm = this.value.trim();
                    currentPage = 1;
                    loadAccounts();
                }
            });

            // 上一页按钮
            document.getElementById('prev-page').addEventListener('click', function() {
                if (currentPage > 1) {
                    currentPage--;
                    loadAccounts();
                }
            });

            // 下一页按钮
            document.getElementById('next-page').addEventListener('click', function() {
                if (currentPage < totalPages) {
                    currentPage++;
                    loadAccounts();
                }
            });

            // 移动端上一页按钮
            document.getElementById('prev-page-mobile').addEventListener('click', function() {
                if (currentPage > 1) {
                    currentPage--;
                    loadAccounts();
                }
            });

            // 移动端下一页按钮
            document.getElementById('next-page-mobile').addEventListener('click', function() {
                if (currentPage < totalPages) {
                    currentPage++;
                    loadAccounts();
                }
            });

            // 自动刷新开关
            document.getElementById('auto-refresh-toggle').addEventListener('change', function() {
                if (this.checked) {
                    startAutoRefresh();
                } else {
                    stopAutoRefresh();
                }
            });

            // 刷新间隔选择
            document.getElementById('refresh-interval').addEventListener('change', function() {
                if (document.getElementById('auto-refresh-toggle').checked) {
                    stopAutoRefresh();
                    startAutoRefresh();
                }
            });

            // 关闭通知
            document.getElementById('close-notification').addEventListener('click', function() {
                hideNotification();
            });

            // 取消删除
            document.getElementById('cancel-delete').addEventListener('click', function() {
                document.getElementById('confirm-delete-modal').classList.add('hidden');
            });

            // 确认删除
            document.getElementById('confirm-delete').addEventListener('click', function() {
                if (accountIdToDelete) {
                    deleteAccount(accountIdToDelete);
                }
                document.getElementById('confirm-delete-modal').classList.add('hidden');
            });
        }

        // 初始化图表
        function initChart() {
            const ctx = document.getElementById('account-status-chart').getContext('2d');
            
            chartInstance = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ['离线', '监测中', '已过期'],
                    datasets: [{
                        data: [0, 0, 0],
                        backgroundColor: [
                            '#E5E7EB',
                            '#36D399',
                            '#F87272'
                        ],
                        borderWidth: 0,
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'right',
                        }
                    },
                    cutout: '70%'
                }
            });
        }

        // 更新图表数据
        function updateChartData(offline, active, expired) {
            if (chartInstance) {
                chartInstance.data.datasets[0].data = [offline, active, expired];
                chartInstance.update();
            }
        }

        // 加载账号数据
        function loadAccounts() {
            const limit = 10;
            const tableBody = document.getElementById('account-table-body');
            const paginationNumbers = document.getElementById('pagination-numbers');
            const startItemEl = document.getElementById('start-item');
            const endItemEl = document.getElementById('end-item');
            const totalItemsEl = document.getElementById('total-items');
            const totalAccountsEl = document.getElementById('total-accounts');
            const activeAccountsEl = document.getElementById('active-accounts');
            const expiringAccountsEl = document.getElementById('expiring-accounts');

            // 显示加载状态
            tableBody.innerHTML = `
                <tr>
                    <td colspan="9" class="px-6 py-10 text-center">
                        <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-primary"></div>
                        <p class="mt-2 text-gray-500">加载中...</p>
                    </td>
                </tr>
            `;

            // 发送请求获取账号数据
            fetch(`api/account_list.php?page=${currentPage}&limit=${limit}&search=${encodeURIComponent(searchTerm)}`)
                .then(response => response.json())
                .then(data => {
                    if (data.data && data.data.length > 0) {
                        // 清空表格
                        tableBody.innerHTML = '';

                        // 填充表格数据
                        data.data.forEach(account => {
                            const row = document.createElement('tr');
                            row.className = 'table-hover-row';
                            row.innerHTML = `
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">${account.Id}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">${account.AccountNo}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">${account.UserName}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full ${getStatusClass(account.Status)}">
                                        ${getStatusText(account.Status)}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">${account.StartDate}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                    <span class="${isExpiringSoon(account.EndDate) ? 'text-warning font-medium' : 'text-gray-700'}">
                                        ${account.EndDate}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">${account.Agent}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">${account.State}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <button class="text-primary hover:text-primary/80 mr-3 edit-account" data-id="${account.Id}">
                                        <i class="fa fa-pencil"></i> 编辑
                                    </button>
                                    <button class="text-primary hover:text-primary/80 mr-3 listen-account" data-id="${account.AccountNo}">
                                        <i class="fa fa-pencil"></i> 监听
                                    </button>
                                    <button class="text-red-500 hover:text-red-600 delete-account" data-id="${account.Id}">
                                        <i class="fa fa-trash"></i> 删除
                                    </button>
                                </td>
                            `;
                            tableBody.appendChild(row);
                        });

                        // 添加编辑和删除按钮事件监听器
                        document.querySelectorAll('.edit-account').forEach(button => {
                            button.addEventListener('click', function() {
                                const accountId = this.getAttribute('data-id');
                                openModal('edit', accountId);
                            });
                        });

                        document.querySelectorAll('.listen-account').forEach(button => { 
                            button.addEventListener('click', function() { 
                                const accountNo = this.getAttribute('data-id'); 
                                window.open(`index2.php?AccountNo=${accountNo}`, '_blank'); 
                            }); 
                        });

                        document.querySelectorAll('.delete-account').forEach(button => {
                            button.addEventListener('click', function() {
                                accountIdToDelete = this.getAttribute('data-id');
                                document.getElementById('confirm-delete-modal').classList.remove('hidden');
                            });
                        });
                    } else {
                        // 无数据时显示提示
                        tableBody.innerHTML = `
                            <tr>
                                <td colspan="9" class="px-6 py-10 text-center">
                                    <i class="fa fa-inbox text-gray-300 text-4xl mb-3"></i>
                                    <p class="text-gray-500">暂无账号数据</p>
                                </td>
                            </tr>
                        `;
                    }

                    // 更新分页信息
                    totalPages = data.pages || 1;
                    startItemEl.textContent = data.total > 0 ? ((currentPage - 1) * limit + 1) : 0;
                    endItemEl.textContent = Math.min(currentPage * limit, data.total);
                    totalItemsEl.textContent = data.total;

                    // 更新分页按钮
                    updatePagination();

                    // 更新统计卡片
                    updateStats(data.total);

                    // 更新图表
                    updateChart(data.statusCounts || { offline: 0, active: 0, expired: 0 });

                    // 更新最后刷新时间
                    document.getElementById('last-refresh').textContent = `最后刷新: ${new Date().toLocaleTimeString()}`;
                })
                .catch(error => {
                    console.error('获取账号数据失败:', error);
                    tableBody.innerHTML = `
                        <tr>
                            <td colspan="9" class="px-6 py-10 text-center">
                                <i class="fa fa-exclamation-triangle text-red-500 text-2xl mb-2"></i>
                                <p class="text-red-500">加载数据失败，请重试</p>
                            </td>
                        </tr>
                    `;
                });
        }

        // 获取状态类
        function getStatusClass(status) {
            switch(status) {
                case '0': return 'bg-gray-100 text-gray-800'; // 离线
                case '1': return 'bg-green-100 text-green-800'; // 监测中
                case '2': return 'bg-red-100 text-red-800'; // 已过期
                default: return 'bg-gray-100 text-gray-800';
            }
        }

        // 获取状态文本
        function getStatusText(status) {
            switch(status) {
                case '0': return '离线';
                case '1': return '监测中';
                case '2': return '已过期';
                default: return '未知';
            }
        }

        // 更新分页按钮
        function updatePagination() {
            const paginationNumbers = document.getElementById('pagination-numbers');
            paginationNumbers.innerHTML = '';

            // 只显示当前页附近的页码
            let startPage = Math.max(1, currentPage - 2);
            let endPage = Math.min(totalPages, startPage + 4);

            if (endPage - startPage < 4 && startPage > 1) {
                startPage = Math.max(1, endPage - 4);
            }

            // 添加第一页按钮
            if (startPage > 1) {
                addPageButton(1);
                if (startPage > 2) {
                    addEllipsis();
                }
            }

            // 添加中间页码
            for (let i = startPage; i <= endPage; i++) {
                addPageButton(i);
            }

            // 添加最后一页按钮
            if (endPage < totalPages) {
                if (endPage < totalPages - 1) {
                    addEllipsis();
                }
                addPageButton(totalPages);
            }

            // 禁用/启用上一页和下一页按钮
            document.getElementById('prev-page').disabled = currentPage === 1;
            document.getElementById('next-page').disabled = currentPage === totalPages;
            document.getElementById('prev-page-mobile').disabled = currentPage === 1;
            document.getElementById('next-page-mobile').disabled = currentPage === totalPages;
        }

        // 添加分页按钮
        function addPageButton(pageNum) {
            const paginationNumbers = document.getElementById('pagination-numbers');
            const button = document.createElement('button');
            button.className = `relative inline-flex items-center px-4 py-2 border border-gray-300 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50 ${currentPage === pageNum ? 'bg-primary text-white border-primary' : ''}`;
            button.textContent = pageNum;
            button.addEventListener('click', function() {
                currentPage = pageNum;
                loadAccounts();
            });
            paginationNumbers.appendChild(button);
        }

        // 添加省略号
        function addEllipsis() {
            const paginationNumbers = document.getElementById('pagination-numbers');
            const span = document.createElement('span');
            span.className = 'relative inline-flex items-center px-4 py-2 border border-gray-300 bg-white text-sm font-medium text-gray-700';
            span.textContent = '...';
            paginationNumbers.appendChild(span);
        }

        // 更新统计卡片
        function updateStats(totalAccounts) {
            document.getElementById('total-accounts').textContent = totalAccounts;
            
            // 模拟活跃账号和即将到期账号数据
            const activeAccounts = Math.floor(totalAccounts * 0.65);
            const expiringAccounts = Math.floor(totalAccounts * 0.15);
            
            document.getElementById('active-accounts').textContent = activeAccounts;
            document.getElementById('expiring-accounts').textContent = expiringAccounts;
        }

        // 更新图表
        function updateChart(statusCounts) {
            updateChartData(statusCounts.offline, statusCounts.active, statusCounts.expired);
        }

        // 检查日期是否即将到期（7天内）
        function isExpiringSoon(endDate) {
            const today = new Date();
            const expDate = new Date(endDate);
            const diffTime = Math.abs(expDate - today);
            const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
            return diffDays <= 7;
        }

        // 打开模态框
        function openModal(mode, accountId = null) {
            const modal = document.getElementById('account-modal');
            const modalTitle = document.getElementById('modal-title');
            const passwordField = document.getElementById('password');
            const passwordRequired = document.getElementById('password-required');
            const form = document.getElementById('account-form');

            // 重置表单
            form.reset();
            document.getElementById('account-id').value = '';

            if (mode === 'add') {
                modalTitle.textContent = '添加账号';
                passwordRequired.textContent = '*'; // 添加时密码为必填项
                passwordField.required = true;
            } else if (mode === 'edit') {
                modalTitle.textContent = '编辑账号';
                passwordRequired.textContent = ''; // 编辑时密码为选填项
                passwordField.required = false;
                
                // 获取账号数据
                fetch(`api/get_account.php?Id=${accountId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success' && data.data) {
                            const account = data.data;
                            document.getElementById('account-id').value = account.Id;
                            document.getElementById('account-no').value = account.AccountNo;
                            document.getElementById('siteurl').value = account.SiteUrl;
                            document.getElementById('user-name').value = account.UserName;
                            document.getElementById('bot-token').value = account.BotToken;
                            document.getElementById('chat-id').value = account.ChatId;
                            document.getElementById('agent').value = account.Agent;
                            document.getElementById('state').value = account.State;
                            document.getElementById('validity-days').value = account.validity_days;
                            document.getElementById('auto-send-match').checked = account.autoSendMatch === '1';
                            document.getElementById('auto-send-report').checked = account.autoSendReport === '1';
                            document.getElementById('send-admin').checked = account.sendAdmin === '1';
                            document.getElementById('memo').value = account.Memo;
                            document.getElementById('hgadminlist').value = account.HgAdminList;
                            document.getElementById('status').value = account.Status;
                        } else {
                            showNotification('错误', data.message || '获取账号信息失败', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('获取账号数据失败:', error);
                        showNotification('错误', '获取账号信息失败，请重试', 'error');
                    });
            }

            // 显示模态框
            modal.classList.remove('hidden');
        }

        // 关闭模态框
        function closeModal() {
            document.getElementById('account-modal').classList.add('hidden');
            document.getElementById('account-form').reset();
        }

        // 保存账号
        function saveAccount() {
            const form = document.getElementById('account-form');
            const formData = new FormData(form);
            const accountId = document.getElementById('account-id').value;
            const url = accountId ? 'api/update_account.php' : 'api/add_account.php';
            const method = accountId ? 'POST' : 'POST';

            // 转换为JSON对象
            const data = {};
            formData.forEach((value, key) => {
                data[key] = value;
            });

            // 添加复选框值
            data.autoSendMatch = document.getElementById('auto-send-match').checked ? 1 : 0;
            data.autoSendReport = document.getElementById('auto-send-report').checked ? 1 : 0;
            data.sendAdmin = document.getElementById('send-admin').checked ? 1 : 0;

            // 显示加载状态
            const submitButton = form.querySelector('button[type="submit"]');
            const originalText = submitButton.innerHTML;
            submitButton.disabled = true;
            submitButton.innerHTML = '<i class="fa fa-spinner fa-spin mr-2"></i> 保存中...';

            // 发送请求
            fetch(url, {
                method: method,
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    showNotification('成功', result.message, 'success');
                    closeModal();
                    loadAccounts();
                } else {
                    showNotification('错误', result.message, 'error');
                }
            })
            .catch(error => {
                console.error('保存账号失败:', error);
                showNotification('错误', '保存账号失败，请重试', 'error');
            })
            .finally(() => {
                // 恢复按钮状态
                submitButton.disabled = false;
                submitButton.innerHTML = originalText;
            });
        }

        // 删除账号
        function deleteAccount(accountId) {
            // 显示加载状态
            const confirmButton = document.getElementById('confirm-delete');
            const originalText = confirmButton.innerHTML;
            confirmButton.disabled = true;
            confirmButton.innerHTML = '<i class="fa fa-spinner fa-spin mr-2"></i> 删除中...';

            // 发送请求
            fetch('api/delete_account.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ Id: accountId })
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    showNotification('成功', result.message, 'success');
                    loadAccounts();
                } else {
                    showNotification('错误', result.message, 'error');
                }
            })
            .catch(error => {
                console.error('删除账号失败:', error);
                showNotification('错误', '删除账号失败，请重试', 'error');
            })
            .finally(() => {
                // 恢复按钮状态
                confirmButton.disabled = false;
                confirmButton.innerHTML = originalText;
            });
        }

        // 显示通知
        function showNotification(title, message, type = 'success') {
            const notification = document.getElementById('notification');
            const notificationTitle = document.getElementById('notification-title');
            const notificationMessage = document.getElementById('notification-message');
            const notificationIcon = document.getElementById('notification-icon');

            // 设置通知内容
            notificationTitle.textContent = title;
            notificationMessage.textContent = message;

            // 设置通知类型
            if (type === 'success') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-green-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-check text-white"></i>';
            } else if (type === 'error') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-red-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-times text-white"></i>';
            } else if (type === 'warning') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-yellow-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-exclamation text-white"></i>';
            } else if (type === 'info') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-blue-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-info text-white"></i>';
            }

            // 显示通知
            notification.classList.remove('translate-x-full');

            // 3秒后自动隐藏
            setTimeout(hideNotification, 3000);
        }

        // 隐藏通知
        function hideNotification() {
            const notification = document.getElementById('notification');
            notification.classList.add('translate-x-full');
        }

        // 开始自动刷新
        function startAutoRefresh() {
            const interval = parseInt(document.getElementById('refresh-interval').value) * 1000;
            
            // 清除已有的定时器
            if (autoRefreshInterval) {
                clearInterval(autoRefreshInterval);
            }
            
            // 设置新的定时器
            autoRefreshInterval = setInterval(loadAccounts, interval);
        }

        // 停止自动刷新
        function stopAutoRefresh() {
            if (autoRefreshInterval) {
                clearInterval(autoRefreshInterval);
                autoRefreshInterval = null;
            }
        }
    </script>
</body>
</html>    