<?php
// 设置适当的超时时间和内存限制（针对大数据量）
set_time_limit(60);
ini_set('memory_limit', '256M');
ini_set('post_max_size', '100M');
ini_set('upload_max_filesize', '100M');

// 响应头设置
header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

 require_once '../db_connect.php';
 
// 获取请求类型
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // 查询最新未投注记录（status=0）
    try {
        // 获取GET参数中的hgname和hgpass
        $hgname = isset($_GET['hgname']) ? $_GET['hgname'] : null;
        $hgpass = isset($_GET['hgpass']) ? $_GET['hgpass'] : null;
        
        // 验证必要参数
        if (empty($hgname) || empty($hgpass)) {
            echo json_encode([
                'success' => false,
                'message' => '缺少必要的账号参数: hgname和hgpass'
            ]);
            exit;
        }
        
        // 准备SQL查询，只获取属于该账号的等待下注记录
        $stmt = $pdo->prepare(" 
            SELECT * FROM bets 
            WHERE status = 0 
            AND hgname = :hgname 
            AND hgpass = :hgpass
            ORDER BY created_at ASC 
            LIMIT 1
        ");
        $stmt->bindParam(':hgname', $hgname, PDO::PARAM_STR);
        $stmt->bindParam(':hgpass', $hgpass, PDO::PARAM_STR);
        $stmt->execute();
        $betRecord = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // 添加额外计算字段
        if ($betRecord) {
            // 计算wtype字段
            $wtype = ($betRecord['bet_type'] === 'overunder') ? 'OU' : 'R';
            if($betRecord['islive'] == 1){
               $wtype = ($betRecord['bet_type'] === 'overunder') ? 'ROU' : 'RE';
            }
            $rtype = '';
            $chose_team = '';
            
            // 根据wtype和bet_item计算rtype和chose_team
            if ($betRecord['bet_type'] === 'overunder') {
                // 大小球类型
                $betItemParts = explode('@', $betRecord['bet_item']);
                if (isset($betItemParts[0])) {
                    $betDirection = $betItemParts[0];
                    if ($betDirection === '大') {
                        if($betRecord['islive'] == 1){
                            $rtype = 'ROUC';
                        }else{
                            $rtype = 'OUC';
                        }
                        $chose_team = 'C';
                    } elseif ($betDirection === '小') {
                        if($betRecord['islive'] == 1){
                            $rtype = 'ROUH';
                        }else{
                            $rtype = 'OUH';
                        }
                        $chose_team = 'H';
                    }
                }
            } else {
                // 让球盘类型
                $betItemParts = explode('@', $betRecord['bet_item']);
                if (isset($betItemParts[0])) {
                    $teamName = $betItemParts[0];
                    if ($teamName === $betRecord['home_team']) {
                        if($betRecord['islive'] == 1){
                            $rtype = 'REH';
                        }else{
                            $rtype = 'RH';
                        }
                        $chose_team = 'H';
                    } elseif ($teamName === $betRecord['away_team']) {
                        if($betRecord['islive'] == 1){
                            $rtype = 'REC';
                        }else{
                            $rtype = 'RC';
                        }
                        $chose_team = 'C';
                    }
                }
            }
            
            // 添加计算字段到结果中
            $betRecord['wtype'] = $wtype;
            $betRecord['rtype'] = $rtype;
            $betRecord['chose_team'] = $chose_team;
        }
        
        echo json_encode([
            'success' => true,
            'data' => $betRecord ? $betRecord : null
        ]);
    } catch(PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => '查询投注记录失败: ' . $e->getMessage()
        ]);
    }
} elseif ($method === 'POST') {
    // 处理投注结果更新
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['id'], $data['success'])) {
        echo json_encode([
            'success' => false,
            'message' => '缺少必要参数'
        ]);
        exit;
    }
    
    try {
        // 先获取当前记录
        $stmt = $pdo->prepare("SELECT status FROM bets WHERE id = :id");
        $stmt->bindParam(':id', $data['id'], PDO::PARAM_INT);
        $stmt->execute();
        $currentRecord = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$currentRecord) {
            echo json_encode([
                'success' => false,
                'message' => '投注记录不存在'
            ]);
            exit;
        }
        
        // 确定新状态
        $newStatus = $data['success'] ? 1 : ($currentRecord['status'] + 1);
        
        // 状态最大为5
        if ($newStatus > 5) {
            $newStatus = 5;
        }
        
        // 更新记录
        $updateStmt = $pdo->prepare("
            UPDATE bets 
            SET status = :status, 
                updated_at = CURRENT_TIMESTAMP()
            WHERE id = :id
        ");
        $updateStmt->bindParam(':status', $newStatus, PDO::PARAM_INT);
        $updateStmt->bindParam(':id', $data['id'], PDO::PARAM_INT);
        $updateStmt->execute();
        
        echo json_encode([
            'success' => true,
            'message' => '投注状态已更新',
            'new_status' => $newStatus
        ]);
    } catch(PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => '更新投注状态失败: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => '不支持的请求方法'
    ]);
}
?>
