<?php
header('Content-Type: application/json; charset=utf-8');
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); // 允许所有域名
header("Access-Control-Allow-Methods: GET, POST"); // 允许的请求方法
header("Access-Control-Allow-Headers: Content-Type"); // 允许的头部

require_once '../db_connect.php';

$response = ['status' => 'error', 'message' => '未知错误'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    try {
        // 检查账号是否存在
        $stmtCheck = $pdo->prepare("SELECT * FROM TelSms_BotConfig WHERE BotId = :BotId");
        $stmtCheck->execute([':BotId' => $data['BotId']]);
        if (!$stmtCheck->fetch()) {
            $response['message'] = '机器不存在';
            echo json_encode($response);
            exit;
        }
        // 准备更新语句
        $updateFields = [
            'SelMaxId = :SelMaxId'
        ];

        $updateSql = implode(', ', $updateFields);
        $stmt = $pdo->prepare("UPDATE TelSms_BotConfig SET $updateSql WHERE BotId = :BotId");

        $params = [
            ':BotId' => $data['BotId'],
            ':SelMaxId' => $data['SelMaxId']
        ];

        $stmt->execute($params);

        $response = [
            'status' => 'success',
            'message' => '账号更新SelMaxId成功'
        ];
    } catch (PDOException $e) {
        $response['message'] = '数据库错误: ' . $e->getMessage();
    }
}

header('Content-Type: application/json');
echo json_encode($response);
?>