<?php
require_once '../db_connect.php';

$response = ['status' => 'error', 'message' => '未知错误'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // 简单验证数据是否为空，实际使用中可按需补充验证逻辑
    $requiredKeys = ['Id', 'AccountNo', 'UserName', 'ChatId',  'Agent','HgAdminList', 'State', 'autoSendMatch', 'autoSendReport', 'sendAdmin'];
    foreach ($requiredKeys as $key) {
        if (!isset($data[$key]) || empty($data[$key])) {
            $response['message'] = "缺少必要参数: $key";
            echo json_encode($response);
            exit;
        }
    }

   


    // 构建Roles字段
    $roles = [
        $data['autoSendMatch'] ? '1' : '0',
        $data['autoSendReport'] ? '1' : '0',
        $data['sendAdmin'] ? '1' : '0'
    ];
    $rolesStr = implode(',', $roles);

    try {
        // 检查账号是否存在
        $stmtCheck = $pdo->prepare("SELECT Id FROM TelSms_Account WHERE Id = :Id");
        $stmtCheck->execute([':Id' => $data['Id']]);
        if (!$stmtCheck->fetch()) {
            $response['message'] = '账号不存在';
            echo json_encode($response);
            exit;
        }

        // 准备更新语句
        $updateFields = [
            'AccountNo = :AccountNo',
            'SiteUrl = :SiteUrl',
            'UserName = :UserName',
            'ChatId = :ChatId',
            'Status = :Status',
            'Roles = :Roles',
            'Agent = :Agent',
            'HgAdminList = :HgAdminList',
            'State = :State',
            'Memo = :Memo'
        ];

        // 如果提供了新密码，则更新密码
        if (!empty($data['Password'])) {
            $updateFields[] = 'Password = :Password';
        }

        $updateSql = implode(', ', $updateFields);
        $stmt = $pdo->prepare("UPDATE TelSms_Account SET $updateSql WHERE Id = :Id");

        $params = [
            ':Id' => $data['Id'],
            ':AccountNo' => $data['AccountNo'],
            ':SiteUrl' => $data['SiteUrl'],
            ':UserName' => $data['UserName'],
            ':ChatId' => $data['ChatId'],
            ':Status' => $data['Status'],
            ':Roles' => $rolesStr,
            ':Agent' => $data['Agent'],
            ':HgAdminList' => $data['HgAdminList'],
            ':State' => $data['State'],
            ':Memo' => $data['Memo'] ?? ''
        ];

        // 如果提供了新密码，则添加到参数中
        if (!empty($data['Password'])) {
            $params[':Password'] = password_hash($data['Password'], PASSWORD_DEFAULT);
        }

        $stmt->execute($params);

        $response = [
            'status' => 'success',
            'message' => '账号更新成功'
        ];
    } catch (PDOException $e) {
        $response['message'] = '数据库错误: ' . $e->getMessage();
    }
}

header('Content-Type: application/json');
echo json_encode($response);
?>