<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

// 启动会话
session_start();

// 验证登录状态
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权访问，请先登录']);
    exit;
}

// 引入数据库连接
require_once '../db_connect.php';

try {
    // 获取请求数据
    $input = json_decode(file_get_contents('php://input'), true);
    
    // 验证参数
    if (!isset($input['AccountNo']) || empty($input['AccountNo'])) {
        echo json_encode(['status' => 'error', 'message' => '缺少软件账号参数']);
        exit;
    }
    
    $accountNo = $input['AccountNo'];
    
    // 查询该账号下的订单数量
    $countStmt = $pdo->prepare("SELECT COUNT(*) as count FROM TelSms_BetList WHERE AccountNo = :accountno");
    $countStmt->bindValue(':accountno', $accountNo);
    $countStmt->execute();
    $countResult = $countStmt->fetch();
    $totalCount = (int)$countResult['count'];
    
    if ($totalCount == 0) {
        echo json_encode([
            'status' => 'error', 
            'message' => "未找到软件账号为 {$accountNo} 的订单"
        ]);
        exit;
    }
    
    // 按账号删除订单
    $stmt = $pdo->prepare("DELETE FROM TelSms_BetList WHERE AccountNo = :accountno");
    $stmt->bindValue(':accountno', $accountNo);
    $stmt->execute();
    
    $affected = $stmt->rowCount();
    
    // 返回结果
    echo json_encode([
        'status' => 'success',
        'message' => "已成功删除软件账号为 {$accountNo} 的 {$affected} 条订单",
        'affected' => $affected
    ]);
} catch(PDOException $e) {
    // 输出错误信息
    echo json_encode([
        'status' => 'error',
        'message' => '按账号删除订单失败: ' . $e->getMessage()
    ]);
}

// 关闭连接
$pdo = null;
?>
    