<?php
require_once '../db_connect.php';

$response = ['status' => 'error', 'message' => '未知错误'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (!isset($data['Id']) || !is_numeric($data['Id'])) {
        $response['message'] = '无效的账号ID';
        echo json_encode($response);
        exit;
    }

    try {
        $stmt = $pdo->prepare("DELETE FROM TelSms_Account WHERE Id = :Id");
        $stmt->execute([':Id' => $data['Id']]);

        if ($stmt->rowCount() > 0) {
            $response = [
                'status' => 'success',
                'message' => '账号删除成功'
            ];
        } else {
            $response['message'] = '账号不存在或已被删除';
        }
    } catch (PDOException $e) {
        $response['message'] = '数据库错误: ' . $e->getMessage();
    }
}

header('Content-Type: application/json');
echo json_encode($response);
?>
    