<?php
header('Content-Type: application/json; charset=utf-8');
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); // 允许所有域名
header("Access-Control-Allow-Methods: GET, POST"); // 允许的请求方法
header("Access-Control-Allow-Headers: Content-Type"); // 允许的头部

require_once '../db_connect.php';

$response = [
    'status' => 'error',
    'message' => '未知错误',
    'success_count' => 0,
    'fail_count' => 0,
    'skip_count' => 0
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    // 检查是否有results数组
    if (!isset($data['results']) || !is_array($data['results']) || empty($data['results'])) {
        $response['message'] = "缺少必要的投注数据";
        echo json_encode($response);
        exit;
    }
    
    $bets = $data['results'];
    $total = count($bets);
    $successCount = 0;
    $failCount = 0;
    $skipCount = 0;
    
    try {
        $pdo->beginTransaction();
        
        // 遍历处理每条投注数据
        foreach ($bets as $bet) {
            // 检查必填字段
            $requiredKeys = ['BetNo', 'BetAccount', 'BetType', 'BetName', 'BetOdds', 'BetTime', 'BetAmount'];
            $hasError = false;
            
            foreach ($requiredKeys as $key) {
                if (!isset($bet[$key]) || empty($bet[$key])) {
                    $failCount++;
                    $hasError = true;
                    break;
                }
            }
            
            if ($hasError) continue;

            // 检查BetNo是否已存在
            $checkStmt = $pdo->prepare("SELECT id FROM TelSms_BetList WHERE BetNo = :BetNo");
            $checkStmt->execute([':BetNo' => $bet['BetNo']]);

            if ($checkStmt->fetch()) {
                $skipCount++;
                continue;
            }

           

            // 构建BetContent内容
           // 
            $betContent = "";
            $betContent .= "\n时间:  {$bet['BetTime']}\n";
          //  $betContent .= "备注:  {$bet['HgAdmin']}\n";
            $betContent .= "会员:  {$bet['BetAccount']}\n";
            $betContent .= "单号:  {$bet['BetNo']}\n";
            $betContent .= "{$bet['BetType']}:"."  {$bet['BetHandType']}\n";
            $betContent .= "内容：\n";
            $betContent .= "{$bet['BetName']}\n";    
            $betContent .= "{$bet['BetTeamNumberV']}\n";
            $betContent .= "{$bet['BetTeamV']}\n";
           // $betContent .= "盘口类型: {$bet['BetHandType']}\n";
            // 提取球队名称和盘口数据
            $teamWithHandicap = extractTeamWithHandicap($bet['BetContent']);
            if ($teamWithHandicap) {
                 $betContent .= "{$teamWithHandicap} @ {$bet['BetOdds']}\n\n";
            }else{
                 $betContent .= "{$bet['BetItem']} @ {$bet['BetOdds']}\n\n";
            }
           // $betContent .= "投注赔率: {$bet['BetOdds']}\n";
            $betContent .= "<code>￥: {$bet['BetAmount']}</code>";

            // 拆分 AccountNo
            $accountNos = explode(',', $bet['AccountNo'] ?? '');
            $insertData = [];
            foreach ($accountNos as $accountNo) {
                $accountNo = trim($accountNo);
                if (empty($accountNo)) continue;
                $insertData[] = [
                    'AccountNo' => $accountNo,
                    'HgAdmin' => $bet['HgAdmin'] ?? '',
                    'BetAccount' => $bet['BetAccount'],
                    'BetNo' => $bet['BetNo'],
                    'BetType' => $bet['BetType'],
                    'BetName' => $bet['BetName'],
                    'BetHandType' => $bet['BetHandType'] ?? '',
                    'BetItem' => $bet['BetItem']?? '',
                    'BetOdds' => $bet['BetOdds'],
                    'BetTime' => $bet['BetTime'],
                    'BetTeamV' => $bet['BetTeamV'] ?? '',
                    'BetTeamNumberV' => $bet['BetTeamNumberV'] ?? '',
                    'BetAmount' => $bet['BetAmount'],
                    'BetContent' => $betContent,
                    'BetResult' => (int)($bet['BetResult'] ?? 0),
                    'BetStatus' => (int)($bet['BetStatus'] ?? 0),
                    'SmsStatus' => (int)($bet['SmsStatus'] ?? 0)
                ];
            }

            if (!empty($insertData)) {
                // 构建批量插入的 SQL 语句
                $columns = "AccountNo, HgAdmin, BetAccount, BetNo, BetType, BetName, BetHandType,BetItem, BetOdds, BetTime, BetTeamV, BetTeamNumberV, BetAmount, BetContent, BetResult, BetStatus, SmsStatus, CreateDate";
                $placeholders = [];
                // 修改为使用数组索引
                foreach ($insertData as $index => $item) {
                    $placeholders[] = "(:AccountNo_{$index}, :HgAdmin_{$index}, :BetAccount_{$index}, :BetNo_{$index}, :BetType_{$index}, :BetName_{$index}, :BetHandType_{$index}, :BetItem_{$index}, :BetOdds_{$index}, :BetTime_{$index}, :BetTeamV_{$index}, :BetTeamNumberV_{$index}, :BetAmount_{$index}, :BetContent_{$index}, :BetResult_{$index}, :BetStatus_{$index}, :SmsStatus_{$index}, NOW())";
                }
                $sql = "INSERT INTO TelSms_BetList ({$columns}) VALUES " . implode(', ', $placeholders);
                $stmt = $pdo->prepare($sql);

                // 绑定参数
                foreach ($insertData as $index => $item) {
                    $stmt->bindValue(":AccountNo_{$index}", $item['AccountNo'], PDO::PARAM_STR);
                    $stmt->bindValue(":HgAdmin_{$index}", $item['HgAdmin'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetAccount_{$index}", $item['BetAccount'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetNo_{$index}", $item['BetNo'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetType_{$index}", $item['BetType'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetName_{$index}", $item['BetName'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetHandType_{$index}", $item['BetHandType'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetItem_{$index}", $item['BetItem'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetOdds_{$index}", $item['BetOdds'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetTime_{$index}", $item['BetTime'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetTeamV_{$index}", $item['BetTeamV'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetTeamNumberV_{$index}", $item['BetTeamNumberV'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetAmount_{$index}", $item['BetAmount'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetContent_{$index}", $item['BetContent'], PDO::PARAM_STR);
                    $stmt->bindValue(":BetResult_{$index}", $item['BetResult'], PDO::PARAM_INT);
                    $stmt->bindValue(":BetStatus_{$index}", $item['BetStatus'], PDO::PARAM_INT);
                    $stmt->bindValue(":SmsStatus_{$index}", $item['SmsStatus'], PDO::PARAM_INT);
                }

                $result = $stmt->execute();
                if ($result) {
                    $successCount += count($insertData);
                } else {
                    $failCount += count($insertData);
                }
            }
        }
        
        $pdo->commit();
        
        $response = [
            'status' => 'success',
            'message' => '投注数据处理完成',
            'total_count' => $total,
            'success_count' => $successCount,
            'fail_count' => $failCount,
            'skip_count' => $skipCount
        ];
        
    } catch (PDOException $e) {
        $pdo->rollBack();
       
        $response['message'] = '数据库操作失败，请稍后再试'. ("Database Error: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
    }
}

header('Content-Type: application/json');
echo json_encode($response);



function extractTeamWithHandicap($text) {
    // 正则表达式适配多种格式，包括li标签内的结构
    // 核心仍然是匹配球队名称 + 任意内容 + 红色标签中的盘口数据
    $pattern = '/([\x{4e00}-\x{9fa5}A-Za-z0-9()\s]+?)\s+(?:<[^>]+>\s*)*<tt class="word_red">([^<]+)<\/tt>/u';
    
    if (preg_match($pattern, $text, $matches)) {
        // 去除多余空格并组合结果
        return trim($matches[1]) . '  ' . trim($matches[2]);
    }
    
    return null;
}
?>