<?php
require_once '../db_connect.php';

$response = ['status' => 'error', 'message' => '未知错误'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // 简单验证数据是否为空，实际使用中可按需补充验证逻辑
    $requiredKeys = ['AccountNo','SiteUrl', 'UserName', 'Password', 'BotToken', 'ChatId', 'Agent','HgAdminList', 'State', 'validity_days', 'autoSendMatch', 'autoSendReport', 'sendAdmin'];
    foreach ($requiredKeys as $key) {
        if (!isset($data[$key]) || empty($data[$key])) {
            $response['message'] = "缺少必要参数: $key";
            echo json_encode($response);
            exit;
        }
    }

    // 计算开始日期和结束日期
    $startDate = date('Y-m-d H:i:s');
    $validityDays = (int)$data['validity_days'];
    $endDate = date('Y-m-d H:i:s', strtotime("+$validityDays days"));

    // 构建Roles字段
    $roles = [
        $data['autoSendMatch'] ? '1' : '0',
        $data['autoSendReport'] ? '1' : '0',
        $data['sendAdmin'] ? '1' : '0'
    ];
    $rolesStr = implode(',', $roles);

    try {
        $stmt = $pdo->prepare("INSERT INTO TelSms_Account (
            AccountNo,SiteUrl,UserName, Password, BotToken, ChatId, Status, 
            StartDate, EndDate, CreateDate, Roles, Agent,HgAdminList, State, Memo, AccountToken
        ) VALUES (
            :AccountNo,:SiteUrl, :UserName, :Password, :BotToken, :ChatId, 0, 
            :StartDate, :EndDate, NOW(), :Roles, :Agent,:HgAdminList, :State, :Memo, :BotToken
        )");

        $stmt->execute([
            ':AccountNo' => $data['AccountNo'],
            ':SiteUrl' => $data['SiteUrl'],
            ':UserName' => $data['UserName'],
            ':Password' => password_hash($data['Password'], PASSWORD_DEFAULT),
            ':BotToken' => $data['BotToken'],
            ':ChatId' => $data['ChatId'],
            ':StartDate' => $startDate,
            ':EndDate' => $endDate,
            ':Roles' => $rolesStr,
            ':HgAdminList' => $data['HgAdminList']?? '',
            ':Agent' => $data['Agent'],
            ':State' => $data['State'],
            ':Memo' => $data['Memo'] ?? '',
            ':BotToken' => $data['BotToken']
        ]);

        $response = [
            'status' => 'success',
            'message' => '账号添加成功'
        ];
    } catch (PDOException $e) {
        $response['message'] = '数据库错误: ' . $e->getMessage();
    }
}

header('Content-Type: application/json');
echo json_encode($response);
?>