<?php
require_once '../db_connect.php';

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;

$where = '';
$params = [];
if (!empty($search)) {
    $where = "WHERE UserName LIKE :search OR AccountNo LIKE :search OR Agent LIKE :search";
    $params[':search'] = "%$search%";
}

// 获取总记录数
$stmtTotal = $pdo->prepare("SELECT COUNT(*) as total FROM TelSms_Account $where");
$stmtTotal->execute($params);
$total = $stmtTotal->fetch(PDO::FETCH_ASSOC)['total'];

// 获取当前页数据
$stmt = $pdo->prepare("SELECT Id, AccountNo, UserName, Status, StartDate, EndDate, Agent,HgAdminList, State, Memo 
                       FROM TelSms_Account $where 
                       ORDER BY Id DESC 
                       LIMIT :limit OFFSET :offset");
$stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
$stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->execute();
$accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 格式化状态
$statusLabels = [
    0 => '<span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-800">离线</span>',
    1 => '<span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">监测中</span>',
    2 => '<span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">已过期</span>'
];

foreach ($accounts as &$account) {
    $account['Status'] = $statusLabels[$account['Status']];
    $account['StartDate'] = date('Y-m-d', strtotime($account['StartDate']));
    $account['EndDate'] = date('Y-m-d', strtotime($account['EndDate']));
}

$response = [
    'data' => $accounts,
    'total' => $total,
    'page' => $page,
    'limit' => $limit,
    'pages' => ceil($total / $limit)
];

header('Content-Type: application/json');
echo json_encode($response);
?>
    