<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");


// 处理请求
$action = $_REQUEST['action'] ?? '';

switch ($action) {
    case 'create':
        createAdmin();
        break;
    case 'update':
        updateAdmin();
        break;
    case 'delete':
        deleteAdmin();
        break;
    case 'get':
        getAdmin();
        break;
    default:
        respond(false, '无效的操作');
}

function getPdo() {
    require_once 'db.php';
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    return $pdo;
}

// 创建管理员
function createAdmin() {
  
    $userName = $_POST['userName'] ?? null;
    $password = $_POST['password'] ?? null;
    $startDate = $_POST['startDate'] ?? null;
    $endDate = $_POST['endDate'] ?? null;
    $status = $_POST['status'] ?? 1;
    $serverIP = $_POST['serverIP'] ?? null;
    $from = $_POST['from'] ?? null;
    
    // 验证开始时间小于结束时间
    if ($startDate && $endDate && strtotime($startDate) >= strtotime($endDate)) {
        respond(false, '开始时间必须小于结束时间');
    }
    
    try {
        $pdo = getPdo();
        $stmt = $pdo->prepare("INSERT INTO TelSms_Admin 
                              (UserName, Password, StartDate, EndDate, Status, ServerIP, `From`) 
                              VALUES (:userName, :password, :startDate, :endDate, :status, :serverIP, :from)");
        
        $stmt->bindParam(':userName', $userName);
        $stmt->bindParam(':password', $password);
        $stmt->bindParam(':startDate', $startDate);
        $stmt->bindParam(':endDate', $endDate);
        $stmt->bindParam(':status', $status, PDO::PARAM_INT);
        $stmt->bindParam(':serverIP', $serverIP);
        $stmt->bindParam(':from', $from);
        
        $stmt->execute();
        respond(true, '管理员创建成功', ['id' => $pdo->lastInsertId()]);
    } catch(PDOException $e) {
        respond(false, '创建失败: ' . $e->getMessage());
    }
}

// 更新管理员
function updateAdmin() {
    $pdo = getPdo();
    
    $id = $_POST['adminId'] ?? null;
    if (!$id) {
        respond(false, '缺少管理员ID');
    }
    
    $userName = $_POST['userName'] ?? null;
    $password = $_POST['password'] ?? null;
    $startDate = $_POST['startDate'] ?? null;
    $endDate = $_POST['endDate'] ?? null;
    $status = $_POST['status'] ?? 1;
    $serverIP = $_POST['serverIP'] ?? null;
    $from = $_POST['from'] ?? null;
    
    // 验证开始时间小于结束时间
    if ($startDate && $endDate && strtotime($startDate) >= strtotime($endDate)) {
        respond(false, '开始时间必须小于结束时间');
    }
    
    try {
        $stmt = $pdo->prepare("UPDATE TelSms_Admin SET 
                              UserName = :userName, 
                              Password = :password, 
                              StartDate = :startDate, 
                              EndDate = :endDate, 
                              Status = :status, 
                              ServerIP = :serverIP, 
                              `From` = :from 
                              WHERE Id = :id");
        
        $stmt->bindParam(':userName', $userName);
        $stmt->bindParam(':password', $password);
        $stmt->bindParam(':startDate', $startDate);
        $stmt->bindParam(':endDate', $endDate);
        $stmt->bindParam(':status', $status, PDO::PARAM_INT);
        $stmt->bindParam(':serverIP', $serverIP);
        $stmt->bindParam(':from', $from);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        
        $stmt->execute();
        respond(true, '管理员更新成功');
    } catch(PDOException $e) {
        respond(false, '更新失败: ' . $e->getMessage());
    }
}

// 删除管理员
function deleteAdmin() {
    $pdo = getPdo();
    $id = $_POST['id'] ?? null;
    if (!$id) {
        respond(false, '缺少管理员ID');
    }
    
    try {
        $stmt = $pdo->prepare("DELETE FROM TelSms_Admin WHERE Id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            respond(true, '管理员删除成功');
        } else {
            respond(false, '管理员不存在或已被删除');
        }
    } catch(PDOException $e) {
        respond(false, '删除失败: ' . $e->getMessage());
    }
}

// 获取管理员信息
function getAdmin() {
    $pdo = getPdo();
    $id = $_GET['id'] ?? null;
    if (!$id) {
        respond(false, '缺少管理员ID');
    }
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM TelSms_Admin WHERE Id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($admin) {
            respond(true, '获取成功', $admin);
        } else {
            respond(false, '管理员不存在');
        }
    } catch(PDOException $e) {
        respond(false, '获取失败: ' . $e->getMessage());
    }
}

// 响应函数
function respond($success, $message, $data = null) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'data' => $data
    ]);
    exit;
}
?>
