<?php
session_start();

require_once 'db.php';

// 登录验证
$isLoggedIn = isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;

// 处理登录请求
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // 验证用户名和密码
    if ($username === 'admin' && $password === '1qazse4rfvgy7') {
        $_SESSION['logged_in'] = true;
        $isLoggedIn = true;
    } else {
        $loginError = '用户名或密码不正确';
    }
}

// 处理登出请求
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_destroy();
    header('Location: index.php');
    exit;
}



// 连接数据库
try {
    $pdo = new PDO("mysql:host=$dbHost;port=$dbPort;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    $dbError = '数据库连接失败: ' . $e->getMessage();
}

// 获取管理员列表
function getAdmins($pdo, $page = 1, $limit = 10) {
    $offset = ($page - 1) * $limit;
    
    // 获取总数
    $totalStmt = $pdo->query("SELECT COUNT(*) as total FROM TelSms_Admin");
    $total = $totalStmt->fetchColumn();
    
    // 获取当前页数据
    $stmt = $pdo->prepare("SELECT * FROM TelSms_Admin ORDER BY Id DESC LIMIT :limit OFFSET :offset");
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    
    return [
        'admins' => $stmt->fetchAll(PDO::FETCH_ASSOC),
        'total' => $total,
        'pages' => ceil($total / $limit),
        'currentPage' => $page
    ];
}

// 如果已登录，获取管理员数据
$adminData = null;
if ($isLoggedIn && !isset($dbError)) {
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $adminData = getAdmins($pdo, $page);
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TelSms Admin 管理系统</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        telegram: {
                            blue: '#2AABEE',
                            dark: '#1E293B',
                            darker: '#161B22',
                            light: '#E5E7EB'
                        }
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style type="text/tailwindcss">
        @layer utilities {
            .content-auto {
                content-visibility: auto;
            }
            .telegram-shadow {
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24);
            }
            .telegram-hover {
                transition: all 0.3s cubic-bezier(.25,.8,.25,1);
            }
            .telegram-hover:hover {
                box-shadow: 0 14px 28px rgba(0, 0, 0, 0.25), 0 10px 10px rgba(0, 0, 0, 0.22);
            }
        }
    </style>
</head>
<body class="bg-telegram-darker text-gray-200 min-h-screen">
    <div class="container mx-auto px-4 py-8 max-w-6xl">
        <!-- 头部 -->
        <header class="mb-8">
            <div class="flex justify-between items-center">
                <h1 class="text-[clamp(1.5rem,3vw,2.5rem)] font-bold text-telegram-blue flex items-center">
                    <i class="fa fa-telegram mr-3 text-2xl"></i>
                    TelSms Admin 管理系统
                </h1>
                
                <?php if ($isLoggedIn): ?>
                <button id="logoutBtn" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md transition duration-300 flex items-center">
                    <i class="fa fa-sign-out mr-2"></i> 退出登录
                </button>
                <?php endif; ?>
            </div>
        </header>

        <!-- 登录表单 -->
        <?php if (!$isLoggedIn): ?>
        <div class="flex justify-center items-center min-h-[60vh]">
            <div class="w-full max-w-md bg-telegram-dark p-8 rounded-lg telegram-shadow">
                <h2 class="text-2xl font-bold mb-6 text-center text-telegram-blue">管理员登录</h2>
                
                <?php if (isset($loginError)): ?>
                <div class="bg-red-500 bg-opacity-20 text-red-400 p-3 rounded mb-4">
                    <i class="fa fa-exclamation-circle mr-2"></i><?php echo $loginError; ?>
                </div>
                <?php endif; ?>
                
                <form method="post" class="space-y-4">
                    <div>
                        <label for="username" class="block mb-2 text-sm font-medium">用户名</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fa fa-user text-gray-400"></i>
                            </span>
                            <input type="text" id="username" name="username" value="admin" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full pl-10 pr-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                        </div>
                    </div>
                    
                    <div>
                        <label for="password" class="block mb-2 text-sm font-medium">密码</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fa fa-lock text-gray-400"></i>
                            </span>
                            <input type="password" id="password" name="password" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full pl-10 pr-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                        </div>
                    </div>
                    
                    <button type="submit" name="login" 
                        class="w-full bg-telegram-blue hover:bg-blue-600 text-white font-medium py-2 px-4 rounded-md transition duration-300 flex justify-center items-center">
                        <i class="fa fa-sign-in mr-2"></i> 登录
                    </button>
                </form>
            </div>
        </div>
        
        <?php else: ?>
        <!-- 管理界面 -->
        <?php if (isset($dbError)): ?>
        <div class="bg-red-500 bg-opacity-20 text-red-400 p-4 rounded mb-6">
            <i class="fa fa-exclamation-triangle mr-2"></i><?php echo $dbError; ?>
        </div>
        <?php else: ?>
        <!-- 操作按钮区 -->
        <div class="mb-6 flex flex-wrap justify-between items-center gap-4">
            <button id="addAdminBtn" class="bg-telegram-blue hover:bg-blue-600 text-white px-4 py-2 rounded-md transition duration-300 flex items-center">
                <i class="fa fa-plus mr-2"></i> 添加管理员
            </button>
        </div>

        <!-- 数据表格 -->
        <div class="bg-telegram-dark rounded-lg overflow-hidden telegram-shadow mb-6">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">用户名</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">密码</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">开始时间</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">结束时间</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">状态</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">服务器IP</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">来源</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">操作</th>
                    </tr>
                </thead>
                <tbody class="bg-telegram-dark divide-y divide-gray-700">
                    <?php if (empty($adminData['admins'])): ?>
                    <tr>
                        <td colspan="9" class="px-6 py-10 text-center text-gray-400">
                            <i class="fa fa-folder-open-o mr-2"></i> 没有找到管理员数据
                        </td>
                    </tr>
                    <?php else: ?>
                    <?php foreach ($adminData['admins'] as $admin): ?>
                    <tr class="hover:bg-gray-800 transition duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo $admin['Id']; ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo htmlspecialchars($admin['UserName'] ?? '-'); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <?php 
                            $pwd = $admin['Password'] ?? '';
                            echo $pwd ? substr($pwd, 0, 2) . str_repeat('*', max(0, strlen($pwd) - 4)) . substr($pwd, -2) : '-';
                            ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo $admin['StartDate'] ?? '-'; ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo $admin['EndDate'] ?? '-'; ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                <?php echo $admin['Status'] == 1 ? 'bg-green-500 bg-opacity-20 text-green-400' : 'bg-red-500 bg-opacity-20 text-red-400'; ?>">
                                <?php echo $admin['Status'] == 1 ? '启用' : '禁用'; ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo htmlspecialchars($admin['ServerIP'] ?? '-'); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo htmlspecialchars($admin['From'] ?? '-'); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <button class="edit-btn text-telegram-blue hover:text-blue-400 mr-3" data-id="<?php echo $admin['Id']; ?>">
                                <i class="fa fa-pencil"></i> 编辑
                            </button>
                            <button class="delete-btn text-red-400 hover:text-red-300" data-id="<?php echo $admin['Id']; ?>">
                                <i class="fa fa-trash"></i> 删除
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- 分页 -->
        <?php if ($adminData['pages'] > 1): ?>
        <div class="flex justify-center">
            <nav class="inline-flex rounded-md shadow">
                <?php if ($adminData['currentPage'] > 1): ?>
                <a href="?page=<?php echo $adminData['currentPage'] - 1; ?>" 
                    class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-gray-700 bg-telegram-dark text-sm font-medium text-gray-300 hover:bg-gray-800">
                    <i class="fa fa-chevron-left"></i>
                </a>
                <?php endif; ?>
                
                <?php for ($i = 1; $i <= $adminData['pages']; $i++): ?>
                <a href="?page=<?php echo $i; ?>" 
                    class="relative inline-flex items-center px-4 py-2 border border-gray-700 bg-telegram-dark text-sm font-medium 
                        <?php echo $i == $adminData['currentPage'] ? 'text-telegram-blue bg-gray-800' : 'text-gray-300 hover:bg-gray-800'; ?>">
                    <?php echo $i; ?>
                </a>
                <?php endfor; ?>
                
                <?php if ($adminData['currentPage'] < $adminData['pages']): ?>
                <a href="?page=<?php echo $adminData['currentPage'] + 1; ?>" 
                    class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-gray-700 bg-telegram-dark text-sm font-medium text-gray-300 hover:bg-gray-800">
                    <i class="fa fa-chevron-right"></i>
                </a>
                <?php endif; ?>
            </nav>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php endif; ?>
    </div>

    <!-- 添加/编辑管理员模态框 -->
    <div id="adminModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-telegram-dark rounded-lg w-full max-w-2xl max-h-[90vh] overflow-y-auto telegram-shadow">
            <div class="px-6 py-4 border-b border-gray-700 flex justify-between items-center">
                <h3 id="modalTitle" class="text-lg font-medium">添加管理员</h3>
                <button id="closeModal" class="text-gray-400 hover:text-gray-200">
                    <i class="fa fa-times"></i>
                </button>
            </div>
            
            <div class="p-6">
                <form id="adminForm" class="space-y-4">
                    <input type="hidden" id="adminId">
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="userName" class="block mb-1 text-sm font-medium">用户名</label>
                            <input type="text" id="userName" name="userName" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                        </div>
                        
                        <div>
                            <label for="password" class="block mb-1 text-sm font-medium">密码</label>
                            <input type="text" id="password" name="password" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                        </div>
                    </div>
                    
                    <div>
                        <label class="block mb-1 text-sm font-medium">有效期设置</label>
                        <div class="flex items-center">
                            <input type="number" id="validityDays" value="30" min="1" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-l-md w-24 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                            <span class="bg-gray-700 px-3 py-2 border-t border-b border-gray-600">天</span>
                            <button type="button" id="calculateDates" 
                                class="bg-telegram-blue hover:bg-blue-600 text-white rounded-r-md px-4 py-2 transition duration-300">
                                计算日期
                            </button>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="startDate" class="block mb-1 text-sm font-medium">开始时间</label>
                            <input type="datetime-local" id="startDate" name="startDate" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                        </div>
                        
                        <div>
                            <label for="endDate" class="block mb-1 text-sm font-medium">结束时间</label>
                            <input type="datetime-local" id="endDate" name="endDate" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="status" class="block mb-1 text-sm font-medium">状态</label>
                            <select id="status" name="status" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                                <option value="1">启用</option>
                                <option value="0">禁用</option>
                            </select>
                        </div>
                        
                        <div>
                            <label for="serverIP" class="block mb-1 text-sm font-medium">服务器IP</label>
                            <input type="text" id="serverIP" name="serverIP" 
                                class="bg-gray-700 border border-gray-600 text-white rounded-md w-full px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                        </div>
                    </div>
                    
                    <div>
                        <label for="from" class="block mb-1 text-sm font-medium">来源</label>
                        <input type="text" id="from" name="from" 
                            class="bg-gray-700 border border-gray-600 text-white rounded-md w-full px-3 py-2 focus:outline-none focus:ring-2 focus:ring-telegram-blue">
                    </div>
                </form>
            </div>
            
            <div class="px-6 py-4 border-t border-gray-700 flex justify-end space-x-3">
                <button id="cancelBtn" class="px-4 py-2 border border-gray-600 rounded-md text-gray-300 hover:bg-gray-800 transition duration-300">
                    取消
                </button>
                <button id="saveBtn" class="px-4 py-2 bg-telegram-blue hover:bg-blue-600 text-white rounded-md transition duration-300">
                    保存
                </button>
            </div>
        </div>
    </div>

    <!-- 确认删除模态框 -->
    <div id="confirmModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-telegram-dark rounded-lg w-full max-w-md telegram-shadow">
            <div class="px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-medium">确认删除</h3>
            </div>
            
            <div class="p-6">
                <p class="text-gray-300">您确定要删除这条记录吗？此操作不可撤销。</p>
                <input type="hidden" id="deleteId">
            </div>
            
            <div class="px-6 py-4 border-t border-gray-700 flex justify-end space-x-3">
                <button id="cancelDeleteBtn" class="px-4 py-2 border border-gray-600 rounded-md text-gray-300 hover:bg-gray-800 transition duration-300">
                    取消
                </button>
                <button id="confirmDeleteBtn" class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md transition duration-300">
                    确认删除
                </button>
            </div>
        </div>
    </div>

    <!-- 消息提示模态框 -->
    <div id="messageModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-telegram-dark rounded-lg w-full max-w-md telegram-shadow">
            <div class="p-6 text-center">
                <div id="messageIcon" class="text-5xl mx-auto mb-4">
                    <i class="fa fa-check-circle text-green-500"></i>
                </div>
                <h3 id="messageTitle" class="text-lg font-medium mb-2">操作成功</h3>
                <p id="messageContent" class="text-gray-300">您的操作已成功完成。</p>
            </div>
            
            <div class="px-6 py-4 border-t border-gray-700 flex justify-center">
                <button id="closeMessageBtn" class="px-6 py-2 bg-telegram-blue hover:bg-blue-600 text-white rounded-md transition duration-300">
                    确定
                </button>
            </div>
        </div>
    </div>

    <script>
        // 页面加载完成后执行
        document.addEventListener('DOMContentLoaded', function() {
            // 只有登录后才初始化管理功能
            <?php if ($isLoggedIn): ?>
            initAdminManagement();
            <?php endif; ?>
            
            // 登出按钮事件
            document.getElementById('logoutBtn')?.addEventListener('click', function() {
                if (confirm('确定要退出登录吗？')) {
                    window.location.href = '?action=logout';
                }
            });
        });

        // 初始化管理员管理功能
        function initAdminManagement() {
            // 获取DOM元素
            const adminModal = document.getElementById('adminModal');
            const confirmModal = document.getElementById('confirmModal');
            const messageModal = document.getElementById('messageModal');
            const addAdminBtn = document.getElementById('addAdminBtn');
            const closeModalBtn = document.getElementById('closeModal');
            const cancelBtn = document.getElementById('cancelBtn');
            const saveBtn = document.getElementById('saveBtn');
            const calculateDatesBtn = document.getElementById('calculateDates');
            const editBtns = document.querySelectorAll('.edit-btn');
            const deleteBtns = document.querySelectorAll('.delete-btn');
            const cancelDeleteBtn = document.getElementById('cancelDeleteBtn');
            const confirmDeleteBtn = document.getElementById('confirmDeleteBtn');
            const closeMessageBtn = document.getElementById('closeMessageBtn');
            
            // 设置默认状态为启用
            document.getElementById('status').value = '1';
            
            // 打开添加管理员模态框
            addAdminBtn.addEventListener('click', function() {
                document.getElementById('modalTitle').textContent = '添加管理员';
                document.getElementById('adminForm').reset();
                document.getElementById('adminId').value = '';
                document.getElementById('status').value = '1';
                adminModal.classList.remove('hidden');
            });
            
            // 关闭模态框
            closeModalBtn.addEventListener('click', () => adminModal.classList.add('hidden'));
            cancelBtn.addEventListener('click', () => adminModal.classList.add('hidden'));
            
            // 关闭确认框
            cancelDeleteBtn.addEventListener('click', () => confirmModal.classList.add('hidden'));
            
            // 关闭消息框
            closeMessageBtn.addEventListener('click', () => messageModal.classList.add('hidden'));
            
            // 计算日期
            calculateDatesBtn.addEventListener('click', function() {
                const days = parseInt(document.getElementById('validityDays').value) || 30;
                
                // 开始时间设为当前时间
                const startDate = new Date();
                // 结束时间为开始时间加上指定天数
                const endDate = new Date(startDate);
                endDate.setDate(endDate.getDate() + days);
                
                // 格式化为datetime-local所需的格式 (YYYY-MM-DDThh:mm)
                document.getElementById('startDate').value = formatDateForInput(startDate);
                document.getElementById('endDate').value = formatDateForInput(endDate);
            });
            
            // 编辑按钮点击事件
            editBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    const id = this.getAttribute('data-id');
                    loadAdminData(id);
                });
            });
            
            // 删除按钮点击事件
            deleteBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    const id = this.getAttribute('data-id');
                    document.getElementById('deleteId').value = id;
                    confirmModal.classList.remove('hidden');
                });
            });
            
            // 确认删除
            confirmDeleteBtn.addEventListener('click', function() {
                const id = document.getElementById('deleteId').value;
                deleteAdmin(id);
            });
            
            // 保存管理员数据
            saveBtn.addEventListener('click', function() {
                const id = document.getElementById('adminId').value;
                
                // 验证开始时间小于结束时间
                const startDate = document.getElementById('startDate').value;
                const endDate = document.getElementById('endDate').value;
                
                if (startDate && endDate && new Date(startDate) >= new Date(endDate)) {
                    showMessage('错误', '开始时间必须小于结束时间', 'error');
                    return;
                }
                
                if (id) {
                    updateAdmin(id);
                } else {
                    createAdmin();
                }
            });
            
            // 加载管理员数据
            function loadAdminData(id) {
                fetch(`adminApi.php?action=get&id=${id}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            const admin = data.data;
                            document.getElementById('modalTitle').textContent = '编辑管理员';
                            document.getElementById('adminId').value = admin.Id;
                            document.getElementById('userName').value = admin.UserName || '';
                            document.getElementById('password').value = admin.Password || '';
                            document.getElementById('startDate').value = admin.StartDate ? formatDateForInput(new Date(admin.StartDate)) : '';
                            document.getElementById('endDate').value = admin.EndDate ? formatDateForInput(new Date(admin.EndDate)) : '';
                            document.getElementById('status').value = admin.Status;
                            document.getElementById('serverIP').value = admin.ServerIP || '';
                            document.getElementById('from').value = admin.From || '';
                            
                            adminModal.classList.remove('hidden');
                        } else {
                            showMessage('错误', data.message, 'error');
                        }
                    })
                    .catch(error => {
                        showMessage('错误', '加载数据失败: ' + error.message, 'error');
                    });
            }
            
            // 创建管理员
            function createAdmin() {
                const formData = new FormData();
                formData.append('action', 'create');
                formData.append('userName', document.getElementById('userName').value);
                formData.append('password', document.getElementById('password').value);
                formData.append('startDate', document.getElementById('startDate').value);
                formData.append('endDate', document.getElementById('endDate').value);
                formData.append('status', document.getElementById('status').value);
                formData.append('serverIP', document.getElementById('serverIP').value);
                formData.append('from', document.getElementById('from').value);
                
                fetch('adminApi.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    adminModal.classList.add('hidden');
                    if (data.success) {
                        showMessage('成功', data.message, 'success', () => {
                            window.location.reload();
                        });
                    } else {
                        showMessage('错误', data.message, 'error');
                    }
                })
                .catch(error => {
                    adminModal.classList.add('hidden');
                    showMessage('错误', '创建失败: ' + error.message, 'error');
                });
            }
            
            // 更新管理员
            function updateAdmin(id) {
                const formData = new FormData();
                formData.append('action', 'update');
                formData.append('adminId', id);
                formData.append('userName', document.getElementById('userName').value);
                formData.append('password', document.getElementById('password').value);
                formData.append('startDate', document.getElementById('startDate').value);
                formData.append('endDate', document.getElementById('endDate').value);
                formData.append('status', document.getElementById('status').value);
                formData.append('serverIP', document.getElementById('serverIP').value);
                formData.append('from', document.getElementById('from').value);
                
                fetch('adminApi.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    adminModal.classList.add('hidden');
                    if (data.success) {
                        showMessage('成功', data.message, 'success', () => {
                            window.location.reload();
                        });
                    } else {
                        showMessage('错误', data.message, 'error');
                    }
                })
                .catch(error => {
                    adminModal.classList.add('hidden');
                    showMessage('错误', '更新失败: ' + error.message, 'error');
                });
            }
            
            // 删除管理员
            function deleteAdmin(id) {
                const formData = new FormData();
                formData.append('action', 'delete');
                formData.append('id', id);
                
                fetch('adminApi.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    confirmModal.classList.add('hidden');
                    if (data.success) {
                        showMessage('成功', data.message, 'success', () => {
                            window.location.reload();
                        });
                    } else {
                        showMessage('错误', data.message, 'error');
                    }
                })
                .catch(error => {
                    confirmModal.classList.add('hidden');
                    showMessage('错误', '删除失败: ' + error.message, 'error');
                });
            }
            
            // 显示消息提示
            function showMessage(title, content, type = 'success', callback = null) {
                const messageTitle = document.getElementById('messageTitle');
                const messageContent = document.getElementById('messageContent');
                const messageIcon = document.getElementById('messageIcon');
                
                messageTitle.textContent = title;
                messageContent.textContent = content;
                
                // 设置图标
                if (type === 'success') {
                    messageIcon.innerHTML = '<i class="fa fa-check-circle text-green-500"></i>';
                } else {
                    messageIcon.innerHTML = '<i class="fa fa-exclamation-circle text-red-500"></i>';
                }
                
                messageModal.classList.remove('hidden');
                
                // 如果有回调函数，重新绑定关闭按钮事件
                if (callback) {
                    const originalHandler = closeMessageBtn.onclick;
                    closeMessageBtn.onclick = function() {
                        messageModal.classList.add('hidden');
                        callback();
                        closeMessageBtn.onclick = originalHandler; // 恢复原始事件
                    };
                }
            }
            
            // 格式化日期为datetime-local输入格式
            function formatDateForInput(date) {
                const year = date.getFullYear();
                const month = String(date.getMonth() + 1).padStart(2, '0');
                const day = String(date.getDate()).padStart(2, '0');
                const hours = String(date.getHours()).padStart(2, '0');
                const minutes = String(date.getMinutes()).padStart(2, '0');
                
                return `${year}-${month}-${day}T${hours}:${minutes}`;
            }
        }
    </script>
</body>
</html>
    