<?php
// 启用错误报告，方便调试
error_reporting(E_ALL);
ini_set('display_errors', 1);

// 配置区域 - 请根据实际情况修改
$botToken = '8243197376:AAHNVvMQUu_fpLTjeuf3orq5PleTK4g9LlA'; // 替换为你的机器人令牌
$webhookUrl = 'https://103.80.27.253/telegram_bot.php'; // 保持不变

// XAMPP默认证书路径（根据操作系统选择）
// Windows系统通常路径
$certPath = 'C:/xampp1/apache/conf/ssl.crt/server.crt';
// Linux/Mac系统通常路径（取消下面一行注释并注释上面一行）
// $certPath = '/opt/lampp/apache/conf/ssl.crt/server.crt';

// 调试日志文件路径
$logFile = 'bot_debug.log';

// 记录调试信息
function logDebug($message) {
    global $logFile;
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[$timestamp] $message\n";
    if (file_put_contents($logFile, $logEntry, FILE_APPEND) === false) {
        error_log("无法写入日志文件: 请检查目录权限");
    }
}

// 发送Telegram API请求
function sendTelegramRequest($method, $params = []) {
    global $botToken;
    
    $url = "https://api.telegram.org/bot{$botToken}/{$method}";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    // 本地测试环境禁用SSL验证（XAMPP自签名证书）
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    $errorNo = curl_errno($ch);
    
    curl_close($ch);
    
    // 记录请求信息用于调试
    logDebug("发送请求: $method, 参数: " . json_encode($params));
    logDebug("HTTP状态码: $httpCode");
    logDebug("错误代码: $errorNo, 错误信息: $error");
    logDebug("响应内容: $response");
    
    $result = json_decode($response, true);
    
    return [
        'success' => $result !== null && $result['ok'] === true,
        'result' => $result['result'] ?? null,
        'error' => $result['description'] ?? $error,
        'http_code' => $httpCode,
        'error_no' => $errorNo
    ];
}

// 设置Webhook（使用XAMPP默认证书）
function setWebhook() {
    global $webhookUrl, $certPath;
    
    $params = [
        'url' => $webhookUrl
    ];
    
    // 检查证书文件是否存在
    if (file_exists($certPath)) {
        $realCertPath = realpath($certPath);
        // 检查是否有权限读取证书
        if (is_readable($realCertPath)) {
            $params['certificate'] = new CURLFile($realCertPath);
            logDebug("已添加XAMPP证书: $realCertPath");
        } else {
            logDebug("没有读取证书的权限: 请检查文件权限");
        }
    } else {
        logDebug("未找到证书文件: 请检查路径是否正确");
    }
    
    return sendTelegramRequest('setWebhook', $params);
}

// 删除Webhook
function deleteWebhook() {
    return sendTelegramRequest('deleteWebhook');
}

// 获取Webhook状态
function getWebhookInfo() {
    return sendTelegramRequest('getWebhookInfo');
}

// 处理接收到的更新
function handleUpdate($update) {
    if (isset($update['message'])) {
        $message = $update['message'];
        
        // 仅处理群聊消息
        if (isset($message['chat']['type']) && ($message['chat']['type'] == 'group' || $message['chat']['type'] == 'supergroup')) {
            $chatId = $message['chat']['id'];
            $chatTitle = $message['chat']['title'] ?? '未知群组';
            
            // 响应/id命令
            if (isset($message['text']) && trim($message['text']) == '/id') {
                logDebug("在群聊 {$chatTitle} (ID: {$chatId}) 收到 /id 命令");
                
                $response = sendTelegramRequest('sendMessage', [
                    'chat_id' => $chatId,
                    'text' => "本群的ID是: {$chatId}"
                ]);
                
                if ($response['success']) {
                    logDebug("已成功回复群聊ID: {$chatId}");
                } else {
                    logDebug("回复群聊ID失败: {$response['error']}");
                }
            } else if (isset($message['text']) && trim($message['text']) == '/admin') {
                $response = sendTelegramRequest('sendMessage', [
                    'chat_id' => $chatId,
                    'text' => "数据中台:<a href='http://103.80.27.253/admin.php'>进入管理</a>"
                ]);
            }
        }
    }
}

// 处理管理操作
if (!empty($_GET)) {
    $response = [];
    
    if (isset($_GET['setwebhook'])) {
        $response = setWebhook();
        $response['message'] = $response['success'] ? 'Webhook设置成功' : 'Webhook设置失败: ' . $response['error'];
    } elseif (isset($_GET['deletewebhook'])) {
        $response = deleteWebhook();
        $response['message'] = $response['success'] ? 'Webhook删除成功' : 'Webhook删除失败: ' . $response['error'];
    } elseif (isset($_GET['getwebhookinfo'])) {
        $response = getWebhookInfo();
        $response['message'] = $response['success'] ? '获取Webhook信息成功' : '获取Webhook信息失败: ' . $response['error'];
    } elseif (isset($_GET['test'])) {
        // 测试证书路径和权限
        global $certPath;
        $response['success'] = true;
        $response['message'] = '服务器连接正常';
        $response['current_path'] = __DIR__;
        $response['log_writable'] = is_writable($logFile) ? '是' : '否';
        $response['cert_exists'] = file_exists($certPath) ? '是' : '否';
        $response['cert_readable'] = file_exists($certPath) ? (is_readable($certPath) ? '是' : '否') : 'N/A';
        $response['cert_path'] = $certPath;
    }
    
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// 处理Telegram POST请求
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    logDebug("收到POST数据: " . $input);
    
    $update = json_decode($input, true);
    
    if ($update) {
        handleUpdate($update);
        http_response_code(200);
        echo json_encode(['status' => 'success']);
    } else {
        logDebug("解析更新失败: " . json_last_error_msg());
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => '无效的更新数据']);
    }
} else {
    // 显示状态页面
    echo '<h1>Telegram 群ID查询机器人</h1>';
    echo '<p>当前目录: ' . __DIR__ . '</p>';
    echo '<p>日志文件可写: ' . (is_writable($logFile) ? '是' : '否') . '</p>';
    echo '<p>证书路径配置: ' . $certPath . '</p>';
    echo '<p>证书存在: ' . (file_exists($certPath) ? '是' : '否') . '</p>';
    echo '<p>证书可读: ' . (file_exists($certPath) ? (is_readable($certPath) ? '是' : '否') : 'N/A') . '</p>';
    echo '<p>使用以下链接进行管理操作：</p>';
    echo '<ul>';
    echo '<li><a href="?test">测试服务器连接和证书配置</a></li>';
    echo '<li><a href="?setwebhook">设置Webhook（带证书）</a></li>';
    echo '<li><a href="?deletewebhook">删除Webhook</a></li>';
    echo '<li><a href="?getwebhookinfo">查看Webhook信息</a></li>';
    echo '</ul>';
    echo '<p>调试日志：<a href="bot_debug.log" target="_blank">查看</a></p>';
}
?>
