<?php
// 设置响应类型为JSON
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *"); // 允许所有域名
header("Access-Control-Allow-Methods: GET, POST"); // 允许的请求方法
header("Access-Control-Allow-Headers: Content-Type"); // 允许的头部

require_once '../db.php';

// 数据库配置 - 请根据实际情况修改


// 初始化返回数据
$response = [
    'success' => false,
    'data' => null,
    'message' => ''
];

try {
    // 检查是否提供了sitename参数
    if (!isset($_GET['sitename'])) {
        throw new Exception('未提供sitename参数');
    }
    
    $sitename = $_GET['sitename'];
    
    // 连接数据库
    $pdo = new PDO("mysql:host=$dbHost;port=$dbPort;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // 查询记录
    $stmt = $pdo->prepare("SELECT * FROM TelSms_SysConfig WHERE sitename = :sitename LIMIT 1");
    $stmt->bindParam(':sitename', $sitename);
    $stmt->execute();
    
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($config) {
        $response['success'] = true;
        $response['data'] = $config;
        $response['message'] = '找到匹配的配置记录';
    } else {
        $response['message'] = '未找到匹配的配置记录';
    }
} catch(PDOException $e) {
    $response['message'] = '数据库错误: ' . $e->getMessage();
} catch(Exception $e) {
    $response['message'] = $e->getMessage();
}

// 输出JSON响应
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>
