<?php
// 允许前端跨域（与前端同源时可省略）
header("Access-Control-Allow-Origin: *"); // 替换为前端实际域名
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Credentials: true"); // 允许跨域传递Cookie（用于维护会话）

// 处理预检请求
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

// 读取前端发送的代理请求参数
$input = file_get_contents('php://input');
$proxyData = json_decode($input, true);

// 校验必要参数
if (empty($proxyData['targetUrl']) || empty($proxyData['method'])) {
    http_response_code(400);
    echo json_encode(['error' => '123']);
    exit;
}

$targetUrl = $proxyData['targetUrl'];
$method = strtoupper($proxyData['method']);
$params = $proxyData['params'] ?? [];
$headers = $proxyData['headers'] ?? [];

// 初始化cURL
$ch = curl_init();

// 设置目标URL
curl_setopt($ch, CURLOPT_URL, $targetUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 生产环境建议开启并配置证书
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

// 关键：维护Cookie会话（将目标网站的Cookie保存到本地文件，确保登录状态持续）
$cookieFile = __DIR__ . '/proxy_cookies/' . session_id() . '.txt';
if (!file_exists(dirname($cookieFile))) {
    mkdir(dirname($cookieFile), 0777, true);
}
curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile); // 保存Cookie
curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile); // 读取Cookie

// 设置请求方法和参数
if ($method !== 'GET') {
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    if (!empty($params)) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params)); // 表单格式参数
    }
}

// 设置请求头
$curlHeaders = [];
foreach ($headers as $key => $value) {
    $curlHeaders[] = "$key: $value";
}
curl_setopt($ch, CURLOPT_HTTPHEADER, $curlHeaders);

// 执行请求
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

// 处理错误
if (curl_errno($ch)) {
    http_response_code(500);
    echo json_encode([
        'error' => '代理请求目标网站失败',
        'details' => curl_error($ch)
    ]);
    curl_close($ch);
    exit;
}

// 关闭cURL并返回响应
curl_close($ch);
http_response_code($httpCode);
echo $response; // 直接返回目标网站的响应（XML）