<?php
session_start();
header('Content-Type: application/json');

// 数据库连接
require_once 'db.php';

try {
    // 连接数据库
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // 获取POST数据
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data || !isset($data['userName']) || !isset($data['password'])) {
        echo json_encode([
            'success' => false,
            'message' => '请提供用户名和密码'
        ]);
        exit;
    }
    
    $userName = trim($data['userName']);
    $password = trim($data['password']);
    $accountNo = isset($data['accountNo']) ? trim($data['accountNo']) : '';
    
    if (empty($userName) || empty($password)) {
        echo json_encode([
            'success' => false,
            'message' => '用户名和密码不能为空'
        ]);
        exit;
    }
    
    // 查询管理员信息
    $stmt = $pdo->prepare("SELECT * FROM TelSms_Admin WHERE UserName = :userName");
    $stmt->bindParam(':userName', $userName);
    $stmt->execute();
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($admin && $admin['Password'] === $password) {
        // 登录成功，设置会话，保存AccountNo（如果有）
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $admin['UserName'];
        if (!empty($accountNo)) {
            $_SESSION['account_no'] = $accountNo;
        }
        $_SESSION['last_activity'] = time(); // 记录最后活动时间
        
        echo json_encode([
            'success' => true,
            'message' => '登录成功'
        ]);
        exit;
    } else {
        echo json_encode([
            'success' => false,
            'message' => '用户名或密码不正确'
        ]);
        exit;
    }
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => '数据库错误: ' . $e->getMessage()
    ]);
    exit;
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '系统错误: ' . $e->getMessage()
    ]);
    exit;
}
?>
