<?php
session_start();

// 检查用户是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // 如果未登录，显示登录页面
    echo <<<HTML
    <!DOCTYPE html>
    <html lang="zh-CN">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>管理员登录 - Telegram订单管理系统</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        
        <script>
            tailwind.config = {
                theme: {
                    extend: {
                        colors: {
                            primary: '#2A86FF',
                            secondary: '#36D399',
                            warning: '#FFAB00',
                            danger: '#F87272',
                            dark: '#1E293B',
                            light: '#F8FAFC'
                        },
                        fontFamily: {
                            inter: ['Inter', 'sans-serif'],
                        },
                    }
                }
            }
        </script>
        
        <style type="text/tailwindcss">
            @layer utilities {
                .content-auto {
                    content-visibility: auto;
                }
                .card-shadow {
                    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
                }
                .transition-all-300 {
                    transition: all 300ms ease-in-out;
                }
            }
        </style>
    </head>
    <body class="bg-gray-50 font-inter min-h-screen flex items-center justify-center">
        <div class="w-full max-w-md">
            <div class="bg-white rounded-lg card-shadow p-8">
                <div class="text-center mb-6">
                    <i class="fa fa-telegram text-primary text-4xl mb-4"></i>
                    <h2 class="text-2xl font-bold">管理员登录</h2>
                    <p class="text-gray-500 mt-1">请输入账号和密码登录系统</p>
                </div>
                
                <form id="login-form">
                    <div class="mb-4">
                        <label for="username" class="block text-sm font-medium text-gray-700 mb-1">用户名</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-gray-500">
                                <i class="fa fa-user"></i>
                            </span>
                            <input type="text" id="username" name="username" value="admin"
                                class="pl-10 w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                    </div>
                    
                    <div class="mb-6">
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1">密码</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-gray-500">
                                <i class="fa fa-lock"></i>
                            </span>
                            <input type="password" id="password" name="password"
                                class="pl-10 w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300" required>
                        </div>
                    </div>
                    
                    <div id="login-error" class="hidden mb-4 p-3 bg-red-50 border border-red-200 rounded-lg text-red-600 text-sm">
                        <i class="fa fa-exclamation-circle mr-2"></i>
                        <span id="error-message"></span>
                    </div>
                    
                    <button type="submit" class="w-full bg-primary hover:bg-primary/90 text-white px-4 py-3 rounded-lg flex items-center justify-center transition-all-300 shadow-md hover:shadow-lg">
                        <i class="fa fa-sign-in mr-2"></i> 登录
                    </button>
                </form>
            </div>
        </div>
        
        <script>
            document.getElementById('login-form').addEventListener('submit', function(e) {
                e.preventDefault();
                
                const username = document.getElementById('username').value;
                const password = document.getElementById('password').value;
                const errorDiv = document.getElementById('login-error');
                const errorMessage = document.getElementById('error-message');
                
                // 简单的客户端验证
                if (username !== 'admin' || password !== '1qazse4rfvgy7') {
                    errorMessage.textContent = '用户名或密码错误';
                    errorDiv.classList.remove('hidden');
                    return;
                }
                
                // 发送登录请求
                fetch('login.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        username: username,
                        password: password
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        // 登录成功，刷新页面
                        window.location.href = 'dataAdmin.php';
                    } else {
                        errorMessage.textContent = data.message || '登录失败，请重试';
                        errorDiv.classList.remove('hidden');
                    }
                })
                .catch(error => {
                    console.error('登录请求失败:', error);
                    errorMessage.textContent = '登录失败，请重试';
                    errorDiv.classList.remove('hidden');
                });
            });
        </script>
    </body>
    </html>
HTML;
    exit;
}
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>订单数据管理 - Telegram账号管理系统</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.8/dist/chart.umd.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2A86FF',
                        secondary: '#36D399',
                        warning: '#FFAB00',
                        danger: '#F87272',
                        dark: '#1E293B',
                        light: '#F8FAFC'
                    },
                    fontFamily: {
                        inter: ['Inter', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    
    <style type="text/tailwindcss">
        @layer utilities {
            .content-auto {
                content-visibility: auto;
            }
            .card-shadow {
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            }
            .transition-all-300 {
                transition: all 300ms ease-in-out;
            }
            .table-hover-row:hover {
                background-color: rgba(42, 134, 255, 0.05);
            }
        }
    </style>
</head>
<body class="bg-gray-50 font-inter text-dark min-h-screen flex flex-col">
    <!-- 顶部导航栏 -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="container mx-auto px-4 py-3 flex items-center justify-between">
            <div class="flex items-center space-x-2">
                <i class="fa fa-telegram text-primary text-2xl"></i>
                <h1 class="text-xl font-semibold">Telegram订单管理系统</h1>
            </div>
            <div class="flex items-center space-x-6">
                <nav class="hidden md:flex space-x-6">
                    <a href="index1.php" class="text-gray-600 hover:text-primary transition-all-300 flex items-center">
                        <i class="fa fa-user-circle mr-1"></i> 账号管理
                    </a>
                    <a href="#" class="text-primary font-medium flex items-center">
                        <i class="fa fa-list-alt mr-1"></i> 订单数据
                    </a>
                    <a href="#" class="text-gray-600 hover:text-primary transition-all-300 flex items-center">
                        <i class="fa fa-bar-chart mr-1"></i> 统计分析
                    </a>
                    <a href="#" class="text-gray-600 hover:text-primary transition-all-300 flex items-center">
                        <i class="fa fa-cog mr-1"></i> 系统设置
                    </a>
                </nav>
                <div class="flex items-center space-x-4">
                    <button id="logout-btn" class="text-gray-500 hover:text-primary transition-all-300">
                        <i class="fa fa-sign-out"></i> 退出
                    </button>
                    <div class="flex items-center">
                        <img src="https://picsum.photos/id/1005/40/40" alt="用户头像" class="w-8 h-8 rounded-full mr-2">
                        <span class="text-sm font-medium">管理员</span>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- 主要内容 -->
    <main class="flex-grow container mx-auto px-4 py-6">
        <!-- 页面标题和操作栏 -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
            <div>
                <h2 class="text-[clamp(1.5rem,3vw,2rem)] font-bold">订单数据管理</h2>
                <p class="text-gray-500 mt-1">管理所有订单数据，查看、删除、批量操作</p>
            </div>
            <div class="mt-4 md:mt-0 flex flex-wrap items-center gap-3">
                <button id="batch-recommend-btn" class="bg-secondary hover:bg-secondary/90 text-white px-4 py-2 rounded-lg flex items-center transition-all-300 shadow-md hover:shadow-lg">
                    <i class="fa fa-star mr-2"></i> 批量设为推荐
                </button>
                <button id="batch-delete-btn" class="bg-danger hover:bg-danger/90 text-white px-4 py-2 rounded-lg flex items-center transition-all-300 shadow-md hover:shadow-lg">
                    <i class="fa fa-trash mr-2"></i> 批量删除
                </button>
            </div>
        </div>

        <!-- 查询条件 -->
        <div class="bg-white rounded-lg p-4 mb-6 card-shadow">
            <form id="search-form" class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-6 gap-4">
                <div>
                    <label for="search-accountno" class="block text-sm font-medium text-gray-700 mb-1">软件账号</label>
                    <input type="text" id="search-accountno" placeholder="请输入软件账号" 
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300">
                </div>
                <div>
                    <label for="search-betaccount" class="block text-sm font-medium text-gray-700 mb-1">订单会员</label>
                    <input type="text" id="search-betaccount" placeholder="请输入订单会员" 
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300">
                </div>
                <div>
                    <label for="search-betteamv" class="block text-sm font-medium text-gray-700 mb-1">球队</label>
                    <input type="text" id="search-betteamv" placeholder="请输入球队名称" 
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300">
                </div>
                <div>
                    <label for="search-betamount" class="block text-sm font-medium text-gray-700 mb-1">金额</label>
                    <input type="number" id="search-betamount" placeholder="请输入金额" 
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300">
                </div>
                <div>
                    <label for="search-bettime" class="block text-sm font-medium text-gray-700 mb-1">订单时间</label>
                    <input type="date" id="search-bettime" 
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300">
                </div>
                <div>
                    <label for="search-sendtime" class="block text-sm font-medium text-gray-700 mb-1">推送时间</label>
                    <input type="date" id="search-sendtime" 
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none transition-all-300">
                </div>
                <div class="md:col-span-3 lg:col-span-6 flex justify-end gap-3 pt-2">
                    <button type="button" id="reset-search" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-all-300">
                        <i class="fa fa-refresh mr-2"></i> 重置
                    </button>
                    <button type="submit" class="bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg flex items-center transition-all-300 shadow-md hover:shadow-lg">
                        <i class="fa fa-search mr-2"></i> 查询
                    </button>
                </div>
            </form>
        </div>

        <!-- 自动刷新设置 -->
        <div class="bg-white rounded-lg p-4 mb-6 card-shadow">
            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between">
                <div class="flex items-center space-x-2 mb-3 sm:mb-0">
                    <i class="fa fa-refresh text-primary"></i>
                    <span class="font-medium">自动刷新</span>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="flex items-center">
                        <input type="checkbox" id="auto-refresh-toggle" class="w-5 h-5 rounded text-primary focus:ring-primary/30" checked>
                        <label for="auto-refresh-toggle" class="ml-2 text-sm text-gray-700">开启自动刷新</label>
                    </div>
                    <div class="flex items-center">
                        <span class="text-sm text-gray-700 mr-2">刷新间隔(秒):</span>
                        <div class="relative">
                            <select id="refresh-interval" class="pl-3 pr-8 py-1.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary/30 focus:border-primary outline-none text-sm appearance-none">
                                <option value="10">10</option>
                                <option value="20">20</option>
                                <option value="30" selected>30</option>
                                <option value="60">60</option>
                                <option value="120">120</option>
                            </select>
                            <i class="fa fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none text-xs"></i>
                        </div>
                    </div>
                    <span id="last-refresh" class="text-xs text-gray-500">最后刷新: 未刷新</span>
                </div>
            </div>
        </div>

        <!-- 订单列表 -->
        <div class="bg-white rounded-lg overflow-hidden card-shadow mb-6">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <th class="px-3 py-3 w-10">
                                <input type="checkbox" id="select-all" class="w-4 h-4 rounded text-primary focus:ring-primary/30">
                            </th>
                            <th class="px-3 py-3">ID</th>
                            <th class="px-3 py-3">软件账号</th>
                            <th class="px-3 py-3">订单会员</th>
                            <th class="px-3 py-3">订单编号</th>
                            <th class="px-3 py-3">类型</th>
                            <th class="px-3 py-3">名称</th>
                            <th class="px-3 py-3">盘口</th>
                            <th class="px-3 py-3">投注项</th>
                            <th class="px-3 py-3">赔率</th>
                            <th class="px-3 py-3">订单时间</th>
                            <th class="px-3 py-3">球队</th>
                            <th class="px-3 py-3">金额</th>
                            <th class="px-3 py-3">创建时间</th>
                            <th class="px-3 py-3">推送时间</th>
                            <th class="px-3 py-3">推送状态</th>
                            <th class="px-3 py-3">推荐状态</th>
                            <th class="px-3 py-3">操作</th>
                        </tr>
                    </thead>
                    <tbody id="betlist-table-body" class="divide-y divide-gray-200">
                        <!-- 订单数据将通过JavaScript动态填充 -->
                    </tbody>
                </table>
            </div>

            <!-- 分页控件 -->
            <div class="px-6 py-4 flex items-center justify-between border-t border-gray-200">
                <div class="flex-1 flex justify-between sm:hidden">
                    <button id="prev-page-mobile" class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        上一页
                    </button>
                    <button id="next-page-mobile" class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        下一页
                    </button>
                </div>
                <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                    <div>
                        <p class="text-sm text-gray-700">
                            显示 <span id="start-item">0</span> 到 <span id="end-item">0</span> 条，共 <span id="total-items">0</span> 条记录
                        </p>
                    </div>
                    <div>
                        <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px" aria-label="Pagination">
                            <button id="prev-page" class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <span class="sr-only">上一页</span>
                                <i class="fa fa-chevron-left text-xs"></i>
                            </button>
                            <div id="pagination-numbers" class="inline-flex">
                                <!-- 页码将通过JavaScript动态填充 -->
                            </div>
                            <button id="next-page" class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <span class="sr-only">下一页</span>
                                <i class="fa fa-chevron-right text-xs"></i>
                            </button>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <!-- 订单统计卡片 -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
            <div class="bg-white rounded-lg p-6 card-shadow border-l-4 border-primary">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">总订单数</p>
                        <h3 class="text-3xl font-bold mt-1" id="total-orders">0</h3>
                    </div>
                    <div class="w-12 h-12 rounded-full bg-primary/10 flex items-center justify-center">
                        <i class="fa fa-file-text-o text-primary text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center">
                    <span class="text-green-500 text-sm flex items-center">
                        <i class="fa fa-arrow-up mr-1"></i> 12.5%
                    </span>
                    <span class="text-xs text-gray-500 ml-2">较昨日</span>
                </div>
            </div>
            <div class="bg-white rounded-lg p-6 card-shadow border-l-4 border-secondary">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">已推送</p>
                        <h3 class="text-3xl font-bold mt-1" id="sent-orders">0</h3>
                    </div>
                    <div class="w-12 h-12 rounded-full bg-secondary/10 flex items-center justify-center">
                        <i class="fa fa-check-circle text-secondary text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center">
                    <span class="text-green-500 text-sm flex items-center">
                        <i class="fa fa-arrow-up mr-1"></i> 8.2%
                    </span>
                    <span class="text-xs text-gray-500 ml-2">较昨日</span>
                </div>
            </div>
            <div class="bg-white rounded-lg p-6 card-shadow border-l-4 border-warning">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">未推送</p>
                        <h3 class="text-3xl font-bold mt-1" id="unsent-orders">0</h3>
                    </div>
                    <div class="w-12 h-12 rounded-full bg-warning/10 flex items-center justify-center">
                        <i class="fa fa-clock-o text-warning text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center">
                    <span class="text-red-500 text-sm flex items-center">
                        <i class="fa fa-arrow-up mr-1"></i> 3.3%
                    </span>
                    <span class="text-xs text-gray-500 ml-2">较昨日</span>
                </div>
            </div>
            <div class="bg-white rounded-lg p-6 card-shadow border-l-4 border-purple-500">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">推荐订单</p>
                        <h3 class="text-3xl font-bold mt-1" id="recommended-orders">0</h3>
                    </div>
                    <div class="w-12 h-12 rounded-full bg-purple-500/10 flex items-center justify-center">
                        <i class="fa fa-star text-purple-500 text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center">
                    <span class="text-green-500 text-sm flex items-center">
                        <i class="fa fa-arrow-up mr-1"></i> 5.7%
                    </span>
                    <span class="text-xs text-gray-500 ml-2">较昨日</span>
                </div>
            </div>
        </div>

        <!-- 订单状态图表 -->
        <div class="bg-white rounded-lg p-6 card-shadow">
            <div class="flex items-center justify-between mb-6">
                <h3 class="font-semibold text-lg">订单状态分布</h3>
                <div class="flex space-x-2">
                    <button class="text-sm text-gray-500 hover:text-primary transition-all-300">
                        <i class="fa fa-download mr-1"></i> 导出
                    </button>
                    <button class="text-sm text-gray-500 hover:text-primary transition-all-300">
                        <i class="fa fa-ellipsis-v"></i>
                    </button>
                </div>
            </div>
            <div class="h-64">
                <canvas id="order-status-chart"></canvas>
            </div>
        </div>
    </main>

    <!-- 页脚 -->
    <footer class="bg-white border-t border-gray-200 py-4">
        <div class="container mx-auto px-4 text-center text-sm text-gray-500">
            <p>© 2025 Telegram订单管理系统. 保留所有权利.</p>
        </div>
    </footer>

    <!-- 查看订单详情模态框 -->
    <div id="detail-modal" class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-3xl max-h-[90vh] overflow-y-auto">
            <div class="flex items-center justify-between p-6 border-b">
                <h3 class="text-lg font-semibold">订单详情</h3>
                <button id="close-detail-modal" class="text-gray-400 hover:text-gray-500">
                    <i class="fa fa-times text-xl"></i>
                </button>
            </div>
            <div class="p-6" id="order-detail-content">
                <!-- 订单详情内容将通过JavaScript动态填充 -->
            </div>
        </div>
    </div>

    <!-- 确认删除模态框 -->
    <div id="confirm-delete-modal" class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
            <div class="p-6">
                <div class="text-center mb-4">
                    <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fa fa-trash text-red-500 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold">确认删除</h3>
                    <p class="text-gray-500 mt-2" id="delete-confirmation-text">你确定要删除这个订单吗？此操作不可撤销。</p>
                </div>
                <div class="flex justify-center space-x-3 pt-4 border-t">
                    <button id="cancel-delete" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-all-300">
                        取消
                    </button>
                    <button id="confirm-delete" class="px-4 py-2 bg-red-500 text-white rounded-lg hover:bg-red-600 transition-all-300 shadow-md hover:shadow-lg">
                        确认删除
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- 通知提示 -->
    <div id="notification" class="fixed top-4 right-4 z-50 max-w-sm transform translate-x-full transition-all duration-300 ease-in-out">
        <div class="bg-white rounded-lg shadow-lg p-4 flex items-start">
            <div id="notification-icon" class="w-6 h-6 rounded-full flex items-center justify-center mr-3">
                <i class="fa fa-check text-white"></i>
            </div>
            <div class="flex-1">
                <h4 id="notification-title" class="font-medium text-sm"></h4>
                <p id="notification-message" class="text-xs text-gray-500 mt-1"></p>
            </div>
            <button id="close-notification" class="text-gray-400 hover:text-gray-600 ml-2">
                <i class="fa fa-times"></i>
            </button>
        </div>
    </div>

    <script>
        // 全局变量
        let currentPage = 1;
        let totalPages = 1;
        let searchParams = {};
        let autoRefreshInterval = null;
        let selectedIds = [];
        let chartInstance = null;
        let deleteMode = 'single'; // 'single' 或 'batch'
        let currentDeleteId = null;
        let currentDeleteAccountNo = null;

        // DOM 加载完成后执行
        document.addEventListener('DOMContentLoaded', function() {
            // 初始化页面
            loadBetList();
            initEventListeners();
            initChart();
            startAutoRefresh(); // 默认开启自动刷新
        });

        // 初始化事件监听器
        function initEventListeners() {
            // 退出登录按钮
            document.getElementById('logout-btn').addEventListener('click', function() {
                if (confirm('确定要退出登录吗？')) {
                    fetch('logout.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            window.location.href = 'dataAdmin.php';
                        } else {
                            showNotification('错误', data.message || '退出登录失败', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('退出登录失败:', error);
                        showNotification('错误', '退出登录失败，请重试', 'error');
                    });
                }
            });

            // 查询表单提交
            document.getElementById('search-form').addEventListener('submit', function(e) {
                e.preventDefault();
                // 获取查询参数
                searchParams = {
                    accountno: document.getElementById('search-accountno').value.trim(),
                    betaccount: document.getElementById('search-betaccount').value.trim(),
                    betteamv: document.getElementById('search-betteamv').value.trim(),
                    betamount: document.getElementById('search-betamount').value.trim(),
                    bettime: document.getElementById('search-bettime').value,
                    sendtime: document.getElementById('search-sendtime').value
                };
                currentPage = 1;
                loadBetList();
            });

            // 重置查询条件
            document.getElementById('reset-search').addEventListener('click', function() {
                document.getElementById('search-form').reset();
                searchParams = {};
                currentPage = 1;
                loadBetList();
            });

            // 全选复选框
            document.getElementById('select-all').addEventListener('change', function() {
                const checkboxes = document.querySelectorAll('.row-checkbox');
                selectedIds = [];
                
                if (this.checked) {
                    checkboxes.forEach(checkbox => {
                        checkbox.checked = true;
                        selectedIds.push(checkbox.getAttribute('data-id'));
                    });
                } else {
                    checkboxes.forEach(checkbox => {
                        checkbox.checked = false;
                    });
                    selectedIds = [];
                }
                
                updateBatchButtonStates();
            });

            // 批量设为推荐按钮
            document.getElementById('batch-recommend-btn').addEventListener('click', function() {
                if (selectedIds.length === 0) {
                    showNotification('提示', '请先选择要操作的订单', 'info');
                    return;
                }
                
                if (confirm(`确定要将选中的 ${selectedIds.length} 条订单设为推荐数据吗？`)) {
                    batchSetRecommended(selectedIds);
                }
            });

            // 批量删除按钮
            document.getElementById('batch-delete-btn').addEventListener('click', function() {
                if (selectedIds.length === 0) {
                    showNotification('提示', '请先选择要删除的订单', 'info');
                    return;
                }
                
                deleteMode = 'batch';
                document.getElementById('delete-confirmation-text').textContent = 
                    `你确定要删除选中的 ${selectedIds.length} 条订单吗？此操作不可撤销。`;
                document.getElementById('confirm-delete-modal').classList.remove('hidden');
            });

            // 上一页按钮
            document.getElementById('prev-page').addEventListener('click', function() {
                if (currentPage > 1) {
                    currentPage--;
                    loadBetList();
                }
            });

            // 下一页按钮
            document.getElementById('next-page').addEventListener('click', function() {
                if (currentPage < totalPages) {
                    currentPage++;
                    loadBetList();
                }
            });

            // 移动端上一页按钮
            document.getElementById('prev-page-mobile').addEventListener('click', function() {
                if (currentPage > 1) {
                    currentPage--;
                    loadBetList();
                }
            });

            // 移动端下一页按钮
            document.getElementById('next-page-mobile').addEventListener('click', function() {
                if (currentPage < totalPages) {
                    currentPage++;
                    loadBetList();
                }
            });

            // 自动刷新开关
            document.getElementById('auto-refresh-toggle').addEventListener('change', function() {
                if (this.checked) {
                    startAutoRefresh();
                } else {
                    stopAutoRefresh();
                }
            });

            // 刷新间隔选择
            document.getElementById('refresh-interval').addEventListener('change', function() {
                if (document.getElementById('auto-refresh-toggle').checked) {
                    stopAutoRefresh();
                    startAutoRefresh();
                }
            });

            // 关闭通知
            document.getElementById('close-notification').addEventListener('click', function() {
                hideNotification();
            });

            // 关闭详情模态框
            document.getElementById('close-detail-modal').addEventListener('click', function() {
                document.getElementById('detail-modal').classList.add('hidden');
            });

            // 取消删除
            document.getElementById('cancel-delete').addEventListener('click', function() {
                document.getElementById('confirm-delete-modal').classList.add('hidden');
            });

            // 确认删除
            document.getElementById('confirm-delete').addEventListener('click', function() {
                if (deleteMode === 'single' && currentDeleteId) {
                    deleteOrder(currentDeleteId);
                } else if (deleteMode === 'batch' && selectedIds.length > 0) {
                    batchDeleteOrders(selectedIds);
                } else if (deleteMode === 'account' && currentDeleteAccountNo) {
                    deleteByAccountNo(currentDeleteAccountNo);
                }
                document.getElementById('confirm-delete-modal').classList.add('hidden');
            });
        }

        // 初始化图表
        function initChart() {
            const ctx = document.getElementById('order-status-chart').getContext('2d');
            
            chartInstance = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ['已推送', '未推送', '推荐数据'],
                    datasets: [{
                        data: [0, 0, 0],
                        backgroundColor: [
                            '#36D399',
                            '#FFAB00',
                            '#A855F7'
                        ],
                        borderWidth: 0,
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'right',
                        }
                    },
                    cutout: '70%'
                }
            });
        }

        // 更新图表数据
        function updateChartData(sent, unsent, recommended) {
            if (chartInstance) {
                chartInstance.data.datasets[0].data = [sent, unsent, recommended];
                chartInstance.update();
            }
        }

        // 加载订单列表数据
        function loadBetList() {
            const limit = 10;
            const tableBody = document.getElementById('betlist-table-body');
            const paginationNumbers = document.getElementById('pagination-numbers');
            const startItemEl = document.getElementById('start-item');
            const endItemEl = document.getElementById('end-item');
            const totalItemsEl = document.getElementById('total-items');

            // 显示加载状态
            tableBody.innerHTML = `
                <tr>
                    <td colspan="18" class="px-6 py-10 text-center">
                        <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-primary"></div>
                        <p class="mt-2 text-gray-500">加载中...</p>
                    </td>
                </tr>
            `;

            // 构建查询参数
            const params = new URLSearchParams();
            params.append('page', currentPage);
            params.append('limit', limit);
            
            // 添加搜索参数
            for (const [key, value] of Object.entries(searchParams)) {
                if (value) {
                    params.append(key, value);
                }
            }

            // 发送请求获取订单数据
            fetch(`api/betlist_list.php?${params.toString()}`)
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success' && data.data && data.data.length > 0) {
                        // 清空表格
                        tableBody.innerHTML = '';

                        // 填充表格数据
                        data.data.forEach(order => {
                            const row = document.createElement('tr');
                            row.className = 'table-hover-row';
                            row.innerHTML = `
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <input type="checkbox" class="row-checkbox w-4 h-4 rounded text-primary focus:ring-primary/30" data-id="${order.Id}">
                                </td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm font-medium text-gray-900">${order.Id}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.AccountNo}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetAccount}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetNo}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetType}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetName}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetHandType}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetItem}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetOdds}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${formatDateTime(order.BetTime)}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetTeamV}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.BetAmount}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${formatDateTime(order.CreateDate)}</td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-700">${order.SendTime ? formatDateTime(order.SendTime) : '-'}</td>
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full ${order.SmsStatus == 1 ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'}">
                                        ${order.SmsStatus == 1 ? '已推送' : '未推送'}
                                    </span>
                                </td>
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full ${order.BetStatus == 1 ? 'bg-purple-100 text-purple-800' : 'bg-gray-100 text-gray-800'}">
                                        ${order.BetStatus == 1 ? '推荐' : '普通'}
                                    </span>
                                </td>
                                <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <button class="text-primary hover:text-primary/80 mr-3 view-order" data-id="${order.Id}">
                                        <i class="fa fa-eye"></i> 查看
                                    </button>
                                    <button class="text-purple-500 hover:text-purple-600 mr-3 set-recommend" data-id="${order.Id}" data-status="${order.BetStatus}">
                                        <i class="fa fa-star"></i> ${order.BetStatus == 1 ? '取消推荐' : '设为推荐'}
                                    </button>
                                    <button class="text-red-500 hover:text-red-600 delete-order" data-id="${order.Id}">
                                        <i class="fa fa-trash"></i> 删除
                                    </button>
                                </td>
                            `;
                            tableBody.appendChild(row);
                        });

                        // 添加行复选框事件
                        document.querySelectorAll('.row-checkbox').forEach(checkbox => {
                            checkbox.addEventListener('change', function() {
                                const id = this.getAttribute('data-id');
                                if (this.checked) {
                                    if (!selectedIds.includes(id)) {
                                        selectedIds.push(id);
                                    }
                                } else {
                                    selectedIds = selectedIds.filter(item => item !== id);
                                    document.getElementById('select-all').checked = false;
                                }
                                updateBatchButtonStates();
                            });
                        });

                        // 添加查看订单事件
                        document.querySelectorAll('.view-order').forEach(button => {
                            button.addEventListener('click', function() {
                                const orderId = this.getAttribute('data-id');
                                viewOrderDetail(orderId);
                            });
                        });

                        // 添加设为推荐事件
                        document.querySelectorAll('.set-recommend').forEach(button => {
                            button.addEventListener('click', function() {
                                const orderId = this.getAttribute('data-id');
                                const currentStatus = parseInt(this.getAttribute('data-status'));
                                const newStatus = currentStatus === 1 ? 0 : 1;
                                
                                setRecommended(orderId, newStatus);
                            });
                        });

                        // 添加删除订单事件
                        document.querySelectorAll('.delete-order').forEach(button => {
                            button.addEventListener('click', function() {
                                deleteMode = 'single';
                                currentDeleteId = this.getAttribute('data-id');
                                document.getElementById('delete-confirmation-text').textContent = 
                                    '你确定要删除这个订单吗？此操作不可撤销。';
                                document.getElementById('confirm-delete-modal').classList.remove('hidden');
                            });
                        });

                        // 添加按AccountNo批量删除的按钮
                        const accountGroups = {};
                        data.data.forEach(order => {
                            if (!accountGroups[order.AccountNo]) {
                                accountGroups[order.AccountNo] = 1;
                            } else {
                                accountGroups[order.AccountNo]++;
                            }
                        });

                        // 这里可以添加按AccountNo批量删除的UI元素
                    } else {
                        // 无数据时显示提示
                        tableBody.innerHTML = `
                            <tr>
                                <td colspan="18" class="px-6 py-10 text-center">
                                    <i class="fa fa-inbox text-gray-300 text-4xl mb-3"></i>
                                    <p class="text-gray-500">暂无订单数据</p>
                                </td>
                            </tr>
                        `;
                    }

                    // 更新分页信息
                    totalPages = data.pages || 1;
                    startItemEl.textContent = data.total > 0 ? ((currentPage - 1) * limit + 1) : 0;
                    endItemEl.textContent = Math.min(currentPage * limit, data.total);
                    totalItemsEl.textContent = data.total;

                    // 更新分页按钮
                    updatePagination();

                    // 更新统计卡片
                    updateStats(data.stats || {
                        total: 0,
                        sent: 0,
                        unsent: 0,
                        recommended: 0
                    });

                    // 更新图表
                    updateChartData(data.stats.sent || 0, data.stats.unsent || 0, data.stats.recommended || 0);

                    // 更新最后刷新时间
                    document.getElementById('last-refresh').textContent = `最后刷新: ${new Date().toLocaleTimeString()}`;
                })
                .catch(error => {
                    console.error('获取订单数据失败:', error);
                    tableBody.innerHTML = `
                        <tr>
                            <td colspan="18" class="px-6 py-10 text-center">
                                <i class="fa fa-exclamation-triangle text-red-500 text-2xl mb-2"></i>
                                <p class="text-red-500">加载数据失败，请重试</p>
                            </td>
                        </tr>
                    `;
                });
        }

        // 更新批量操作按钮状态
        function updateBatchButtonStates() {
            const batchRecommendBtn = document.getElementById('batch-recommend-btn');
            const batchDeleteBtn = document.getElementById('batch-delete-btn');
            
            if (selectedIds.length > 0) {
                batchRecommendBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                batchRecommendBtn.disabled = false;
                batchDeleteBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                batchDeleteBtn.disabled = false;
            } else {
                batchRecommendBtn.classList.add('opacity-50', 'cursor-not-allowed');
                batchRecommendBtn.disabled = true;
                batchDeleteBtn.classList.add('opacity-50', 'cursor-not-allowed');
                batchDeleteBtn.disabled = true;
            }
        }

        // 更新分页按钮
        function updatePagination() {
            const paginationNumbers = document.getElementById('pagination-numbers');
            paginationNumbers.innerHTML = '';

            // 只显示当前页附近的页码
            let startPage = Math.max(1, currentPage - 2);
            let endPage = Math.min(totalPages, startPage + 4);

            if (endPage - startPage < 4 && startPage > 1) {
                startPage = Math.max(1, endPage - 4);
            }

            // 添加第一页按钮
            if (startPage > 1) {
                addPageButton(1);
                if (startPage > 2) {
                    addEllipsis();
                }
            }

            // 添加中间页码
            for (let i = startPage; i <= endPage; i++) {
                addPageButton(i);
            }

            // 添加最后一页按钮
            if (endPage < totalPages) {
                if (endPage < totalPages - 1) {
                    addEllipsis();
                }
                addPageButton(totalPages);
            }

            // 禁用/启用上一页和下一页按钮
            document.getElementById('prev-page').disabled = currentPage === 1;
            document.getElementById('next-page').disabled = currentPage === totalPages;
            document.getElementById('prev-page-mobile').disabled = currentPage === 1;
            document.getElementById('next-page-mobile').disabled = currentPage === totalPages;
        }

        // 添加分页按钮
        function addPageButton(pageNum) {
            const paginationNumbers = document.getElementById('pagination-numbers');
            const button = document.createElement('button');
            button.className = `relative inline-flex items-center px-4 py-2 border border-gray-300 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50 ${currentPage === pageNum ? 'bg-primary text-white border-primary' : ''}`;
            button.textContent = pageNum;
            button.addEventListener('click', function() {
                currentPage = pageNum;
                loadBetList();
            });
            paginationNumbers.appendChild(button);
        }

        // 添加省略号
        function addEllipsis() {
            const paginationNumbers = document.getElementById('pagination-numbers');
            const span = document.createElement('span');
            span.className = 'relative inline-flex items-center px-4 py-2 border border-gray-300 bg-white text-sm font-medium text-gray-700';
            span.textContent = '...';
            paginationNumbers.appendChild(span);
        }

        // 更新统计卡片
        function updateStats(stats) {
            document.getElementById('total-orders').textContent = stats.total || 0;
            document.getElementById('sent-orders').textContent = stats.sent || 0;
            document.getElementById('unsent-orders').textContent = stats.unsent || 0;
            document.getElementById('recommended-orders').textContent = stats.recommended || 0;
        }

        // 查看订单详情
        function viewOrderDetail(orderId) {
            const detailContent = document.getElementById('order-detail-content');
            
            // 显示加载状态
            detailContent.innerHTML = `
                <div class="text-center py-10">
                    <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-primary"></div>
                    <p class="mt-2 text-gray-500">加载中...</p>
                </div>
            `;
            
            // 显示模态框
            document.getElementById('detail-modal').classList.remove('hidden');
            
            // 获取订单详情
            fetch(`api/get_betlist.php?Id=${orderId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success' && data.data) {
                        const order = data.data;
                        detailContent.innerHTML = `
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">ID</h4>
                                    <p class="font-medium">${order.Id}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">软件账号</h4>
                                    <p class="font-medium">${order.AccountNo}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">订单会员</h4>
                                    <p class="font-medium">${order.BetAccount}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">订单编号</h4>
                                    <p class="font-medium">${order.BetNo}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">类型</h4>
                                    <p class="font-medium">${order.BetType}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">名称</h4>
                                    <p class="font-medium">${order.BetName}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">盘口</h4>
                                    <p class="font-medium">${order.BetHandType}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">投注项</h4>
                                    <p class="font-medium">${order.BetItem}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">赔率</h4>
                                    <p class="font-medium">${order.BetOdds}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">订单时间</h4>
                                    <p class="font-medium">${formatDateTime(order.BetTime)}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">球队</h4>
                                    <p class="font-medium">${order.BetTeamV}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">金额</h4>
                                    <p class="font-medium">${order.BetAmount}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">创建时间</h4>
                                    <p class="font-medium">${formatDateTime(order.CreateDate)}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">推送时间</h4>
                                    <p class="font-medium">${order.SendTime ? formatDateTime(order.SendTime) : '-'}</p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">推送状态</h4>
                                    <p class="font-medium">
                                        <span class="px-2 py-1 text-xs font-medium rounded-full ${order.SmsStatus == 1 ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'}">
                                            ${order.SmsStatus == 1 ? '已推送' : '未推送'}
                                        </span>
                                    </p>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-gray-500 mb-1">推荐状态</h4>
                                    <p class="font-medium">
                                        <span class="px-2 py-1 text-xs font-medium rounded-full ${order.BetStatus == 1 ? 'bg-purple-100 text-purple-800' : 'bg-gray-100 text-gray-800'}">
                                            ${order.BetStatus == 1 ? '推荐' : '普通'}
                                        </span>
                                    </p>
                                </div>
                            </div>
                            <div class="mt-6 pt-6 border-t">
                                <button class="bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg flex items-center transition-all-300 shadow-md hover:shadow-lg" 
                                        onclick="window.location.href='#'">
                                    <i class="fa fa-edit mr-2"></i> 编辑订单
                                </button>
                            </div>
                        `;
                    } else {
                        detailContent.innerHTML = `
                            <div class="text-center py-10">
                                <i class="fa fa-exclamation-triangle text-red-500 text-2xl mb-2"></i>
                                <p class="text-red-500">${data.message || '获取订单详情失败'}</p>
                            </div>
                        `;
                    }
                })
                .catch(error => {
                    console.error('获取订单详情失败:', error);
                    detailContent.innerHTML = `
                        <div class="text-center py-10">
                            <i class="fa fa-exclamation-triangle text-red-500 text-2xl mb-2"></i>
                            <p class="text-red-500">获取订单详情失败，请重试</p>
                        </div>
                    `;
                });
        }

        // 设置订单为推荐/取消推荐
        function setRecommended(orderId, status) {
            fetch('api/set_recommended.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    Id: orderId,
                    BetStatus: status
                })
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    showNotification('成功', status === 1 ? '已设为推荐数据' : '已取消推荐', 'success');
                    loadBetList();
                } else {
                    showNotification('错误', result.message, 'error');
                }
            })
            .catch(error => {
                console.error('设置推荐状态失败:', error);
                showNotification('错误', '操作失败，请重试', 'error');
            });
        }

        // 批量设置推荐
        function batchSetRecommended(ids) {
            fetch('api/batch_set_recommended.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    ids: ids,
                    BetStatus: 1
                })
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    showNotification('成功', `已成功设置 ${result.affected} 条数据为推荐`, 'success');
                    selectedIds = [];
                    document.getElementById('select-all').checked = false;
                    updateBatchButtonStates();
                    loadBetList();
                } else {
                    showNotification('错误', result.message, 'error');
                }
            })
            .catch(error => {
                console.error('批量设置推荐失败:', error);
                showNotification('错误', '操作失败，请重试', 'error');
            });
        }

        // 删除订单
        function deleteOrder(orderId) {
            fetch('api/delete_betlist.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ Id: orderId })
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    showNotification('成功', '订单已删除', 'success');
                    loadBetList();
                } else {
                    showNotification('错误', result.message, 'error');
                }
            })
            .catch(error => {
                console.error('删除订单失败:', error);
                showNotification('错误', '删除失败，请重试', 'error');
            });
        }

        // 批量删除订单
        function batchDeleteOrders(ids) {
            fetch('api/batch_delete_betlist.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ ids: ids })
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    showNotification('成功', `已成功删除 ${result.affected} 条订单`, 'success');
                    selectedIds = [];
                    document.getElementById('select-all').checked = false;
                    updateBatchButtonStates();
                    loadBetList();
                } else {
                    showNotification('错误', result.message, 'error');
                }
            })
            .catch(error => {
                console.error('批量删除订单失败:', error);
                showNotification('错误', '删除失败，请重试', 'error');
            });
        }

        // 按AccountNo删除订单
        function deleteByAccountNo(accountNo) {
            fetch('api/delete_betlist_by_account.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ AccountNo: accountNo })
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    showNotification('成功', `已成功删除 ${result.affected} 条订单`, 'success');
                    loadBetList();
                } else {
                    showNotification('错误', result.message, 'error');
                }
            })
            .catch(error => {
                console.error('按账号删除订单失败:', error);
                showNotification('错误', '删除失败，请重试', 'error');
            });
        }

        // 显示通知
        function showNotification(title, message, type = 'success') {
            const notification = document.getElementById('notification');
            const notificationTitle = document.getElementById('notification-title');
            const notificationMessage = document.getElementById('notification-message');
            const notificationIcon = document.getElementById('notification-icon');

            // 设置通知内容
            notificationTitle.textContent = title;
            notificationMessage.textContent = message;

            // 设置通知类型
            if (type === 'success') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-green-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-check text-white"></i>';
            } else if (type === 'error') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-red-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-times text-white"></i>';
            } else if (type === 'warning') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-yellow-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-exclamation text-white"></i>';
            } else if (type === 'info') {
                notificationIcon.className = 'w-6 h-6 rounded-full bg-blue-500 flex items-center justify-center mr-3';
                notificationIcon.innerHTML = '<i class="fa fa-info text-white"></i>';
            }

            // 显示通知
            notification.classList.remove('translate-x-full');

            // 3秒后自动隐藏
            setTimeout(hideNotification, 3000);
        }

        // 隐藏通知
        function hideNotification() {
            const notification = document.getElementById('notification');
            notification.classList.add('translate-x-full');
        }

        // 开始自动刷新
        function startAutoRefresh() {
            const interval = parseInt(document.getElementById('refresh-interval').value) * 1000;
            
            // 清除已有的定时器
            if (autoRefreshInterval) {
                clearInterval(autoRefreshInterval);
            }
            
            // 设置新的定时器
            autoRefreshInterval = setInterval(loadBetList, interval);
        }

        // 停止自动刷新
        function stopAutoRefresh() {
            if (autoRefreshInterval) {
                clearInterval(autoRefreshInterval);
                autoRefreshInterval = null;
            }
        }

        // 格式化日期时间
        function formatDateTime(dateString) {
            if (!dateString) return '';
            
            const date = new Date(dateString);
            if (isNaN(date.getTime())) return dateString;
            
            return date.toLocaleString('zh-CN', {
                year: 'numeric',
                month: '2-digit',
                day: '2-digit',
                hour: '2-digit',
                minute: '2-digit',
                second: '2-digit'
            });
        }
    </script>
</body>
</html>
    