<?php
session_start();
header('Content-Type: application/json');
require_once 'db.php';

// 检查用户是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode([
        'success' => false,
        'message' => '请先登录'
    ]);
    exit;
}

// 数据库连接

try {
    // 连接数据库
    $pdo = new PDO("mysql:host=$dbHost;port=$dbPort;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // 获取POST数据
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data || !isset($data['currentPassword']) || !isset($data['newPassword']) || !isset($data['confirmPassword'])) {
        echo json_encode([
            'success' => false,
            'message' => '请提供完整的密码信息'
        ]);
        exit;
    }
    
    $currentPassword = trim($data['currentPassword']);
    $newPassword = trim($data['newPassword']);
    $confirmPassword = trim($data['confirmPassword']);
    $accountNo = isset($data['accountNo']) ? trim($data['accountNo']) : '';
    
    // 验证输入
    if (empty($currentPassword) || empty($newPassword) || empty($confirmPassword)) {
        echo json_encode([
            'success' => false,
            'message' => '所有字段都不能为空'
        ]);
        exit;
    }
    
    if ($newPassword !== $confirmPassword) {
        echo json_encode([
            'success' => false,
            'message' => '两次输入的新密码不一致'
        ]);
        exit;
    }
    
    if (strlen($newPassword) < 6) {
        echo json_encode([
            'success' => false,
            'message' => '新密码长度不能少于6位'
        ]);
        exit;
    }
    
    // 获取当前管理员信息
    $username = $_SESSION['admin_username'];
    $stmt = $pdo->prepare("SELECT * FROM TelSms_Admin WHERE UserName = :userName");
    $stmt->bindParam(':userName', $username);
    $stmt->execute();
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$admin) {
        echo json_encode([
            'success' => false,
            'message' => '用户不存在'
        ]);
        exit;
    }
    
    if ($admin['Password'] !== $currentPassword) {
        echo json_encode([
            'success' => false,
            'message' => '当前密码不正确'
        ]);
        exit;
    }
    
    // 更新密码
    $updateStmt = $pdo->prepare("UPDATE TelSms_Admin SET Password = :password WHERE UserName = :userName");
    $updateStmt->bindParam(':password', $newPassword);
    $updateStmt->bindParam(':userName', $username);
    $updateStmt->execute();
    
    // 保存AccountNo用于跳转（如果有）
    $redirectData = [];
    if (!empty($accountNo)) {
        $redirectData['accountNo'] = $accountNo;
    }
    
    // 密码修改成功，销毁当前会话
    session_unset();
    session_destroy();
    
    echo json_encode([
        'success' => true,
        'message' => '密码修改成功',
        'redirectData' => $redirectData
    ]);
    exit;
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => '数据库错误: ' . $e->getMessage()
    ]);
    exit;
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '系统错误: ' . $e->getMessage()
    ]);
    exit;
}
?>
