<?php


header("Access-Control-Allow-Origin: *"); // 允许所有域名
header("Access-Control-Allow-Methods: GET, POST"); // 允许的请求方法
header("Access-Control-Allow-Headers: Content-Type"); // 允许的头部

// 数据库连接配置
require_once 'db.php';

// 创建连接
$conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

// 检查连接
if ($conn->connect_error) {
    die("连接失败: " . $conn->connect_error);
}

// 设置字符集
$conn->set_charset("utf8mb4");

// 处理AJAX请求
if (isset($_GET["action"])) {

     header('Content-Type: application/json');
     $inputData = json_decode(file_get_contents('php://input'), true);
    
    switch ($inputData["action"]) {
        case "list":
            // 获取列表数据
            $sql = "SELECT * FROM TelSms_BotConfig ORDER BY ID DESC";
            $result = $conn->query($sql);
            
            $data = array();
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            }
            
            echo json_encode(array("status" => "success", "data" => $data));
            break;
            
        case "add":
            // 添加记录
            $botId = $inputData["BotId"];
            $accountNoList = $inputData["AccountNoList"];
            $hgAdminList = $inputData["HgAdminList"];
            $uid = $inputData["Uid"];
            $cookie = $inputData["Cookie"];
            $selMaxId = $inputData["SelMaxId"];
            $status = isset($inputData["Status"]) ? 1 : 0;
            $memo = $inputData["Memo"];
            $createDate = date("Y-m-d H:i:s");
            
            // 原有扩展字段
            $actionName = $inputData["ActionName"] ?? '';
            $loginLayer = $inputData["Login_Layer"] ?? '';
            $langx = $inputData["Langx"] ?? '';
            $ver = $inputData["Ver"] ?? '';
            $actionP = $inputData["ActionP"] ?? '';
            $sid = $inputData["Sid"] ?? '';
            $suUser = $inputData["Su_User"] ?? '';
            $aid = $inputData["Aid"] ?? '';
            $agUser = $inputData["Ag_User"] ?? '';
            $mid = $inputData["Mid"] ?? '';
            $payType = $inputData["Pay_Type"] ?? '';
            $reportKind = $inputData["Report_Kind"] ?? '';
            $resultType = $inputData["Result_Type"] ?? '';
            
            // 新增字段
            $totalBets = $inputData["TotalBets"] ?? '';
            $gType = $inputData["GType"] ?? '';
            $username = $inputData["Username"] ?? '';
            $pwd = $inputData["Pwd"] ?? '';
            $pwdSafe = $inputData["Pwd_Safe"] ?? '';
            $auto = $inputData["Auto"] ?? '';
            
            $stmt = $conn->prepare("INSERT INTO TelSms_BotConfig (BotId, AccountNoList, HgAdminList, Uid, Cookie, SelMaxId, Status, CreateDate, Memo, ActionName, Login_Layer, Langx, Ver, ActionP, Sid, Su_User, Aid, Ag_User, Mid, Pay_Type, Report_Kind, Result_Type, TotalBets, GType, Username, Pwd, Pwd_Safe, Auto) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("issssissssssssssssssssssssss", $botId, $accountNoList, $hgAdminList, $uid, $cookie, $selMaxId, $status, $createDate, $memo, $actionName, $loginLayer, $langx, $ver, $actionP, $sid, $suUser, $aid, $agUser, $mid, $payType, $reportKind, $resultType, $totalBets, $gType, $username, $pwd, $pwdSafe, $auto);
            
            if ($stmt->execute()) {
                echo json_encode(array("status" => "success", "message" => "添加成功"));
            } else {
                echo json_encode(array("status" => "error", "message" => "添加失败: " . $stmt->error));
            }
            $stmt->close();
            break;
            
        case "update":
            // 更新记录
            $id = $inputData["Id"];
            $botId = $inputData["BotId"];
            $accountNoList = $inputData["AccountNoList"];
            $hgAdminList = $inputData["HgAdminList"];
            $uid = $inputData["Uid"];
            $cookie = $inputData["Cookie"];
            $selMaxId = $inputData["SelMaxId"];
            $status = isset($inputData["Status"]) ? 1 : 0;
            $memo = $inputData["Memo"];
            
            // 原有扩展字段
            $actionName = $inputData["ActionName"] ?? '';
            $loginLayer = $inputData["Login_Layer"] ?? '';
            $langx = $inputData["Langx"] ?? '';
            $ver = $inputData["Ver"] ?? '';
            $actionP = $inputData["ActionP"] ?? '';
            $sid = $inputData["Sid"] ?? '';
            $suUser = $inputData["Su_User"] ?? '';
            $aid = $inputData["Aid"] ?? '';
            $agUser = $inputData["Ag_User"] ?? '';
            $mid = $inputData["Mid"] ?? '';
            $payType = $inputData["Pay_Type"] ?? '';
            $reportKind = $inputData["Report_Kind"] ?? '';
            $resultType = $inputData["Result_Type"] ?? '';
            
            // 新增字段
            $totalBets = $inputData["TotalBets"] ?? '';
            $gType = $inputData["GType"] ?? '';
            $username = $inputData["Username"] ?? '';
            $pwd = $inputData["Pwd"] ?? '';
            $pwdSafe = $inputData["Pwd_Safe"] ?? '';
            $auto = $inputData["Auto"] ?? '';
            
            $stmt = $conn->prepare("UPDATE TelSms_BotConfig SET BotId=?, AccountNoList=?, HgAdminList=?, Uid=?, Cookie=?, SelMaxId=?, Status=?, Memo=?, ActionName=?, Login_Layer=?, Langx=?, Ver=?, ActionP=?, Sid=?, Su_User=?, Aid=?, Ag_User=?, Mid=?, Pay_Type=?, Report_Kind=?, Result_Type=?, TotalBets=?, GType=?, Username=?, Pwd=?, Pwd_Safe=?, Auto=? WHERE Id=?");
            $stmt->bind_param("issssisssssssssssssssssssssi", $botId, $accountNoList, $hgAdminList, $uid, $cookie, $selMaxId, $status, $memo, $actionName, $loginLayer, $langx, $ver, $actionP, $sid, $suUser, $aid, $agUser, $mid, $payType, $reportKind, $resultType, $totalBets, $gType, $username, $pwd, $pwdSafe, $auto, $id);
            
            if ($stmt->execute()) {
                echo json_encode(array("status" => "success", "message" => "更新成功"));
            } else {
                echo json_encode(array("status" => "error", "message" => "更新失败: " . $stmt->error));
            }
            $stmt->close();
            break;
            
        case "delete":
            // 删除记录
            $id = $inputData["Id"];
            
            $stmt = $conn->prepare("DELETE FROM TelSms_BotConfig WHERE Id=?");
            $stmt->bind_param("i", $id);
            
            if ($stmt->execute()) {
                echo json_encode(array("status" => "success", "message" => "删除成功"));
            } else {
                echo json_encode(array("status" => "error", "message" => "删除失败: " . $stmt->error));
            }
            $stmt->close();
            break;
            
        case "view":
            // 查看记录
            $id = $inputData["Id"];
            
            $stmt = $conn->prepare("SELECT * FROM TelSms_BotConfig WHERE Id=?");
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows == 1) {
                $row = $result->fetch_assoc();
                echo json_encode(array("status" => "success", "data" => $row));
            } else {
                echo json_encode(array("status" => "error", "message" => "记录不存在"));
            }
            $stmt->close();
            break;
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Telegram Bot配置管理</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2563eb',
                        secondary: '#475569',
                        accent: '#f97316',
                        success: '#10b981',
                        danger: '#ef4444',
                        warning: '#f59e0b',
                        info: '#3b82f6',
                        light: '#f8fafc',
                        dark: '#1e293b',
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style type="text/tailwindcss">
        @layer utilities {
            .content-auto {
                content-visibility: auto;
            }
            .table-shadow {
                box-shadow: 0 4px 20px -2px rgba(0, 0, 0, 0.1);
            }
            .form-input-focus {
                @apply focus:ring-2 focus:ring-primary/50 focus:border-primary transition duration-200;
            }
            .btn-effect {
                @apply transform transition-all duration-200 hover:scale-[1.02] active:scale-[0.98];
            }
        }
    </style>
</head>
<body class="bg-gray-50 font-sans">
    <div class="min-h-screen flex flex-col">
        <!-- 顶部导航 -->
        <header class="bg-white shadow-sm sticky top-0 z-10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <i class="fa fa-telegram text-primary text-2xl mr-2"></i>
                        <h1 class="text-xl font-bold text-gray-800"><a href="index1.php">Telegram Bot配置管理</a></h1>
                    </div>
                    <div class="flex items-center space-x-4">
                        <button id="refreshBtn" class="btn-effect px-3 py-1 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-100 transition-colors duration-200">
                            <i class="fa fa-refresh mr-1"></i> 刷新
                        </button>
                        <button id="addBtn" class="btn-effect bg-primary hover:bg-primary/90 text-white px-4 py-1.5 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fa fa-plus mr-1"></i> 添加配置
                        </button>
                    </div>
                </div>
            </div>
        </header>

        <!-- 主内容区 -->
        <main class="flex-grow">
            <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
                <!-- 搜索和筛选 -->
                <div class="bg-white rounded-lg shadow-sm p-4 mb-6">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between space-y-4 md:space-y-0">
                        <div class="flex items-center space-x-2">
                            <div class="relative">
                                <input type="text" id="searchInput" placeholder="搜索..." class="form-input-focus block w-full pl-10 pr-4 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fa fa-search text-gray-400"></i>
                                </div>
                            </div>
                            <button id="searchBtn" class="btn-effect bg-gray-800 hover:bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                                <i class="fa fa-search mr-1"></i> 搜索
                            </button>
                        </div>
                        <div class="flex items-center space-x-2">
                            <select id="statusFilter" class="form-input-focus block w-full border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm px-3 py-2 bg-white">
                                <option value="">全部状态</option>
                                <option value="0">禁用</option>
                                <option value="1">启用</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- 数据列表 -->
                <div class="bg-white rounded-lg shadow-sm overflow-hidden table-shadow">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">BotID</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">AdminUserName</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">SelMaxId</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">账号列表</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">管理列表</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">状态</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">创建时间</th>
                                    <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">操作</th>
                                </tr>
                            </thead>
                            <tbody id="dataTableBody" class="bg-white divide-y divide-gray-200">
                                <!-- 数据将通过JavaScript动态加载 -->
                                <tr>
                                    <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                                        <div class="flex flex-col items-center">
                                            <i class="fa fa-database text-4xl mb-3 text-gray-300"></i>
                                            <p>暂无数据</p>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- 分页 -->
                    <div class="px-6 py-4 bg-white border-t border-gray-200 flex items-center justify-between">
                        <div class="flex-1 flex justify-between sm:hidden">
                            <button class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                                上一页
                            </button>
                            <button class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                                下一页
                            </button>
                        </div>
                        <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                            <div>
                                <p class="text-sm text-gray-700">
                                    显示第 <span class="font-medium">1</span> 到 <span class="font-medium">0</span> 条，共 <span class="font-medium">0</span> 条记录
                                </p>
                            </div>
                            <div>
                                <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px" aria-label="Pagination">
                                    <button class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                        <span class="sr-only">上一页</span>
                                        <i class="fa fa-chevron-left text-xs"></i>
                                    </button>
                                    <button class="relative inline-flex items-center px-4 py-2 border border-gray-300 bg-primary text-sm font-medium text-white">
                                        1
                                    </button>
                                    <button class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                        <span class="sr-only">下一页</span>
                                        <i class="fa fa-chevron-right text-xs"></i>
                                    </button>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <!-- 页脚 -->
        <footer class="bg-white border-t border-gray-200">
            <div class="max-w-7xl mx-auto py-4 px-4 sm:px-6 lg:px-8">
                <p class="text-center text-sm text-gray-500">© 2025 Telegram Bot配置管理系统. 保留所有权利.</p>
            </div>
        </footer>
    </div>

    <!-- 模态框 -->
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-5xl mx-4 transform transition-all max-h-[90vh] overflow-y-auto">
            <div class="flex items-center justify-between p-4 border-b border-gray-200 sticky top-0 bg-white z-10">
                <h3 id="modalTitle" class="text-lg font-medium text-gray-900">添加配置</h3>
                <button id="closeModal" class="text-gray-400 hover:text-gray-500 focus:outline-none">
                    <i class="fa fa-times text-xl"></i>
                </button>
            </div>
            <div id="modalContent" class="p-6">
                <form id="dataForm" class="space-y-6">
                    <input type="hidden" id="formId" name="Id">
                    
                    <!-- 第一行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label for="formBotId" class="block text-sm font-medium text-gray-700 mb-1">BotId <span class="text-red-500">*</span></label>
                            <input type="number" id="formBotId" name="BotId" required class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formStatus" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <div class="flex items-center pt-2">
                                <input type="checkbox" id="formStatus" name="Status" class="h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded">
                                <label for="formStatus" class="ml-2 block text-sm text-gray-700">启用</label>
                            </div>
                        </div>
                        
                        <div>
                            <label for="formSelMaxId" class="block text-sm font-medium text-gray-700 mb-1">SelMaxId</label>
                            <input type="number" id="formSelMaxId" name="SelMaxId" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formUid" class="block text-sm font-medium text-gray-700 mb-1">Uid <span class="text-red-500">*</span></label>
                            <input type="text" id="formUid" name="Uid" required class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formActionName" class="block text-sm font-medium text-gray-700 mb-1">ActionName</label>
                            <input type="text" id="formActionName" name="ActionName" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                    </div>
                    
                    <!-- 第二行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label for="formLoginLayer" class="block text-sm font-medium text-gray-700 mb-1">Login_Layer</label>
                            <input type="text" id="formLoginLayer" name="Login_Layer" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formLangx" class="block text-sm font-medium text-gray-700 mb-1">Langx</label>
                            <input type="text" id="formLangx" name="Langx" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formVer" class="block text-sm font-medium text-gray-700 mb-1">Ver</label>
                            <input type="text" id="formVer" name="Ver" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formActionP" class="block text-sm font-medium text-gray-700 mb-1">ActionP</label>
                            <input type="text" id="formActionP" name="ActionP" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formSid" class="block text-sm font-medium text-gray-700 mb-1">Sid</label>
                            <input type="text" id="formSid" name="Sid" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                    </div>
                    
                    <!-- 第三行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label for="formSuUser" class="block text-sm font-medium text-gray-700 mb-1">Su_User</label>
                            <input type="text" id="formSuUser" name="Su_User" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formAid" class="block text-sm font-medium text-gray-700 mb-1">Aid</label>
                            <input type="text" id="formAid" name="Aid" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formAgUser" class="block text-sm font-medium text-gray-700 mb-1">Ag_User</label>
                            <input type="text" id="formAgUser" name="Ag_User" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formMid" class="block text-sm font-medium text-gray-700 mb-1">Mid</label>
                            <input type="text" id="formMid" name="Mid" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formPayType" class="block text-sm font-medium text-gray-700 mb-1">Pay_Type</label>
                            <input type="text" id="formPayType" name="Pay_Type" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                    </div>
                    
                    <!-- 第四行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label for="formReportKind" class="block text-sm font-medium text-gray-700 mb-1">Report_Kind</label>
                            <input type="text" id="formReportKind" name="Report_Kind" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formResultType" class="block text-sm font-medium text-gray-700 mb-1">Result_Type</label>
                            <input type="text" id="formResultType" name="Result_Type" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formTotalBets" class="block text-sm font-medium text-gray-700 mb-1">TotalBets</label>
                            <input type="text" id="formTotalBets" name="TotalBets" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formGType" class="block text-sm font-medium text-gray-700 mb-1">GType</label>
                            <input type="text" id="formGType" name="GType" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formUsername" class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                            <input type="text" id="formUsername" name="Username" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                    </div>
                    
                    <!-- 第五行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label for="formPwd" class="block text-sm font-medium text-gray-700 mb-1">Pwd</label>
                            <input type="text" id="formPwd" name="Pwd" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formPwd_Safe" class="block text-sm font-medium text-gray-700 mb-1">Pwd_Safe</label>
                            <input type="text" id="formPwd_Safe" name="Pwd_Safe" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                        
                        <div>
                            <label for="formAuto" class="block text-sm font-medium text-gray-700 mb-1">Auto</label>
                            <input type="text" id="formAuto" name="Auto" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm">
                        </div>
                    </div>
                    
                    <!-- 单列文本区域 -->
                    <div>
                        <label for="formAccountNoList" class="block text-sm font-medium text-gray-700 mb-1">AccountNoList <span class="text-red-500">*</span></label>
                        <textarea id="formAccountNoList" name="AccountNoList" rows="2" required class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm"></textarea>
                        <p class="text-xs text-gray-500 mt-1">多个账号用逗号分隔</p>
                    </div>
                    
                    <!-- 单列文本区域 -->
                    <div>
                        <label for="formHgAdminList" class="block text-sm font-medium text-gray-700 mb-1">HgAdminList <span class="text-red-500">*</span></label>
                        <textarea id="formHgAdminList" name="HgAdminList" rows="2" required class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm"></textarea>
                        <p class="text-xs text-gray-500 mt-1">多个管理员用逗号分隔</p>
                    </div>
                    
                    <!-- 单列文本区域 -->
                    <div>
                        <label for="formCookie" class="block text-sm font-medium text-gray-700 mb-1">Cookie <span class="text-red-500">*</span></label>
                        <textarea id="formCookie" name="Cookie" rows="3" required class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm"></textarea>
                    </div>
                    
                    <!-- 单列文本区域 -->
                    <div>
                        <label for="formMemo" class="block text-sm font-medium text-gray-700 mb-1">Memo</label>
                        <textarea id="formMemo" name="Memo" rows="2" class="form-input-focus block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none text-sm"></textarea>
                    </div>
                </form>
            </div>
            <div class="p-4 border-t border-gray-200 flex justify-end space-x-3 sticky bottom-0 bg-white z-10">
                <button id="cancelModal" class="btn-effect px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                    取消
                </button>
                <button id="saveData" class="btn-effect px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary hover:bg-primary/90 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                    保存
                </button>
            </div>
        </div>
    </div>

    <!-- 查看详情模态框 -->
    <div id="viewModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-5xl mx-4 transform transition-all max-h-[90vh] overflow-y-auto">
            <div class="flex items-center justify-between p-4 border-b border-gray-200 sticky top-0 bg-white z-10">
                <h3 id="viewModalTitle" class="text-lg font-medium text-gray-900">配置详情</h3>
                <button id="closeViewModal" class="text-gray-400 hover:text-gray-500 focus:outline-none">
                    <i class="fa fa-times text-xl"></i>
                </button>
            </div>
            <div id="viewModalContent" class="p-6">
                <div class="space-y-6">
                    <!-- 第一行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">ID</label>
                            <p id="viewId" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">BotID</label>
                            <p id="viewBotId" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">SelMaxId</label>
                            <p id="viewSelMaxId" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Uid</label>
                            <p id="viewUid" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <p id="viewStatus" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                    </div>
                    
                    <!-- 第二行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">ActionName</label>
                            <p id="viewActionName" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Login_Layer</label>
                            <p id="viewLoginLayer" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Langx</label>
                            <p id="viewLangx" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Ver</label>
                            <p id="viewVer" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">ActionP</label>
                            <p id="viewActionP" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                    </div>
                    
                    <!-- 第三行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Sid</label>
                            <p id="viewSid" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Su_User</label>
                            <p id="viewSuUser" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Aid</label>
                            <p id="viewAid" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Ag_User</label>
                            <p id="viewAgUser" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Mid</label>
                            <p id="viewMid" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                    </div>
                    
                    <!-- 第四行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Pay_Type</label>
                            <p id="viewPayType" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Report_Kind</label>
                            <p id="viewReportKind" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Result_Type</label>
                            <p id="viewResultType" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">TotalBets</label>
                            <p id="viewTotalBets" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">GType</label>
                            <p id="viewGType" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                    </div>
                    
                    <!-- 第五行：5个字段 -->
                    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                            <p id="viewUsername" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Pwd</label>
                            <p id="viewPwd" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Pwd_Safe</label>
                            <p id="viewPwd_Safe" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Auto</label>
                            <p id="viewAuto" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                        </div>
                    </div>
                    
                    <!-- 单列详情 -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">AccountNoList</label>
                        <p id="viewAccountNoList" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md whitespace-pre-wrap"></p>
                    </div>
                    
                    <!-- 单列详情 -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">HgAdminList</label>
                        <p id="viewHgAdminList" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md whitespace-pre-wrap"></p>
                    </div>
                    
                    <!-- 单列详情 -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Cookie</label>
                        <p id="viewCookie" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md whitespace-pre-wrap"></p>
                    </div>
                    
                    <!-- 单列详情 -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">创建时间</label>
                        <p id="viewCreateDate" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md"></p>
                    </div>
                    
                    <!-- 单列详情 -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Memo</label>
                        <p id="viewMemo" class="text-sm text-gray-900 bg-gray-50 p-2 rounded-md whitespace-pre-wrap"></p>
                    </div>
                </div>
            </div>
            <div class="p-4 border-t border-gray-200 flex justify-end sticky bottom-0 bg-white z-10">
                <button id="closeViewBtn" class="btn-effect px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                    关闭
                </button>
            </div>
        </div>
    </div>

    <!-- 确认对话框 -->
    <div id="confirmModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-md mx-4 transform transition-all">
            <div class="p-6">
                <div class="text-center">
                    <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                        <i class="fa fa-exclamation-triangle text-red-500 text-xl"></i>
                    </div>
                    <h3 id="confirmTitle" class="text-lg leading-6 font-medium text-gray-900 mb-2">确认删除</h3>
                    <p id="confirmMessage" class="text-sm text-gray-500 mb-6">
                        你确定要删除这条记录吗？此操作不可撤销。
                    </p>
                </div>
                <div class="flex justify-center space-x-3">
                    <button id="cancelConfirm" class="btn-effect px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                        取消
                    </button>
                    <button id="confirmAction" class="btn-effect px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        确认删除
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- 通知组件 -->
    <div id="notification" class="fixed top-4 right-4 max-w-sm w-full bg-white rounded-lg shadow-lg overflow-hidden transform transition-all duration-300 ease-in-out translate-y-[-200%] opacity-0 z-50">
        <div class="p-4 flex items-start">
            <div id="notificationIcon" class="flex-shrink-0 h-6 w-6 mr-3 flex items-center justify-center rounded-full bg-green-100">
                <i class="fa fa-check text-green-500"></i>
            </div>
            <div class="ml-3">
                <h3 id="notificationTitle" class="text-sm font-medium text-gray-800">操作成功</h3>
                <div class="mt-1">
                    <p id="notificationMessage" class="text-sm text-gray-600">数据已成功保存</p>
                </div>
            </div>
            <button id="closeNotification" class="ml-auto flex-shrink-0 text-gray-400 hover:text-gray-600 focus:outline-none">
                <i class="fa fa-times"></i>
            </button>
        </div>
    </div>

    <script>
        // 当前操作ID
        let currentId = null;
        // 当前操作类型
        let currentAction = null;
        
        // 页面加载完成后执行
        document.addEventListener('DOMContentLoaded', function() {
            // 初始化数据
            loadData();
            
            // 绑定事件
            document.getElementById('addBtn').addEventListener('click', openAddForm);
            document.getElementById('refreshBtn').addEventListener('click', loadData);
            document.getElementById('closeModal').addEventListener('click', closeModal);
            document.getElementById('cancelModal').addEventListener('click', closeModal);
            document.getElementById('saveData').addEventListener('click', saveData);
            document.getElementById('closeViewModal').addEventListener('click', closeViewModal);
            document.getElementById('closeViewBtn').addEventListener('click', closeViewModal);
            document.getElementById('cancelConfirm').addEventListener('click', closeConfirmModal);
            document.getElementById('closeNotification').addEventListener('click', closeNotification);
            
            // 搜索功能
            document.getElementById('searchBtn').addEventListener('click', function() {
                loadData();
            });
            
            document.getElementById('searchInput').addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    loadData();
                }
            });
            
            document.getElementById('statusFilter').addEventListener('change', function() {
                loadData();
            });
        });
        
        // 加载数据
        function loadData() {
            const searchTerm = document.getElementById('searchInput').value;
            const statusFilter = document.getElementById('statusFilter').value;
            
            fetch('botadmin.php?action=list', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: 'list',
                    searchTerm: searchTerm,
                    statusFilter: statusFilter
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    renderDataTable(data.data);
                } else {
                    showNotification('错误', data.message, 'error');
                }
            })
            .catch(error => {
                showNotification('错误', '加载数据失败: ' + error.message, 'error');
            });
        }
        
        // 渲染数据表格
        function renderDataTable(data) {
            const tableBody = document.getElementById('dataTableBody');
            
            if (data.length === 0) {
                tableBody.innerHTML = `
                    <tr>
                        <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                            <div class="flex flex-col items-center">
                                <i class="fa fa-database text-4xl mb-3 text-gray-300"></i>
                                <p>暂无数据</p>
                            </div>
                        </td>
                    </tr>
                `;
                return;
            }
            
            let html = '';
            data.forEach(item => {
                const status = parseInt(item.Status);
                const statusClass = status ===2 ? 'bg-green-100 text-green-800' : (status === 3 ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800');
                const statusText = status === 2 ? '正常运行' : (status === 3 ? '账号异常' : '空闲');
                
                html += `
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">${item.Id}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.BotId}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.AdminUserName}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.SelMaxId}</td>
                        <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate">${item.AccountNoList}</td>
                        <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate">${item.HgAdminList}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full ${statusClass}">
                                ${statusText}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.CreateDate}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <button onclick="viewData(${item.Id})" class="text-gray-500 hover:text-gray-900 mr-3 transition-colors duration-150">
                                <i class="fa fa-eye"></i> 查看
                            </button>
                            <button onclick="openEditForm(${item.Id})" class="text-gray-500 hover:text-blue-700 mr-3 transition-colors duration-150">
                                <i class="fa fa-pencil"></i> 编辑
                            </button>
                            <button onclick="confirmDelete(${item.Id})" class="text-gray-500 hover:text-red-600 transition-colors duration-150">
                                <i class="fa fa-trash"></i> 删除
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            tableBody.innerHTML = html;
        }
        
        // 打开添加表单
        function openAddForm() {
            currentAction = 'add';
            currentId = null;
            
            document.getElementById('modalTitle').textContent = '添加配置';
            document.getElementById('dataForm').reset();
            document.getElementById('formStatus').checked = true; // 默认启用
            
            document.getElementById('modal').classList.remove('hidden');
            setTimeout(() => {
                document.querySelector('#modal > div').classList.add('scale-100');
                document.querySelector('#modal > div').classList.remove('scale-95');
            }, 10);
        }
        
        // 打开编辑表单
        function openEditForm(id) {
            currentAction = 'update';
            currentId = id;
            
            document.getElementById('modalTitle').textContent = '编辑配置';
            
            fetch('botadmin.php?action=view', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: 'view',
                    Id: id
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    const item = data.data;
                    
                    document.getElementById('formId').value = item.Id;
                    document.getElementById('formBotId').value = item.BotId;
                    document.getElementById('formAccountNoList').value = item.AccountNoList;
                    document.getElementById('formHgAdminList').value = item.HgAdminList;
                    document.getElementById('formUid').value = item.Uid;
                    document.getElementById('formCookie').value = item.Cookie;
                    document.getElementById('formSelMaxId').value = item.SelMaxId;
                    document.getElementById('formStatus').checked = item.Status === '1';
                    document.getElementById('formMemo').value = item.Memo;
                    
                    // 原有扩展字段的值
                    document.getElementById('formActionName').value = item.ActionName || '';
                    document.getElementById('formLoginLayer').value = item.Login_Layer || '';
                    document.getElementById('formLangx').value = item.Langx || '';
                    document.getElementById('formVer').value = item.Ver || '';
                    document.getElementById('formActionP').value = item.ActionP || '';
                    document.getElementById('formSid').value = item.Sid || '';
                    document.getElementById('formSuUser').value = item.Su_User || '';
                    document.getElementById('formAid').value = item.Aid || '';
                    document.getElementById('formAgUser').value = item.Ag_User || '';
                    document.getElementById('formMid').value = item.Mid || '';
                    document.getElementById('formPayType').value = item.Pay_Type || '';
                    document.getElementById('formReportKind').value = item.Report_Kind || '';
                    document.getElementById('formResultType').value = item.Result_Type || '';
                    
                    // 新添加字段的值
                    document.getElementById('formTotalBets').value = item.TotalBets || '';
                    document.getElementById('formGType').value = item.GType || '';
                    document.getElementById('formUsername').value = item.Username || '';
                    document.getElementById('formPwd').value = item.Pwd || '';
                    document.getElementById('formPwd_Safe').value = item.Pwd_Safe || '';
                    document.getElementById('formAuto').value = item.Auto || '';
                    
                    document.getElementById('modal').classList.remove('hidden');
                    setTimeout(() => {
                        document.querySelector('#modal > div').classList.add('scale-100');
                        document.querySelector('#modal > div').classList.remove('scale-95');
                    }, 10);
                } else {
                    showNotification('错误', data.message, 'error');
                }
            })
            .catch(error => {
                showNotification('错误', '加载数据失败: ' + error.message, 'error');
            });
        }
        
        // 查看数据详情
        function viewData(id) {
            fetch('botadmin.php?action=view', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: 'view',
                    Id: id
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    const item = data.data;
                    
                    document.getElementById('viewId').textContent = item.Id;
                    document.getElementById('viewBotId').textContent = item.BotId;
                    document.getElementById('viewAccountNoList').textContent = item.AccountNoList;
                    document.getElementById('viewHgAdminList').textContent = item.HgAdminList;
                    document.getElementById('viewUid').textContent = item.Uid;
                    document.getElementById('viewCookie').textContent = item.Cookie;
                    document.getElementById('viewSelMaxId').textContent = item.SelMaxId;
                    document.getElementById('viewStatus').textContent = item.Status === '1' ? '启用' : '禁用';
                    document.getElementById('viewCreateDate').textContent = item.CreateDate;
                    document.getElementById('viewMemo').textContent = item.Memo;
                    
                    // 原有扩展字段详情
                    document.getElementById('viewActionName').textContent = item.ActionName || '';
                    document.getElementById('viewLoginLayer').textContent = item.Login_Layer || '';
                    document.getElementById('viewLangx').textContent = item.Langx || '';
                    document.getElementById('viewVer').textContent = item.Ver || '';
                    document.getElementById('viewActionP').textContent = item.ActionP || '';
                    document.getElementById('viewSid').textContent = item.Sid || '';
                    document.getElementById('viewSuUser').textContent = item.Su_User || '';
                    document.getElementById('viewAid').textContent = item.Aid || '';
                    document.getElementById('viewAgUser').textContent = item.Ag_User || '';
                    document.getElementById('viewMid').textContent = item.Mid || '';
                    document.getElementById('viewPayType').textContent = item.Pay_Type || '';
                    document.getElementById('viewReportKind').textContent = item.Report_Kind || '';
                    document.getElementById('viewResultType').textContent = item.Result_Type || '';
                    
                    // 新添加字段详情
                    document.getElementById('viewTotalBets').textContent = item.TotalBets || '';
                    document.getElementById('viewGType').textContent = item.GType || '';
                    document.getElementById('viewUsername').textContent = item.Username || '';
                    document.getElementById('viewPwd').textContent = item.Pwd || '';
                    document.getElementById('viewPwd_Safe').textContent = item.Pwd_Safe || '';
                    document.getElementById('viewAuto').textContent = item.Auto || '';
                    
                    document.getElementById('viewModal').classList.remove('hidden');
                    setTimeout(() => {
                        document.querySelector('#viewModal > div').classList.add('scale-100');
                        document.querySelector('#viewModal > div').classList.remove('scale-95');
                    }, 10);
                } else {
                    showNotification('错误', data.message, 'error');
                }
            })
            .catch(error => {
                showNotification('错误', '加载数据失败: ' + error.message, 'error');
            });
        }
        
        // 确认删除
        function confirmDelete(id) {
            currentId = id;
            
            document.getElementById('confirmTitle').textContent = '确认删除';
            document.getElementById('confirmMessage').textContent = '你确定要删除这条记录吗？此操作不可撤销。';
            
            document.getElementById('confirmModal').classList.remove('hidden');
            setTimeout(() => {
                document.querySelector('#confirmModal > div').classList.add('scale-100');
                document.querySelector('#confirmModal > div').classList.remove('scale-95');
            }, 10);
        }
        
        // 关闭模态框
        function closeModal() {
            document.querySelector('#modal > div').classList.remove('scale-100');
            document.querySelector('#modal > div').classList.add('scale-95');
            
            setTimeout(() => {
                document.getElementById('modal').classList.add('hidden');
            }, 200);
        }
        
        // 关闭查看模态框
        function closeViewModal() {
            document.querySelector('#viewModal > div').classList.remove('scale-100');
            document.querySelector('#viewModal > div').classList.add('scale-95');
            
            setTimeout(() => {
                document.getElementById('viewModal').classList.add('hidden');
            }, 200);
        }
        
        // 关闭确认对话框
        function closeConfirmModal() {
            document.querySelector('#confirmModal > div').classList.remove('scale-100');
            document.querySelector('#confirmModal > div').classList.add('scale-95');
            
            setTimeout(() => {
                document.getElementById('confirmModal').classList.add('hidden');
            }, 200);
        }
        
        // 保存数据
        function saveData() {
            const formData = new FormData(document.getElementById('dataForm'));
            const data = Object.fromEntries(formData.entries());
            
            // 添加状态字段（checkbox可能未被包含在formData中）
            data.Status = document.getElementById('formStatus').checked ? 1 : 0;
            
            // 验证数据
            if (!data.BotId || !data.AccountNoList || !data.HgAdminList || !data.Uid || !data.Cookie) {
                showNotification('错误', '请填写所有必填字段', 'error');
                return;
            }
            
            // 根据当前操作类型决定是添加还是更新
            const action = currentAction === 'add' ? 'add' : 'update';
            
            fetch('botadmin.php?action=' + action, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: action,
                    ...data
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    showNotification('成功', data.message, 'success');
                    closeModal();
                    loadData();
                } else {
                    showNotification('错误', data.message, 'error');
                }
            })
            .catch(error => {
                showNotification('错误', '保存数据失败: ' + error.message, 'error');
            });
        }
        
        // 执行删除操作
        function confirmAction() {
            if (!currentId) return;
            
            fetch('botadmin.php?action=delete', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: 'delete',
                    Id: currentId
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    showNotification('成功', data.message, 'success');
                    closeConfirmModal();
                    loadData();
                } else {
                    showNotification('错误', data.message, 'error');
                }
            })
            .catch(error => {
                showNotification('错误', '删除数据失败: ' + error.message, 'error');
            });
        }
        
        // 显示通知
        function showNotification(title, message, type = 'success') {
            const notification = document.getElementById('notification');
            const notificationTitle = document.getElementById('notificationTitle');
            const notificationMessage = document.getElementById('notificationMessage');
            const notificationIcon = document.getElementById('notificationIcon');
            
            notificationTitle.textContent = title;
            notificationMessage.textContent = message;
            
            // 设置图标和背景颜色
            if (type === 'success') {
                notificationIcon.className = 'flex-shrink-0 h-6 w-6 mr-3 flex items-center justify-center rounded-full bg-green-100';
                notificationIcon.innerHTML = '<i class="fa fa-check text-green-500"></i>';
            } else if (type === 'error') {
                notificationIcon.className = 'flex-shrink-0 h-6 w-6 mr-3 flex items-center justify-center rounded-full bg-red-100';
                notificationIcon.innerHTML = '<i class="fa fa-times text-red-500"></i>';
            } else if (type === 'warning') {
                notificationIcon.className = 'flex-shrink-0 h-6 w-6 mr-3 flex items-center justify-center rounded-full bg-yellow-100';
                notificationIcon.innerHTML = '<i class="fa fa-exclamation text-yellow-500"></i>';
            } else if (type === 'info') {
                notificationIcon.className = 'flex-shrink-0 h-6 w-6 mr-3 flex items-center justify-center rounded-full bg-blue-100';
                notificationIcon.innerHTML = '<i class="fa fa-info text-blue-500"></i>';
            }
            
            // 显示通知
            notification.classList.remove('translate-y-[-200%]', 'opacity-0');
            notification.classList.add('translate-y-0', 'opacity-100');
            
            // 自动关闭
            setTimeout(() => {
                closeNotification();
            }, 5000);
        }
        
        // 关闭通知
        function closeNotification() {
            const notification = document.getElementById('notification');
            notification.classList.remove('translate-y-0', 'opacity-100');
            notification.classList.add('translate-y-[-200%]', 'opacity-0');
        }
        
        // 为确认按钮添加事件监听
        document.getElementById('confirmAction').addEventListener('click', confirmAction);
    </script>
</body>
</html>
