<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

// 启动会话
session_start();

// 验证登录状态
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权访问，请先登录']);
    exit;
}

// 引入数据库连接
require_once '../db_connect.php';

try {
    // 获取请求数据
    $input = json_decode(file_get_contents('php://input'), true);
    
    // 验证参数
    if (!isset($input['Id']) || !isset($input['BetStatus'])) {
        echo json_encode(['status' => 'error', 'message' => '缺少必要的参数']);
        exit;
    }
    
    $orderId = $input['Id'];
    $betStatus = (int)$input['BetStatus'];
    
    // 验证状态值
    if ($betStatus != 0 && $betStatus != 1) {
        echo json_encode(['status' => 'error', 'message' => '推荐状态值必须为0或1']);
        exit;
    }
    
    // 更新订单推荐状态
    $stmt = $pdo->prepare("UPDATE TelSms_BetList SET BetStatus = :status WHERE Id = :id");
    $stmt->bindValue(':status', $betStatus, PDO::PARAM_INT);
    $stmt->bindValue(':id', $orderId);
    $stmt->execute();
    
    if ($stmt->rowCount() == 0) {
        echo json_encode(['status' => 'error', 'message' => '未找到指定的订单或状态未发生变化']);
        exit;
    }
    
    // 返回结果
    echo json_encode([
        'status' => 'success',
        'message' => $betStatus == 1 ? '已成功设为推荐数据' : '已成功取消推荐',
        'affected' => $stmt->rowCount()
    ]);
} catch(PDOException $e) {
    // 输出错误信息
    echo json_encode([
        'status' => 'error',
        'message' => '更新推荐状态失败: ' . $e->getMessage()
    ]);
}

// 关闭连接
$pdo = null;
?>
    