<?php
header('Content-Type: application/json; charset=utf-8');
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); // 允许所有域名
header("Access-Control-Allow-Methods: GET, POST"); // 允许的请求方法
header("Access-Control-Allow-Headers: Content-Type"); // 允许的头部

require_once '../db_connect.php';

$response = ['status' => 'error', 'message' => '未知错误'];

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['BotId'])) {
    $BotId = (int)$_GET['BotId'];
   // $ActionName = $_GET['ActionName'];

    try {
        $stmt = $pdo->prepare("SELECT * FROM TelSms_BotConfig WHERE BotId = :BotId");
        $stmt->execute([':BotId' => $BotId]);
        $botconfig = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$botconfig) {
            $response['message'] = '机器不存在';
            echo json_encode($response);
            exit;
        }

        $response = [
            'status' => 'success',
            'data' => $botconfig
        ];
    } catch (PDOException $e) {
        $response['message'] = '数据库错误: ' . $e->getMessage();
    }
}

header('Content-Type: application/json');
echo json_encode($response);
?>
    