<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

// 启动会话
session_start();

// 验证登录状态
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权访问，请先登录']);
    exit;
}

// 引入数据库连接
require_once '../db_connect.php';

try {
    // 验证参数
    if (!isset($_GET['Id']) || empty($_GET['Id'])) {
        echo json_encode(['status' => 'error', 'message' => '缺少订单ID参数']);
        exit;
    }
    
    $orderId = $_GET['Id'];
    
    // 查询订单详情
    $stmt = $pdo->prepare("SELECT * FROM TelSms_BetList WHERE Id = :id");
    $stmt->bindValue(':id', $orderId);
    $stmt->execute();
    
    $order = $stmt->fetch();
    
    if (!$order) {
        echo json_encode(['status' => 'error', 'message' => '未找到指定的订单']);
        exit;
    }
    
    // 返回结果
    echo json_encode([
        'status' => 'success',
        'data' => $order
    ]);
} catch(PDOException $e) {
    // 输出错误信息
    echo json_encode([
        'status' => 'error',
        'message' => '获取订单详情失败: ' . $e->getMessage()
    ]);
}

// 关闭连接
$pdo = null;
?>
    