<?php
require_once '../db_connect.php';

$response = ['status' => 'error', 'message' => '未知错误'];

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['Id'])) {
    $id = (int)$_GET['Id'];

    try {
        $stmt = $pdo->prepare("SELECT * FROM TelSms_Account WHERE Id = :Id");
        $stmt->execute([':Id' => $id]);
        $account = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$account) {
            $response['message'] = '账号不存在';
            echo json_encode($response);
            exit;
        }

        // 解析Roles字段
        $roles = explode(',', $account['Roles']);
        $account['autoSendMatch'] = (bool)$roles[0];
        $account['autoSendReport'] = (bool)$roles[1];
        $account['sendAdmin'] = (bool)$roles[2];

        // 计算有效期天数
        $startDate = new DateTime($account['StartDate']);
        $endDate = new DateTime($account['EndDate']);
        $interval = $startDate->diff($endDate);
        $account['validity_days'] = $interval->days;

        $response = [
            'status' => 'success',
            'data' => $account
        ];
    } catch (PDOException $e) {
        $response['message'] = '数据库错误: ' . $e->getMessage();
    }
}

header('Content-Type: application/json');
echo json_encode($response);
?>
    