<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

// 启动会话
session_start();

// 验证登录状态
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权访问，请先登录']);
    exit;
}

// 引入数据库连接
require_once '../db_connect.php';

try {
    // 获取请求数据
    $input = json_decode(file_get_contents('php://input'), true);
    
    // 验证参数
    if (!isset($input['Id'])) {
        echo json_encode(['status' => 'error', 'message' => '缺少订单ID参数']);
        exit;
    }
    
    $orderId = $input['Id'];
    
    // 删除订单
    $stmt = $pdo->prepare("DELETE FROM TelSms_BetList WHERE Id = :id");
    $stmt->bindValue(':id', $orderId);
    $stmt->execute();
    
    if ($stmt->rowCount() == 0) {
        echo json_encode(['status' => 'error', 'message' => '未找到指定的订单']);
        exit;
    }
    
    // 返回结果
    echo json_encode([
        'status' => 'success',
        'message' => '订单已成功删除',
        'affected' => $stmt->rowCount()
    ]);
} catch(PDOException $e) {
    // 输出错误信息
    echo json_encode([
        'status' => 'error',
        'message' => '删除订单失败: ' . $e->getMessage()
    ]);
}

// 关闭连接
$pdo = null;
?>
    