<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

// 启动会话
session_start();

// 验证登录状态
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权访问，请先登录']);
    exit;
}

// 引入数据库连接
require_once '../db_connect.php';

try {
    // 获取请求参数
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
    $offset = ($page - 1) * $limit;
    
    // 构建查询条件
    $conditions = [];
    $params = [];
    
    // 软件账号
    if (!empty($_GET['accountno'])) {
        $conditions[] = "AccountNo = :accountno";
        $params[':accountno'] = $_GET['accountno'];
    }
    
    // 订单会员
    if (!empty($_GET['betaccount'])) {
        $conditions[] = "BetAccount = :betaccount";
        $params[':betaccount'] = $_GET['betaccount'];
    }
    
    // 球队
    if (!empty($_GET['betteamv'])) {
        $conditions[] = "BetTeamV LIKE :betteamv";
        $params[':betteamv'] = "%" . $_GET['betteamv'] . "%";
    }
    
    // 金额
    if (!empty($_GET['betamount'])) {
        $conditions[] = "BetAmount = :betamount";
        $params[':betamount'] = $_GET['betamount'];
    }
    
    // 订单时间
    if (!empty($_GET['bettime'])) {
        $conditions[] = "DATE(BetTime) = :bettime";
        $params[':bettime'] = $_GET['bettime'];
    }
    
    // 推送时间
    if (!empty($_GET['sendtime'])) {
        $conditions[] = "DATE(SendTime) = :sendtime";
        $params[':sendtime'] = $_GET['sendtime'];
    }
    
    // 构建WHERE子句
    $whereClause = "";
    if (!empty($conditions)) {
        $whereClause = "WHERE " . implode(" AND ", $conditions);
    }
    
    // 查询总记录数
    $totalStmt = $pdo->prepare("SELECT COUNT(*) as total FROM TelSms_BetList {$whereClause}");
    $totalStmt->execute($params);
    $totalResult = $totalStmt->fetch();
    $total = (int)$totalResult['total'];
    
    // 计算总页数
    $totalPages = ceil($total / $limit);
    
    // 查询订单数据
    $stmt = $pdo->prepare("SELECT * FROM TelSms_BetList {$whereClause} ORDER BY Id DESC LIMIT :limit OFFSET :offset");
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    
    // 绑定查询参数
    foreach ($params as $key => $value) {
        $stmt->bindValue($key, $value);
    }
    
    $stmt->execute();
    $orders = $stmt->fetchAll();
    
    // 获取统计数据
    $statsStmt = $pdo->prepare("
        SELECT 
            COUNT(*) as total,
            SUM(CASE WHEN SmsStatus = 1 THEN 1 ELSE 0 END) as sent,
            SUM(CASE WHEN SmsStatus = 0 THEN 1 ELSE 0 END) as unsent,
            SUM(CASE WHEN BetStatus = 1 THEN 1 ELSE 0 END) as recommended
        FROM TelSms_BetList {$whereClause}
    ");
    $statsStmt->execute($params);
    $stats = $statsStmt->fetch();
    
    // 返回结果
    echo json_encode([
        'status' => 'success',
        'data' => $orders,
        'total' => $total,
        'pages' => $totalPages,
        'current_page' => $page,
        'stats' => $stats
    ]);
} catch(PDOException $e) {
    // 输出错误信息
    echo json_encode([
        'status' => 'error',
        'message' => '获取订单列表失败: ' . $e->getMessage()
    ]);
}

// 关闭连接
$pdo = null;
?>
    