<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

// 启动会话
session_start();

// 验证登录状态
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权访问，请先登录']);
    exit;
}

// 引入数据库连接
require_once '../db_connect.php';

try {
    // 获取请求数据
    $input = json_decode(file_get_contents('php://input'), true);
    
    // 验证参数
    if (!isset($input['ids']) || !is_array($input['ids']) || empty($input['ids'])) {
        echo json_encode(['status' => 'error', 'message' => '请提供有效的订单ID数组']);
        exit;
    }
    
    if (!isset($input['BetStatus'])) {
        echo json_encode(['status' => 'error', 'message' => '缺少推荐状态参数']);
        exit;
    }
    
    $ids = $input['ids'];
    $betStatus = (int)$input['BetStatus'];
    
    // 验证状态值
    if ($betStatus != 0 && $betStatus != 1) {
        echo json_encode(['status' => 'error', 'message' => '推荐状态值必须为0或1']);
        exit;
    }
    
    // 构建参数化查询
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $sql = "UPDATE TelSms_BetList SET BetStatus = ? WHERE Id IN ({$placeholders})";
    
    // 准备参数数组
    $params = array_merge([$betStatus], $ids);
    
    // 执行更新
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    
    $affected = $stmt->rowCount();
    
    if ($affected == 0) {
        echo json_encode(['status' => 'error', 'message' => '未找到指定的订单或状态未发生变化']);
        exit;
    }
    
    // 返回结果
    echo json_encode([
        'status' => 'success',
        'message' => $betStatus == 1 ? '已成功设置推荐数据' : '已成功取消推荐',
        'affected' => $affected
    ]);
} catch(PDOException $e) {
    // 输出错误信息
    echo json_encode([
        'status' => 'error',
        'message' => '批量更新推荐状态失败: ' . $e->getMessage()
    ]);
}

// 关闭连接
$pdo = null;
?>
    