<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

// 启动会话
session_start();

// 验证登录状态
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权访问，请先登录']);
    exit;
}

// 引入数据库连接
require_once '../db_connect.php';

try {
    // 获取请求数据
    $input = json_decode(file_get_contents('php://input'), true);
    
    // 验证参数
    if (!isset($input['ids']) || !is_array($input['ids']) || empty($input['ids'])) {
        echo json_encode(['status' => 'error', 'message' => '请提供有效的订单ID数组']);
        exit;
    }
    
    $ids = $input['ids'];
    
    // 构建参数化查询
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $sql = "DELETE FROM TelSms_BetList WHERE Id IN ({$placeholders})";
    
    // 执行删除
    $stmt = $pdo->prepare($sql);
    $stmt->execute($ids);
    
    $affected = $stmt->rowCount();
    
    if ($affected == 0) {
        echo json_encode(['status' => 'error', 'message' => '未找到指定的订单']);
        exit;
    }
    
    // 返回结果
    echo json_encode([
        'status' => 'success',
        'message' => "已成功删除 {$affected} 条订单",
        'affected' => $affected
    ]);
} catch(PDOException $e) {
    // 输出错误信息
    echo json_encode([
        'status' => 'error',
        'message' => '批量删除订单失败: ' . $e->getMessage()
    ]);
}

// 关闭连接
$pdo = null;
?>
    