
<?php
// 放在页面最顶部，确保在任何输出之前执行
require_once '../db.php';
require_once '../session_check.php';

?>
<?php
require_once 'config.php';
require_once 'functions.php';


try {
    $pdo = new PDO("mysql:host=$dbHost;port=$dbPort;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("数据库连接失败: " . $e->getMessage());
}

// 处理操作请求
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 重置超时时间
    set_time_limit(60);
    
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'open':
                $botId = trim($_POST['bot_id'] ?? '');
                $url = trim($_POST['url'] ?? '');
                $count = (int)($_POST['count'] ?? 0);
                $count = max(1, min($count, MAX_INSTANCES - count(getRunningInstances())));
                
                if (!empty($botId) && $count > 0) {
                    $result = openBrowsers($botId, $count, $url);
                    addLog("尝试打开 {$count} 个采集机器人（BotId: {$botId}）：" . ($result['success'] ? '成功' : $result['error']));
                } else {
                    $error = "请输入有效的BotId和数量（1-{$count}）";
                }
                break;
                
            case 'close':
                $instanceId = $_POST['instance_id'] ?? '';
                if ($instanceId) {
                    $success = closeBrowser($instanceId);
                    addLog("尝试关闭实例 {$instanceId}：" . ($success ? '成功' : '失败'));
                }
                break;
                
            case 'close_all':
                $success = closeAllBrowsers();
                addLog("尝试关闭所有实例：" . ($success ? '成功' : '失败'));
                break;
                
            case 'update_extension':
                $content = $_POST['extension_content'] ?? '';
                if (!empty($content)) {
                    file_put_contents(EXTENSION_PATH . '\content.js', $content);
                    $instances = getRunningInstances();
                    $updated = 0;
                    foreach ($instances as $instance) {
                        if (sendReloadCommand("ws://127.0.0.1:{$instance['port']}/devtools/browser")) {
                            $updated++;
                        }
                    }
                    addLog("更新插件并尝试刷新 {$updated}/" . count($instances) . " 个实例");
                    $successMsg = "插件已更新，正在刷新 {$updated} 个实例";
                }
                break;
        }
    }
}

// 获取当前运行的实例列表
$instances = getRunningInstances();
// 获取插件内容
$extensionContent = file_get_contents(EXTENSION_PATH . '\content.js');
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Telegram机器人管理 - 比赛数据推送</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#165DFF',
                        secondary: '#FF4D4F',
                        success: '#52C41A',
                        neutral: '#1D2129',
                        'neutral-light': '#4E5969',
                        'neutral-lighter': '#86909C',
                        'neutral-lightest': '#F2F3F5'
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style type="text/tailwindcss">
        @layer utilities {
            .content-auto {
                content-visibility: auto;
            }
            .card-shadow {
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            }
            .tab-active {
                border-bottom: 2px solid #165DFF;
                color: #165DFF;
                font-weight: 500;
            }
            .notice-slide {
                animation: slideDown 0.3s ease-out forwards;
            }
            @keyframes slideDown {
                from { transform: translateY(-100%); opacity: 0; }
                to { transform: translateY(0); opacity: 1; }
            }
            .instance-card {
                transition: transform 0.2s, box-shadow 0.2s;
            }
            .instance-card:hover {
                transform: translateY(-2px);
                box-shadow: 0 6px 24px rgba(0, 0, 0, 0.12);
            }
        }
    </style>
</head>
<body class="bg-neutral-lightest min-h-screen font-sans">
    <!-- 顶部导航栏 -->
    <header class="bg-white shadow-md fixed top-0 left-0 right-0 z-10 transition-all duration-300">
        <div class="container mx-auto px-4 py-3 flex items-center justify-between">
            <div class="flex items-center space-x-2">
                <i class="fa fa-bolt text-primary text-xl"></i>
                <h1 class="text-lg font-bold text-neutral">系统配置</h1>
            </div>
            <div class="flex items-center space-x-4">
                <button id="refreshBtn" class="text-primary hover:text-primary/80 transition-colors">
                    <i class="fa fa-refresh"></i>
                </button>
                <a href="bet_my.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" class="text-neutral-light hover:text-neutral transition-colors">
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
        </div>
        
        <!-- 标签页导航 - 保持与前一页面一致的4个标签 -->
        <div class="bg-white border-t border-gray-100">
            <div class="container mx-auto">
                <div class="flex overflow-x-auto scrollbar-hide">
                    <a href="../my_config.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" 
                       class="tab-link flex-1 py-3 px-4 text-center">
                        Telegram群
                    </a>
                    <a href="../my_config_hg.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>"   
                       class="tab-link flex-1 py-3 px-4 text-center">
                        HG子账号
                    </a>
                    <a href="index.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" 
                       class="tab-link flex-1 py-3 px-4 text-center tab-active">
                        Telegram机器人
                    </a>
                    <a href="../admin1/index.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" 
                       class="tab-link flex-1 py-3 px-4 text-center">
                        HG机器人
                    </a>
                </div>
            </div>
        </div>
    </header>

    <!-- 提示信息容器 -->
    <div id="noticeContainer" class="fixed top-28 left-0 right-0 z-50 px-4 pointer-events-none"></div>

    <!-- 主内容区 -->
    <main class="container mx-auto px-4 pt-32 pb-32">
        <h2 class="text-xl font-bold text-neutral mb-6">Telegram机器人管理</h2>
        
        <!-- 打开浏览器表单卡片 -->
        <div class="bg-white rounded-xl p-6 mb-6 card-shadow">
            <h3 class="text-lg font-medium text-neutral mb-4">打开Telegram机器人</h3>
            
            <form method="post" class="space-y-4">
                <input type="hidden" name="action" value="open">
                
                <div>
                    <label for="bot_id" class="block text-sm font-medium text-neutral-light mb-1">Telegram机器人推送BotId <span class="text-secondary">*</span></label>
                    <select id="bot_id" name="bot_id" required
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/50 focus:border-primary transition-colors">
                        <option value="">请选择BotId</option>
                        <?php
                        // 从$instances中提取已存在的BotId
                        $exampleBotIds = is_array($instances) ? array_column($instances, 'botId') : [];
                        $exampleBotIds = array_unique($exampleBotIds);
                        
                        if (!$pdo) {
                            error_log("数据库连接失败");
                            echo "<option value=''>数据库连接错误，请稍后重试</option>";
                        } else {
                            // 查询AccountNo并排除已存在的示例BotId
                            $username = $_SESSION['admin_username'];
                            $sql = "SELECT DISTINCT AccountNo FROM TelSms_Account where UserName='$username' ORDER BY AccountNo";
                            $stmt = $pdo->query($sql);
                            
                            if ($stmt) {
                                $accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                if (!empty($accounts)) {
                                    foreach($accounts as $row) {
                                        $accountNo = $row['AccountNo'];
                                        if (!in_array($accountNo, $exampleBotIds)) {
                                            echo "<option value=\"{$accountNo}\">{$accountNo}</option>";
                                        }
                                    }
                                } else {
                                    echo "<option value=''>暂无可用BotId</option>";
                                }
                                $stmt = null;
                            } else {
                                $errorInfo = $pdo->errorInfo();
                                error_log("BotId查询失败: " . $errorInfo[2]);
                                echo "<option value=''>查询失败，请稍后重试</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
                
                <!-- 隐藏字段保持功能完整性 -->
                <div style="display: none;">
                    <label for="url" class="block text-sm font-medium text-neutral-light mb-1">Url</label>
                    <input type="text" id="url" name="url" value="http://localhost/index2.php" 
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/50 focus:border-primary transition-colors"
                        required>
                </div>
                
                <div style="display: none;">
                    <label for="count" class="block text-sm font-medium text-neutral-light mb-1">打开数量</label>
                    <input type="number" id="count" name="count" min="1" max="1" value="1" 
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/50 focus:border-primary transition-colors"
                        required>
                </div>
                
                <div class="text-sm text-neutral-lighter mb-4">
                    当前还可打开：<span class="text-primary font-medium"><?php echo MAX_INSTANCES - count($instances); ?></span> 个
                </div>
                
                <button type="submit" id="openBotBtn" class="bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg transition-colors flex items-center" <?php echo (MAX_INSTANCES - count($instances) < 1) ? 'disabled' : ''; ?>>
                    <i class="fa fa-play mr-2"></i> 打开Telegram机器人
                </button>
            </form>
            
            <!-- 运行中Modal -->
            <div id="runningModal" class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 hidden">
                <div class="bg-white rounded-xl p-6 w-full max-w-md">
                    <div class="text-center">
                        <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-primary/10 text-primary mb-4">
                            <i class="fa fa-spinner fa-spin text-3xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-neutral mb-2">正在打开Telegram机器人</h3>
                        <p class="text-neutral-light">请稍候，系统正在处理您的请求...</p>
                    </div>
                </div>
            </div>
            
            <!-- 操作反馈信息 -->
            <?php if (isset($error)): ?>
                <div class="mt-4 p-3 bg-secondary/10 text-secondary rounded-lg text-sm">
                    <i class="fa fa-exclamation-circle mr-1"></i> <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($result) && $result['success']): ?>
                <div class="mt-4 p-3 bg-success/10 text-success rounded-lg text-sm">
                    <i class="fa fa-check-circle mr-1"></i> 成功打开 <?php echo $result['count']; ?> 个飞机推送机器人实例
                </div>
            <?php endif; ?>
        </div>

        <!-- 运行中实例列表 -->
        <div class="bg-white rounded-xl p-6 card-shadow">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-medium text-neutral">当前运行的Telegram机器人实例</h3>
                <span class="text-sm bg-primary/10 text-primary px-2 py-1 rounded-full">
                    共 <?php echo count($instances); ?> 个
                </span>
            </div>
            
            <?php if (count($instances) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-neutral-lighter uppercase tracking-wider">
                                    Telegram机器人BotId
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-neutral-lighter uppercase tracking-wider">
                                    端口
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-neutral-lighter uppercase tracking-wider">
                                    启动时间
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-neutral-lighter uppercase tracking-wider">
                                    操作
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php foreach ($instances as $instance): ?>
                            <tr class="instance-card">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-neutral"><?php echo $instance['botId']; ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-neutral"><?php echo $instance['port']; ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-neutral"><?php echo date('Y-m-d H:i:s', $instance['startTime']); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <form method="post" onsubmit="return confirm('确定要关闭这个实例吗？');">
                                        <input type="hidden" name="action" value="close">
                                        <input type="hidden" name="instance_id" value="<?php echo $instance['id']; ?>">
                                        <button type="submit" class="text-secondary hover:text-secondary/80 transition-colors flex items-center">
                                            <i class="fa fa-stop mr-1"></i> 关闭
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- 关闭所有按钮 -->
                <div class="mt-6">
                    <form method="post" onsubmit="return confirm('确定要关闭所有Telegram机器人吗？');">
                        <input type="hidden" name="action" value="close_all">
                        <button type="submit" class="bg-secondary hover:bg-secondary/90 text-white px-4 py-2 rounded-lg transition-colors flex items-center">
                            <i class="fa fa-stop-circle mr-2"></i> 关闭所有Telegram机器人
                        </button>
                    </form>
                </div>
            <?php else: ?>
                <div class="text-center py-10 bg-neutral-lightest rounded-lg">
                    <i class="fa fa-robot text-4xl text-neutral-lighter mb-3"></i>
                    <p class="text-neutral-lighter">暂无运行中的Telegram机器人</p>
                    <p class="text-xs text-neutral-lighter mt-1">使用上方表单打开新的机器人实例</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- 插件管理（保持隐藏） -->
        <div class="bg-white rounded-xl p-6 mt-6 card-shadow" style="display: none;">
            <h3 class="text-lg font-medium text-neutral mb-4">插件管理</h3>
            <form method="post" class="space-y-4">
                <input type="hidden" name="action" value="update_extension1">
                <div>
                    <label for="extension_content" class="block text-sm font-medium text-neutral-light mb-1">插件代码</label>
                    <textarea id="extension_content" name="extension_content" 
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/50 focus:border-primary transition-colors"
                        rows="8"><?php echo htmlspecialchars($extensionContent); ?></textarea>
                </div>
                <button type="submit" class="bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg transition-colors">
                    更新并重新加载插件
                </button>
                <?php if (isset($successMsg)): ?>
                    <div class="p-3 bg-success/10 text-success rounded-lg text-sm">
                        <i class="fa fa-check-circle mr-1"></i> <?php echo $successMsg; ?>
                    </div>
                <?php endif; ?>
            </form>
        </div>

        <!-- 操作日志（保持隐藏） -->
        <div class="bg-white rounded-xl p-6 mt-6 card-shadow" style="display: none;">
            <h3 class="text-lg font-medium text-neutral mb-4">操作日志</h3>
            <div class="p-4 bg-neutral-lightest rounded-lg max-h-60 overflow-y-auto font-mono text-sm">
                <?php //echo getLatestLogs(20); ?>
            </div>
        </div>
    </main>

    <!-- 底部导航 - 与前一页面保持一致 -->
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 py-2 px-4 z-20">
        <div class="flex justify-around">
            <a href="../bet_list.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" class="flex flex-col items-center text-neutral-light">
                <i class="fa fa-home text-lg"></i>
                <span class="text-xs mt-1">首页</span>
            </a>
            <a href="../bet_good.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" class="flex flex-col items-center text-neutral-light">
                <i class="fa fa-line-chart text-lg"></i>
                <span class="text-xs mt-1">数据</span>
            </a>
            <a href="../bet_result.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" class="flex flex-col items-center text-neutral-light">
                <i class="fa fa-trophy text-lg"></i>
                <span class="text-xs mt-1">结果</span>
            </a>
            <a href="../bet_notice.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" class="flex flex-col items-center text-neutral-light">
                <i class="fa fa-bell text-lg"></i>
                <span class="text-xs mt-1">通知</span>
            </a>
            <a href="../bet_my.php?AccountNo=<?php echo isset($_GET['AccountNo']) ? urlencode($_GET['AccountNo']) : ''; ?>" class="flex flex-col items-center text-secondary">
                <i class="fa fa-user text-lg"></i>
                <span class="text-xs mt-1">我的</span>
            </a>
        </div>
    </nav>

    <script>
        // 显示通知函数
        function showNotice(message, type = 'success') {
            const noticeContainer = document.getElementById('noticeContainer');
            const existingNotices = noticeContainer.querySelectorAll('div');
            existingNotices.forEach(notice => notice.remove());
            
            const notice = document.createElement('div');
            notice.className = `bg-${type === 'success' ? 'success' : 'secondary'} text-white py-2 px-4 notice-slide pointer-events-auto`;
            notice.innerHTML = `
                <div class="container mx-auto">
                    <div class="flex items-center">
                        <i class="fa ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-2"></i>
                        <span>${message}</span>
                        <button class="ml-auto text-white hover:text-white/80 close-notice">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            `;
            
            noticeContainer.appendChild(notice);
            
            notice.querySelector('.close-notice').addEventListener('click', () => {
                notice.style.opacity = '0';
                setTimeout(() => notice.remove(), 300);
            });
            
            setTimeout(() => {
                notice.style.opacity = '0';
                setTimeout(() => notice.remove(), 300);
            }, 3000);
        }

        // 显示运行中Modal
        function showRunningModal() {
            document.getElementById('runningModal').classList.remove('hidden');
        }

        // 隐藏运行中Modal
        function hideRunningModal() {
            document.getElementById('runningModal').classList.add('hidden');
        }

        // 禁用打开按钮
        function disableOpenButton() {
            const btn = document.getElementById('openBotBtn');
            btn.disabled = true;
            btn.classList.add('opacity-50', 'cursor-not-allowed');
            btn.classList.remove('hover:bg-primary/90');
        }

        // 启用打开按钮
        function enableOpenButton() {
            const btn = document.getElementById('openBotBtn');
            btn.disabled = false;
            btn.classList.remove('opacity-50', 'cursor-not-allowed');
            btn.classList.add('hover:bg-primary/90');
        }

        // 更新按钮状态
        function updateOpenButtonState() {
            const btn = document.getElementById('openBotBtn');
            const availableCount = <?php echo MAX_INSTANCES - count($instances); ?>;
            if (availableCount < 1) {
                disableOpenButton();
            } else {
                enableOpenButton();
            }
        }

        // 刷新按钮功能
        document.getElementById('refreshBtn').addEventListener('click', function() {
            window.location.reload();
        });
        
        // 页面加载完成后更新按钮状态
        updateOpenButtonState();

        // 表单提交处理
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form[method="post"]');
            const openBtn = document.getElementById('openBotBtn');
            
            // 检查初始状态
            const availableCount = <?php echo MAX_INSTANCES - count($instances); ?>;
            if (availableCount < 1) {
                disableOpenButton();
            }
            
            form.addEventListener('submit', function(e) {
                e.preventDefault(); // 阻止默认提交
                
                // 检查是否可打开
                if (availableCount < 1) {
                    showNotice('当前无可打开的机器人实例', 'error');
                    return;
                }
                
                // 禁用按钮并显示运行中Modal
                disableOpenButton();
                showRunningModal();
                
                // 使用AJAX提交表单
                const formData = new FormData(form);
                
                fetch(window.location.href, {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    // 隐藏运行中Modal
                    hideRunningModal();
                    // 启用按钮
                    enableOpenButton();
                    
                    // 尝试解析JSON响应
                    try {
                        const jsonData = JSON.parse(data);
                        if (jsonData.success) {
                            showNotice('操作成功完成', 'success');
                            // 延迟刷新页面以显示更新
                            setTimeout(() => window.location.reload(), 1000);
                        } else {
                            showNotice(jsonData.message || '操作失败，请重试', 'error');
                        }
                    } catch (e) {
                        // 如果不是JSON响应，检查是否有success消息
                        if (data.includes('成功打开')) {
                            showNotice('操作成功完成', 'success');
                            // 延迟刷新页面以显示更新
                            setTimeout(() => window.location.reload(), 1000);
                        } else {
                            showNotice('操作失败，请重试', 'error');
                        }
                    }
                })
                .catch(error => {
                    // 隐藏运行中Modal
                    hideRunningModal();
                    // 启用按钮
                    enableOpenButton();
                    showNotice('网络错误，请重试', 'error');
                });
            });
            
            <?php if (isset($successMsg)): ?>
                showNotice('<?php echo addslashes($successMsg); ?>', 'success');
            <?php endif; ?>
        });
    </script>
</body>
</html>